/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.utils.LoggingKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.DependencyGraphWalker;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020 H\u0007J\n\u0010!\u001a\u0004\u0018\u00010 H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\u0014\u0010\u0019\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\f\u00a8\u0006\""}, d2={"Lcom/autonomousapps/tasks/DependencyGraphPerVariant;", "Lorg/gradle/api/DefaultTask;", "()V", "compileClasspath", "Lorg/gradle/api/artifacts/Configuration;", "getCompileClasspath", "()Lorg/gradle/api/artifacts/Configuration;", "setCompileClasspath", "(Lorg/gradle/api/artifacts/Configuration;)V", "compileOutputDot", "Lorg/gradle/api/file/RegularFileProperty;", "getCompileOutputDot", "()Lorg/gradle/api/file/RegularFileProperty;", "compileOutputJson", "getCompileOutputJson", "jarAttr", "Lorg/gradle/api/provider/Property;", "", "getJarAttr", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "testCompileClasspath", "getTestCompileClasspath", "setTestCompileClasspath", "testCompileOutputDot", "getTestCompileOutputDot", "testCompileOutputJson", "getTestCompileOutputJson", "action", "", "getCompileClasspathArtifacts", "Lorg/gradle/api/file/FileCollection;", "getTestCompileClasspathArtifacts", "dependency-analysis-gradle-plugin"})
public abstract class DependencyGraphPerVariant
extends DefaultTask {
    public Configuration compileClasspath;
    @Nullable
    private Configuration testCompileClasspath;

    @Internal
    @NotNull
    public abstract Property<String> getJarAttr();

    @Classpath
    @NotNull
    public final FileCollection getCompileClasspathArtifacts() {
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"compileClasspath\n    .incoming");
        Object object = this.getJarAttr().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jarAttr.get()");
        ArtifactCollection artifactCollection = ArtifactViewsKt.artifactViewFor(resolvableDependencies, (String)object).getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"compileClasspath\n    .in\u2026ttr.get())\n    .artifacts");
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"compileClasspath\n    .in\u2026ifacts\n    .artifactFiles");
        return fileCollection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Optional
    @Classpath
    @Nullable
    public final FileCollection getTestCompileClasspathArtifacts() {
        Configuration configuration = this.testCompileClasspath;
        Configuration configuration2 = configuration;
        if (configuration == null) return null;
        ResolvableDependencies resolvableDependencies = configuration2.getIncoming();
        configuration2 = resolvableDependencies;
        if (resolvableDependencies == null) return null;
        Object object = this.getJarAttr().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jarAttr.get()");
        ArtifactView artifactView = ArtifactViewsKt.artifactViewFor((ResolvableDependencies)configuration2, (String)object);
        configuration2 = artifactView;
        if (artifactView == null) return null;
        ArtifactCollection artifactCollection = configuration2.getArtifacts();
        configuration2 = artifactCollection;
        if (artifactCollection == null) return null;
        FileCollection fileCollection = configuration2.getArtifactFiles();
        return fileCollection;
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Internal
    @NotNull
    public final Configuration getCompileClasspath() {
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        return configuration;
    }

    public final void setCompileClasspath(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        this.compileClasspath = configuration;
    }

    @Internal
    @Nullable
    public final Configuration getTestCompileClasspath() {
        return this.testCompileClasspath;
    }

    public final void setTestCompileClasspath(@Nullable Configuration configuration) {
        this.testCompileClasspath = configuration;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getCompileOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getTestCompileOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getCompileOutputDot();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getTestCompileOutputDot();

    @TaskAction
    public final void action() {
        DependencyGraph dependencyGraph;
        File compileOutputJsonFile = UtilsKt.getAndDelete(this.getCompileOutputJson());
        File testCompileOutputJsonFile = UtilsKt.getAndDelete(this.getTestCompileOutputJson());
        File compileOutputDotFile = UtilsKt.getAndDelete(this.getCompileOutputDot());
        File testCompileOutputDotFile = UtilsKt.getAndDelete(this.getTestCompileOutputDot());
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        DependencyGraph compileGraph = new DependencyGraphWalker(configuration).getGraph();
        Configuration configuration2 = this.testCompileClasspath;
        if (configuration2 != null) {
            Configuration configuration3 = configuration2;
            boolean bl = false;
            boolean bl2 = false;
            Configuration it = configuration3;
            boolean bl3 = false;
            dependencyGraph = new DependencyGraphWalker(it).getGraph();
        } else {
            dependencyGraph = null;
        }
        DependencyGraph testCompileGraph = dependencyGraph;
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        LoggingKt.log(logger, "Compile graph JSON at " + compileOutputJsonFile.getPath());
        DependencyGraph $this$toJson$iv = compileGraph;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"adapter");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)compileOutputJsonFile, (String)string, null, (int)2, null);
        Logger logger2 = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        LoggingKt.log(logger2, "Graph DOT at " + compileOutputDotFile.getPath());
        FilesKt.writeText$default((File)compileOutputDotFile, (String)GraphWriter.INSTANCE.toDot(compileGraph), null, (int)2, null);
        if (testCompileGraph != null) {
            Logger logger3 = this.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
            LoggingKt.log(logger3, "Test compile graph JSON at " + testCompileOutputJsonFile.getPath());
            $this$toJson$iv = testCompileGraph;
            withNulls$iv = false;
            $i$f$toJson = false;
            $i$f$getJsonAdapter = false;
            adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
            JsonAdapter jsonAdapter2 = adapter$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter2, (String)"adapter");
            String string2 = jsonAdapter2.toJson((Object)$this$toJson$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
            FilesKt.writeText$default((File)testCompileOutputJsonFile, (String)string2, null, (int)2, null);
            Logger logger4 = this.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger4, (String)"logger");
            LoggingKt.log(logger4, "Graph DOT at " + testCompileOutputDotFile.getPath());
            FilesKt.writeText$default((File)testCompileOutputDotFile, (String)GraphWriter.INSTANCE.toDot(testCompileGraph), null, (int)2, null);
        }
    }

    public DependencyGraphPerVariant() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces the dependency graph, for a given variant, for the current project");
    }
}

