/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.ibm.icu.impl.number;

import shadow.com.ibm.icu.impl.StandardPlural;
import shadow.com.ibm.icu.impl.number.AffixPatternProvider;
import shadow.com.ibm.icu.impl.number.PatternStringParser;
import shadow.com.ibm.icu.text.CurrencyPluralInfo;

public class CurrencyPluralInfoAffixProvider
implements AffixPatternProvider {
    private final AffixPatternProvider[] affixesByPlural = new PatternStringParser.ParsedPatternInfo[StandardPlural.COUNT];

    public CurrencyPluralInfoAffixProvider(CurrencyPluralInfo cpi) {
        for (StandardPlural plural : StandardPlural.VALUES) {
            this.affixesByPlural[plural.ordinal()] = PatternStringParser.parseToPatternInfo(cpi.getCurrencyPluralPattern(plural.getKeyword()));
        }
    }

    @Override
    public char charAt(int flags, int i2) {
        int pluralOrdinal = flags & 0xFF;
        return this.affixesByPlural[pluralOrdinal].charAt(flags, i2);
    }

    @Override
    public int length(int flags) {
        int pluralOrdinal = flags & 0xFF;
        return this.affixesByPlural[pluralOrdinal].length(flags);
    }

    @Override
    public String getString(int flags) {
        int pluralOrdinal = flags & 0xFF;
        return this.affixesByPlural[pluralOrdinal].getString(flags);
    }

    @Override
    public boolean positiveHasPlusSign() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].positiveHasPlusSign();
    }

    @Override
    public boolean hasNegativeSubpattern() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasNegativeSubpattern();
    }

    @Override
    public boolean negativeHasMinusSign() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].negativeHasMinusSign();
    }

    @Override
    public boolean hasCurrencySign() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasCurrencySign();
    }

    @Override
    public boolean containsSymbolType(int type) {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].containsSymbolType(type);
    }

    @Override
    public boolean hasBody() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasBody();
    }
}

