/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AnnotationAnalyzer;
import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.FieldAnalyzer;
import com.autonomousapps.internal.MethodAnalyzer;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.asm.FieldVisitor;
import com.autonomousapps.internal.asm.MethodVisitor;
import com.autonomousapps.internal.asm.TypePath;
import com.autonomousapps.internal.utils.RegexKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001b0\u001aJ\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\bH\u0002JK\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010$\u001a\u0004\u0018\u00010\b2\u0010\u0010%\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\u001a\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0019H\u0016J8\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\b2\b\u0010#\u001a\u0004\u0018\u00010\b2\b\u00100\u001a\u0004\u0018\u000101H\u0016JE\u00102\u001a\u0002032\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\b2\b\u0010#\u001a\u0004\u0018\u00010\b2\u0010\u00104\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010&H\u0016\u00a2\u0006\u0002\u00105J\u001c\u00106\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u00107\u001a\u0004\u0018\u00010\bH\u0016J,\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020 2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\f\u00a8\u0006<"}, d2={"Lcom/autonomousapps/internal/ClassAnalyzer;", "Lcom/autonomousapps/internal/asm/ClassVisitor;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "annotationAnalyzer", "Lcom/autonomousapps/internal/AnnotationAnalyzer;", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "classes", "", "getClasses", "()Ljava/util/Set;", "fieldAnalyzer", "Lcom/autonomousapps/internal/FieldAnalyzer;", "methodAnalyzer", "Lcom/autonomousapps/internal/MethodAnalyzer;", "source", "getSource", "setSource", "addClass", "", "Lkotlin/Pair;", "", "log", "msg", "visit", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitAnnotation", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "descriptor", "visible", "", "visitEnd", "visitField", "Lcom/autonomousapps/internal/asm/FieldVisitor;", "value", "", "visitMethod", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/autonomousapps/internal/asm/MethodVisitor;", "visitSource", "debug", "visitTypeAnnotation", "typeRef", "typePath", "Lcom/autonomousapps/internal/asm/TypePath;", "dependency-analysis-gradle-plugin"})
public final class ClassAnalyzer
extends ClassVisitor {
    @Nullable
    private String source;
    public String className;
    @NotNull
    private final Set<String> classes;
    private final MethodAnalyzer methodAnalyzer;
    private final FieldAnalyzer fieldAnalyzer;
    private final AnnotationAnalyzer annotationAnalyzer;
    private final Logger logger;

    @Nullable
    public final String getSource() {
        return this.source;
    }

    public final void setSource(@Nullable String string) {
        this.source = string;
    }

    @NotNull
    public final String getClassName() {
        String string = this.className;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        }
        return string;
    }

    public final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    @NotNull
    public final Set<String> getClasses() {
        return this.classes;
    }

    @NotNull
    public final Pair<String, Set<String>> classes() {
        return TuplesKt.to((Object)this.source, this.classes);
    }

    private final void addClass(String className) {
        AsmKt.access$addClass(this.classes, className);
    }

    private final void log(String msg) {
        if (AsmKt.access$getLogDebug$p()) {
            this.logger.debug(msg);
        } else {
            this.logger.warn(msg);
        }
    }

    @Override
    public void visitSource(@Nullable String source, @Nullable String debug) {
        this.log("- visitSource: source=" + source + " debug=" + debug);
        this.source = source;
    }

    @Override
    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.log("ClassAnalyzer#visit: " + name + " extends " + superName);
        this.className = name;
        this.addClass('L' + superName + ';');
        if (interfaces != null) {
            String[] $this$forEach$iv = interfaces;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String i2 = element$iv = stringArray[j];
                boolean bl = false;
                this.addClass('L' + i2 + ';');
            }
        }
    }

    @Override
    @NotNull
    public FieldVisitor visitField(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
        this.log("ClassAnalyzer#visitField: " + descriptor + ' ' + name);
        this.addClass(descriptor);
        return this.fieldAnalyzer;
    }

    @Override
    @NotNull
    public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        this.log("ClassAnalyzer#visitMethod: " + name + ' ' + descriptor);
        String string = descriptor;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)it, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult result = (MatchResult)element$iv;
                boolean bl4 = false;
                this.addClass(result.getValue());
            }
        }
        return this.methodAnalyzer;
    }

    @Override
    @NotNull
    public AnnotationVisitor visitAnnotation(@Nullable String descriptor, boolean visible) {
        this.log("ClassAnalyzer#visitAnnotation: descriptor=" + descriptor + " visible=" + visible);
        this.addClass(descriptor);
        return this.annotationAnalyzer;
    }

    @Override
    @NotNull
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String descriptor, boolean visible) {
        this.log("ClassAnalyzer#visitTypeAnnotation: typeRef=" + typeRef + " typePath=" + typePath + " descriptor=" + descriptor + " visible=" + visible);
        this.addClass(descriptor);
        return this.annotationAnalyzer;
    }

    @Override
    public void visitEnd() {
        this.log("\n");
    }

    public ClassAnalyzer(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(524288);
        this.logger = logger;
        boolean bl = false;
        this.classes = new LinkedHashSet();
        this.methodAnalyzer = new MethodAnalyzer(this.logger, this.classes);
        this.fieldAnalyzer = new FieldAnalyzer(this.logger, this.classes);
        this.annotationAnalyzer = new AnnotationAnalyzer(this.logger, this.classes, 0, 4, null);
    }
}

