/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AnalyzedClass;
import com.autonomousapps.internal.AnalyzedJar;
import com.autonomousapps.internal.AndroidLinterDependency;
import com.autonomousapps.internal.Artifact;
import com.autonomousapps.internal.ClassNameAndAnnotationsVisitor;
import com.autonomousapps.internal.Component;
import com.autonomousapps.internal.JarAnalyzerKt;
import com.autonomousapps.internal.asm.ClassReader;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.KtFile;
import com.autonomousapps.services.InMemoryCache;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003*\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/internal/JarAnalyzer;", "", "artifacts", "", "Lcom/autonomousapps/internal/Artifact;", "androidLinters", "", "Lcom/autonomousapps/internal/AndroidLinterDependency;", "logger", "Lorg/gradle/api/logging/Logger;", "inMemoryCache", "Lcom/autonomousapps/services/InMemoryCache;", "(Ljava/util/List;Ljava/util/Set;Lorg/gradle/api/logging/Logger;Lcom/autonomousapps/services/InMemoryCache;)V", "analyzeJar", "Lcom/autonomousapps/internal/AnalyzedJar;", "artifact", "components", "Lcom/autonomousapps/internal/Component;", "asComponents", "", "dependency-analysis-gradle-plugin"})
public final class JarAnalyzer {
    private final List<Artifact> artifacts;
    private final Set<AndroidLinterDependency> androidLinters;
    private final Logger logger;
    private final InMemoryCache inMemoryCache;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> components() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.artifacts;
        JarAnalyzer jarAnalyzer = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Artifact it = (Artifact)element$iv$iv;
            boolean bl = false;
            String string = it.getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.file.name");
            if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return jarAnalyzer.asComponents(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Component> asComponents(Iterable<Artifact> $this$asComponents) {
        void $this$mapTo$iv$iv;
        Iterable<Artifact> $this$map$iv = $this$asComponents;
        boolean $i$f$map = false;
        Iterable<Artifact> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void artifact;
            Artifact artifact2 = (Artifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnalyzedJar analyzedJar = this.analyzeJar((Artifact)artifact);
            Component component = new Component((Artifact)artifact, analyzedJar);
            collection.add(component);
        }
        return kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final AnalyzedJar analyzeJar(Artifact artifact) {
        void $this$onEach$iv;
        Iterable $this$mapToOrderedSet$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        AnalyzedClass it;
        Object object;
        ClassNameAndAnnotationsVisitor classEntry;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ZipFile zip = new ZipFile(artifact.getFile());
        String string = zip.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zip.name");
        AnalyzedJar alreadyAnalyzedJar = this.inMemoryCache.analyzedJar$dependency_analysis_gradle_plugin(string);
        if (alreadyAnalyzedJar != null) {
            return alreadyAnalyzedJar;
        }
        String string2 = zip.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"zip.name");
        this.inMemoryCache.updateJars$dependency_analysis_gradle_plugin(string2);
        List<KtFile> ktFiles = KtFile.Companion.fromZip(zip);
        Object object2 = CollectionsKt.asClassFiles(zip);
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ClassReader classReader;
            ZipEntry zipEntry = (ZipEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ClassNameAndAnnotationsVisitor classNameAndAnnotationsVisitor = new ClassNameAndAnnotationsVisitor(this.logger);
            boolean bl2 = false;
            boolean bl3 = false;
            ClassNameAndAnnotationsVisitor $this$apply = classNameAndAnnotationsVisitor;
            boolean bl4 = false;
            Closeable closeable = zip.getInputStream((ZipEntry)((Object)classEntry));
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = null;
            try {
                InputStream it2 = (InputStream)closeable;
                boolean bl7 = false;
                InputStream inputStream = it2;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                classReader = new ClassReader(ByteStreamsKt.readBytes((InputStream)inputStream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ClassReader reader = classReader;
            reader.accept($this$apply, 0);
            object = classNameAndAnnotationsVisitor;
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            classEntry = (ClassNameAndAnnotationsVisitor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((ClassNameAndAnnotationsVisitor)((Object)it)).getAnalyzedClass$dependency_analysis_gradle_plugin();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (AnalyzedClass)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it.getClassName(), (String)"java/", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$mapToOrderedSet = false;
        $this$filterNotTo$iv$iv = $this$mapToOrderedSet$iv;
        destination$iv$iv = new TreeSet();
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AnalyzedClass)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = AnalyzedClass.copy$default(it, StringsKt.replace$default((String)it.getClassName(), (String)"/", (String)".", (boolean)false, (int)4, null), null, null, null, false, null, null, null, null, 510, null);
            collection.add(object);
        }
        $this$mapToOrderedSet$iv = (Set)destination$iv$iv;
        boolean $i$f$onEach = false;
        var8_7 = $this$onEach$iv;
        boolean destination$iv$iv2 = false;
        $i$f$mapTo = false;
        void $this$apply$iv = var8_7;
        boolean bl = false;
        for (Object element$iv : $this$apply$iv) {
            AnalyzedClass it3 = (AnalyzedClass)element$iv;
            boolean bl8 = false;
            this.inMemoryCache.updateClasses$dependency_analysis_gradle_plugin(it3.getClassName());
        }
        Set analyzedClasses = (Set)var8_7;
        object2 = new AnalyzedJar(analyzedClasses, ktFiles, JarAnalyzerKt.access$findLinter(artifact.getDependency(), this.androidLinters));
        boolean bl9 = false;
        boolean bl10 = false;
        Object it4 = object2;
        boolean bl11 = false;
        String string3 = zip.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"zip.name");
        this.inMemoryCache.analyzedJars$dependency_analysis_gradle_plugin(string3, (AnalyzedJar)it4);
        return object2;
    }

    public JarAnalyzer(@NotNull List<Artifact> artifacts, @NotNull Set<AndroidLinterDependency> androidLinters, @NotNull Logger logger, @NotNull InMemoryCache inMemoryCache2) {
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter(androidLinters, (String)"androidLinters");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)inMemoryCache2, (String)"inMemoryCache");
        this.artifacts = artifacts;
        this.androidLinters = androidLinters;
        this.logger = logger;
        this.inMemoryCache = inMemoryCache2;
    }
}

