/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.graph;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/internal/graph/LazyDependencyGraph;", "", "files", "", "", "Ljava/io/File;", "(Ljava/util/Map;)V", "projectGraphMap", "", "Lcom/autonomousapps/graph/DependencyGraph;", "getDependencyGraph", "projectPath", "getDependencyGraphOrNull", "nullableGraph", "dependency-analysis-gradle-plugin"})
public final class LazyDependencyGraph {
    private final Map<String, DependencyGraph> projectGraphMap;
    private final Map<String, File> files;

    @NotNull
    public final DependencyGraph getDependencyGraph(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        DependencyGraph dependencyGraph = this.nullableGraph(projectPath);
        if (dependencyGraph == null) {
            throw (Throwable)new FileNotFoundException("No graph file found for " + projectPath);
        }
        return dependencyGraph;
    }

    @Nullable
    public final DependencyGraph getDependencyGraphOrNull(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.nullableGraph(projectPath);
    }

    private final DependencyGraph nullableGraph(String projectPath) {
        DependencyGraph dependencyGraph;
        Map<String, DependencyGraph> $this$getOrPut$iv = this.projectGraphMap;
        boolean $i$f$getOrPut = false;
        DependencyGraph value$iv = $this$getOrPut$iv.get(projectPath);
        if (value$iv == null) {
            DependencyGraph dependencyGraph2;
            boolean bl = false;
            File file = this.files.get(projectPath);
            if (file != null) {
                File $this$fromJson$iv = file;
                boolean $i$f$fromJson = false;
                String $this$fromJson$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv, null, (int)1, null);
                boolean $i$f$fromJson2 = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter adapter$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
                JsonAdapter jsonAdapter = adapter$iv$iv$iv;
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
                Object object = jsonAdapter.fromJson($this$fromJson$iv$iv);
                Intrinsics.checkNotNull((Object)object);
                dependencyGraph2 = (DependencyGraph)object;
            } else {
                dependencyGraph2 = null;
            }
            DependencyGraph answer$iv = dependencyGraph2;
            $this$getOrPut$iv.put(projectPath, answer$iv);
            dependencyGraph = answer$iv;
        } else {
            dependencyGraph = value$iv;
        }
        return dependencyGraph;
    }

    public LazyDependencyGraph(@NotNull Map<String, ? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.files = files;
        boolean bl = false;
        this.projectGraphMap = new LinkedHashMap();
    }
}

