/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.DependencyGraphKt;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.internal.utils.LoggingKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/DependencyGraphAllVariants;", "Lorg/gradle/api/DefaultTask;", "()V", "graphs", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getGraphs", "()Lorg/gradle/api/provider/ListProperty;", "outputDot", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputDot", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJson", "getOutputJson", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class DependencyGraphAllVariants
extends DefaultTask {
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getGraphs();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$mapTo$iv$iv;
        File outputJsonFile = UtilsKt.getAndDelete(this.getOutputJson());
        File outputDotFile = UtilsKt.getAndDelete(this.getOutputDot());
        Object object = this.getGraphs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"graphs.get()");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File $this$fromJson$iv$iv;
            void $this$fromJson$iv;
            void it;
            RegularFile regularFile = (RegularFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            boolean $i$f$fromJson = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv.getAsFile(), (String)"asFile");
            boolean $i$f$fromJson2 = false;
            String $this$fromJson$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv, null, (int)1, null);
            boolean $i$f$fromJson3 = false;
            boolean withNulls$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
            JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            Object object2 = jsonAdapter.fromJson($this$fromJson$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object2);
            DependencyGraph dependencyGraph = (DependencyGraph)object2;
            collection.add(dependencyGraph);
        }
        DependencyGraph graph = DependencyGraphKt.merge((List)destination$iv$iv);
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        LoggingKt.log(logger, "Graph JSON at " + outputJsonFile.getPath());
        DependencyGraph $this$toJson$iv = graph;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)outputJsonFile, (String)string, null, (int)2, null);
        Logger logger2 = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        LoggingKt.log(logger2, "Graph DOT at " + outputDotFile.getPath());
        FilesKt.writeText$default((File)outputDotFile, (String)GraphWriter.INSTANCE.toDot(graph), null, (int)2, null);
    }

    public DependencyGraphAllVariants() {
        this.setGroup("dependency-analysis");
        this.setDescription("Produces the dependency graph for the current project");
    }
}

