/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.autonomousapps.model.SourceSetKind;
import com.autonomousapps.model.intermediates.Variant;
import com.autonomousapps.tasks.GraphViewBuilder;
import com.autonomousapps.tasks.GraphWriter;
import com.google.common.graph.Graph;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/autonomousapps/tasks/GraphViewTask;", "Lorg/gradle/api/DefaultTask;", "()V", "compileClasspath", "Lorg/gradle/api/artifacts/Configuration;", "jarAttr", "Lorg/gradle/api/provider/Property;", "", "getJarAttr", "()Lorg/gradle/api/provider/Property;", "kind", "Lcom/autonomousapps/model/SourceSetKind;", "getKind", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "getOutputDot", "projectPath", "getProjectPath", "variant", "getVariant", "action", "", "getCompileClasspath", "Lorg/gradle/api/file/FileCollection;", "setCompileClasspath", "dependency-analysis-gradle-plugin"})
public abstract class GraphViewTask
extends DefaultTask {
    private Configuration compileClasspath;

    public final void setCompileClasspath(@NotNull Configuration compileClasspath) {
        Intrinsics.checkNotNullParameter((Object)compileClasspath, (String)"compileClasspath");
        this.compileClasspath = compileClasspath;
    }

    @Internal
    @NotNull
    public abstract Property<String> getJarAttr();

    @Classpath
    @NotNull
    public final FileCollection getCompileClasspath() {
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        Object object = this.getJarAttr().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jarAttr.get()");
        FileCollection fileCollection = ArtifactViewsKt.artifactsFor(configuration, (String)object).getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"compileClasspath\n    .ar\u2026get())\n    .artifactFiles");
        return fileCollection;
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Input
    @NotNull
    public abstract Property<String> getVariant();

    @Input
    @NotNull
    public abstract Property<SourceSetKind> getKind();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    @TaskAction
    public final void action() {
        DependencyGraphView graphView;
        File output = UtilsKt.getAndDelete(this.getOutput());
        File outputDot = UtilsKt.getAndDelete(this.getOutputDot());
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        Graph<Coordinates> graph = new GraphViewBuilder(configuration).getGraph();
        Object object = this.getVariant().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.get()");
        String string = (String)object;
        Object object2 = this.getKind().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"kind.get()");
        Variant variant2 = new Variant(string, (SourceSetKind)((Object)object2));
        Configuration configuration2 = this.compileClasspath;
        if (configuration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        String string2 = configuration2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"compileClasspath.name");
        DependencyGraphView $this$toJson$iv = graphView = new DependencyGraphView(variant2, string2, graph);
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraphView.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
        String string3 = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)output, (String)string3, null, (int)2, null);
        FilesKt.writeText$default((File)outputDot, (String)GraphWriter.INSTANCE.toDot(graph), null, (int)2, null);
    }

    public GraphViewTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Constructs a variant-specific view of this project's dependency graph");
    }
}

