/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.LazyKt;
import com.autonomousapps.model.AndroidLinterCapability;
import com.autonomousapps.model.AndroidManifestCapability;
import com.autonomousapps.model.AndroidResCapability;
import com.autonomousapps.model.AndroidResSource;
import com.autonomousapps.model.AnnotationProcessorCapability;
import com.autonomousapps.model.Capability;
import com.autonomousapps.model.ClassCapability;
import com.autonomousapps.model.ConstantCapability;
import com.autonomousapps.model.Dependency;
import com.autonomousapps.model.InferredCapability;
import com.autonomousapps.model.InlineMemberCapability;
import com.autonomousapps.model.KtFile;
import com.autonomousapps.model.NativeLibCapability;
import com.autonomousapps.model.ProjectVariant;
import com.autonomousapps.model.SecurityProviderCapability;
import com.autonomousapps.model.ServiceLoaderCapability;
import com.autonomousapps.model.intermediates.Bucket;
import com.autonomousapps.model.intermediates.DependencyTraceReport;
import com.autonomousapps.model.intermediates.Reason;
import com.autonomousapps.tasks.AnnotationProcessorDetector;
import com.autonomousapps.tasks.GraphVisitor;
import com.autonomousapps.visitor.GraphViewVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/autonomousapps/tasks/GraphVisitor;", "Lcom/autonomousapps/visitor/GraphViewVisitor;", "project", "Lcom/autonomousapps/model/ProjectVariant;", "(Lcom/autonomousapps/model/ProjectVariant;)V", "report", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "getReport", "()Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "reportBuilder", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport$Builder;", "isAbi", "", "classCapability", "Lcom/autonomousapps/model/ClassCapability;", "context", "Lcom/autonomousapps/visitor/GraphViewVisitor$Context;", "isImplementation", "isImported", "isRuntimeAndroid", "capability", "Lcom/autonomousapps/model/AndroidManifestCapability;", "usesAnnotationProcessor", "Lcom/autonomousapps/model/AnnotationProcessorCapability;", "usesConstant", "Lcom/autonomousapps/model/ConstantCapability;", "usesInlineMember", "Lcom/autonomousapps/model/InlineMemberCapability;", "usesResByRes", "Lcom/autonomousapps/model/AndroidResCapability;", "usesResBySource", "visit", "", "dependency", "Lcom/autonomousapps/model/Dependency;", "dependency-analysis-gradle-plugin"})
final class GraphVisitor
implements GraphViewVisitor {
    private final DependencyTraceReport.Builder reportBuilder;

    @NotNull
    public final DependencyTraceReport getReport() {
        return this.reportBuilder.build();
    }

    @Override
    public void visit(@NotNull Dependency dependency, @NotNull GraphViewVisitor.Context context) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isAnnotationProcessor = false;
        boolean isAnnotationProcessorCandidate = false;
        boolean isApiCandidate = false;
        boolean isImplCandidate = false;
        boolean isImplByImportCandidate = false;
        boolean isUnusedCandidate = false;
        boolean isLintJar = false;
        boolean isCompileOnlyCandidate = false;
        boolean isRuntimeAndroid = false;
        boolean usesResBySource = false;
        boolean usesResByRes = false;
        boolean usesConstant2 = false;
        boolean usesInlineMember2 = false;
        boolean hasServiceLoader = false;
        boolean hasSecurityProvider = false;
        boolean hasNativeLib = false;
        Iterable $this$forEach$iv = dependency.getCapabilities().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Collection collection;
            Unit unit;
            Capability capability = (Capability)element$iv;
            boolean bl2 = false;
            Capability capability2 = capability;
            if (capability2 instanceof AndroidLinterCapability) {
                isLintJar = ((AndroidLinterCapability)capability).isLintJar();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidManifestCapability) {
                isRuntimeAndroid = this.isRuntimeAndroid((AndroidManifestCapability)capability);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidResCapability) {
                usesResBySource = this.usesResBySource((AndroidResCapability)capability, context);
                usesResByRes = this.usesResByRes((AndroidResCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AnnotationProcessorCapability) {
                isAnnotationProcessor = true;
                isAnnotationProcessorCandidate = this.usesAnnotationProcessor((AnnotationProcessorCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ClassCapability) {
                if (this.isAbi((ClassCapability)capability, context)) {
                    isApiCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImplementation((ClassCapability)capability, context)) {
                    isImplCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImported((ClassCapability)capability, context)) {
                    isImplByImportCandidate = true;
                    unit = Unit.INSTANCE;
                } else {
                    isUnusedCandidate = true;
                    unit = Unit.INSTANCE;
                }
            } else if (capability2 instanceof ConstantCapability) {
                usesConstant2 = this.usesConstant((ConstantCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InferredCapability) {
                isCompileOnlyCandidate = ((InferredCapability)capability).isCompileOnlyAnnotations();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InlineMemberCapability) {
                usesInlineMember2 = this.usesInlineMember((InlineMemberCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ServiceLoaderCapability) {
                collection = ((ServiceLoaderCapability)capability).getProviderClasses();
                bl = false;
                hasServiceLoader = !collection.isEmpty();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof NativeLibCapability) {
                collection = ((NativeLibCapability)capability).getFileNames();
                bl = false;
                hasNativeLib = !collection.isEmpty();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof SecurityProviderCapability) {
                collection = ((SecurityProviderCapability)capability).getSecurityProviders();
                bl = false;
                hasSecurityProvider = !collection.isEmpty();
                unit = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit2 = unit;
        }
        if (isAnnotationProcessorCandidate) {
            this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.ANNOTATION_PROCESSOR), (Object)((Object)Reason.ANNOTATION_PROCESSOR)));
        } else if (isAnnotationProcessor) {
            this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.NONE), (Object)((Object)Reason.UNUSED_ANNOTATION_PROCESSOR)));
        }
        if (isApiCandidate) {
            this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.API), (Object)((Object)Reason.ABI)));
        } else if (isCompileOnlyCandidate) {
            isUnusedCandidate = false;
            this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.COMPILE_ONLY), (Object)((Object)Reason.COMPILE_TIME_ANNOTATIONS)));
        } else if (isImplCandidate) {
            this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.IMPL), (Object)((Object)Reason.IMPL)));
        } else if (isImplByImportCandidate) {
            this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.IMPL), (Object)((Object)Reason.IMPORTED)));
        }
        if (isUnusedCandidate) {
            if (usesResBySource) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.IMPL), (Object)((Object)Reason.RES_BY_SRC)));
            } else if (usesResByRes) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.IMPL), (Object)((Object)Reason.RES_BY_RES)));
            } else if (usesConstant2) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.IMPL), (Object)((Object)Reason.CONSTANT)));
            } else if (usesInlineMember2) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.IMPL), (Object)((Object)Reason.INLINE)));
            } else if (isLintJar) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.RUNTIME_ONLY), (Object)((Object)Reason.LINT_JAR)));
            } else if (isRuntimeAndroid) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.RUNTIME_ONLY), (Object)((Object)Reason.RUNTIME_ANDROID)));
            } else if (hasServiceLoader) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.RUNTIME_ONLY), (Object)((Object)Reason.SERVICE_LOADER)));
            } else if (hasSecurityProvider) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.RUNTIME_ONLY), (Object)((Object)Reason.SECURITY_PROVIDER)));
            } else if (hasNativeLib) {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.RUNTIME_ONLY), (Object)((Object)Reason.NATIVE_LIB)));
            } else {
                this.reportBuilder.set(dependency.getCoordinates(), (Pair<? extends Bucket, ? extends Reason>)TuplesKt.to((Object)((Object)Bucket.NONE), (Object)((Object)Reason.UNUSED)));
            }
        }
    }

    private final boolean isRuntimeAndroid(AndroidManifestCapability capability) {
        Map<AndroidManifestCapability.Component, Set<String>> components = capability.getComponentMap();
        Set<String> services = components.get((Object)AndroidManifestCapability.Component.SERVICE);
        Set<String> providers = components.get((Object)AndroidManifestCapability.Component.PROVIDER);
        return services != null || providers != null;
    }

    private final boolean isAbi(ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = context.getProject().getExposedClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String exposedClass = (String)element$iv;
                    boolean bl2 = false;
                    if (!classCapability.getClasses().contains(exposedClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isImplementation(ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = context.getProject().getImplementationClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String implClass = (String)element$iv;
                    boolean bl2 = false;
                    if (!classCapability.getClasses().contains(implClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isImported(ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = context.getProject().getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String string = (String)element$iv;
                    boolean bl2 = false;
                    if (!classCapability.getClasses().contains(string)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesConstant(ConstantCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block3: {
            usesConstant.1 $fun$optionalStarImport$1 = usesConstant.1.INSTANCE;
            Set<KtFile> ktFiles = capability.getKtFiles();
            Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence(capability.getConstants()), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Set<? extends String>>, List<? extends String>>(ktFiles){
                final /* synthetic */ Set $ktFiles;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke(@NotNull Map.Entry<String, ? extends Set<String>> $dstr$fqcn$names) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    String string;
                    Object object;
                    Object v0;
                    void fqcn;
                    boolean bl;
                    Object object2;
                    Set<String> names;
                    block7: {
                        Intrinsics.checkNotNullParameter($dstr$fqcn$names, (String)"<name for destructuring parameter 0>");
                        Map.Entry<String, ? extends Set<String>> entry = $dstr$fqcn$names;
                        boolean bl2 = false;
                        String string2 = entry.getKey();
                        entry = $dstr$fqcn$names;
                        bl2 = false;
                        names = entry.getValue();
                        object2 = this.$ktFiles;
                        bl = false;
                        Iterable iterable = object2;
                        boolean bl3 = false;
                        for (T t : iterable) {
                            KtFile it = (KtFile)t;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getFqcn(), (Object)fqcn)) continue;
                            v0 = t;
                            break block7;
                        }
                        v0 = null;
                    }
                    if ((object = (KtFile)v0) != null && (object = ((KtFile)object).getName()) != null) {
                        object2 = object;
                        bl = false;
                        boolean bl5 = false;
                        Object name = object2;
                        boolean bl6 = false;
                        string = StringsKt.removeSuffix((String)fqcn, (CharSequence)((CharSequence)name));
                    } else {
                        string = null;
                    }
                    String ktPrefix = string;
                    Iterable $this$mapNotNull$iv = names;
                    boolean $i$f$mapNotNull = false;
                    Iterable name = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object3 = $this$forEach$iv$iv$iv.iterator();
                    while (object3.hasNext()) {
                        String string3;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = object3.next();
                        boolean bl7 = false;
                        String name2 = (String)element$iv$iv;
                        boolean bl8 = false;
                        if (ktPrefix != null) {
                            String string4;
                            boolean bl9 = false;
                            boolean bl10 = false;
                            String it = string4;
                            boolean bl11 = false;
                            string3 = it + name2;
                        } else {
                            string3 = null;
                        }
                        if (string3 == null) continue;
                        String string5 = string3;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        String it$iv$iv = string5;
                        boolean bl14 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List ktImports = (List)destination$iv$iv;
                    $this$mapNotNull$iv = names;
                    Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ktImports, (Iterable)CollectionsKt.listOf((Object)((String)fqcn + ".*"))), (Iterable)usesConstant.1.INSTANCE.invoke((String)fqcn));
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void name3;
                        object3 = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl15 = false;
                        String string6 = (String)fqcn + '.' + (String)name3;
                        collection.add(string6);
                    }
                    collection = (List)destination$iv$iv;
                    return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
                }
                {
                    this.$ktFiles = set2;
                    super(1);
                }
            })));
            Iterable $this$any$iv = context.getProject().getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!candidateImports2.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesResBySource(AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block3: {
            Set<String> projectImports = context.getProject().getImports();
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new String[]{capability.getRImport(), StringsKt.removeSuffix((String)capability.getRImport(), (CharSequence)"R") + "*"});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!projectImports.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean usesResByRes(AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Iterable $this$any$iv = capability.getLines();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            AndroidResCapability.Line $dstr$type$id = (AndroidResCapability.Line)element$iv;
            boolean bl2 = false;
            String string = $dstr$type$id.component1();
            String id = $dstr$type$id.component2();
            Iterable $this$any$iv2 = context.getProject().getAndroidResSource();
            boolean $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl = false;
                continue;
            }
            for (Object element$iv2 : $this$any$iv2) {
                void type;
                boolean bl3;
                AndroidResSource candidate;
                block8: {
                    candidate = (AndroidResSource)element$iv2;
                    boolean bl4 = false;
                    Iterable $this$any$iv3 = candidate.getStyleParentRefs();
                    boolean $i$f$any3 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv3) {
                            AndroidResSource.StyleParentRef styleParentRef = (AndroidResSource.StyleParentRef)element$iv3;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)id, (Object)styleParentRef.getStyleParent())) continue;
                            bl3 = true;
                            break block8;
                        }
                        bl3 = false;
                    }
                }
                boolean byStyleParentRef = bl3;
                Object var18_18 = null;
                Lazy byAttrRef = LazyKt.unsafeLazy((Function0)new Function0<Boolean>(candidate, id, (String)type){
                    final /* synthetic */ AndroidResSource $candidate;
                    final /* synthetic */ String $id$inlined;
                    final /* synthetic */ String $type$inlined;
                    {
                        this.$candidate = androidResSource2;
                        this.$id$inlined = string;
                        this.$type$inlined = string2;
                        super(0);
                    }

                    public final boolean invoke() {
                        boolean bl;
                        block3: {
                            Iterable $this$any$iv = this.$candidate.getAttrRefs();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    AndroidResSource.AttrRef attrRef = (AndroidResSource.AttrRef)element$iv;
                                    boolean bl2 = false;
                                    if (!(Intrinsics.areEqual((Object)this.$type$inlined, (Object)attrRef.getType()) && Intrinsics.areEqual((Object)this.$id$inlined, (Object)attrRef.getId()))) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                });
                if (byStyleParentRef) return true;
                Iterator iterator2 = byAttrRef;
                Object var20_21 = null;
                boolean bl6 = false;
                if (((Boolean)iterator2.getValue()).booleanValue()) {
                    return true;
                }
                boolean bl7 = false;
                if (!bl7) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean usesInlineMember(InlineMemberCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block3: {
            Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)capability.getInlineMembers()), (Function1)usesInlineMember.candidateImports.1.INSTANCE));
            Iterable $this$any$iv = context.getProject().getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!candidateImports2.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesAnnotationProcessor(AnnotationProcessorCapability capability, GraphViewVisitor.Context context) {
        return new AnnotationProcessorDetector(capability.getSupportedAnnotationTypes()).usesAnnotationProcessor(context);
    }

    public GraphVisitor(@NotNull ProjectVariant project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.reportBuilder = new DependencyTraceReport.Builder(project2.getBuildType(), project2.getFlavor(), project2.getVariant(), project2.getKind());
    }
}

