/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.ClassAnalysisTask;
import com.autonomousapps.tasks.JarAnalysisParameters;
import com.autonomousapps.tasks.JarAnalysisWorkAction;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0007R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/autonomousapps/tasks/JarAnalysisTask;", "Lcom/autonomousapps/tasks/ClassAnalysisTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;)V", "jar", "Lorg/gradle/api/file/RegularFileProperty;", "getJar", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class JarAnalysisTask
extends ClassAnalysisTask {
    private final WorkerExecutor workerExecutor;

    @Classpath
    @NotNull
    public abstract RegularFileProperty getJar();

    @TaskAction
    public final void action() {
        File reportFile = UtilsKt.getAndDelete(this.getOutput());
        File reportPrettyFile = UtilsKt.getAndDelete(this.getOutputPretty());
        Object object = this.getJar().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jar.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jar.get().asFile");
        File jarFile = file;
        this.getLogger().debug("jar path = " + jarFile.getPath());
        this.workerExecutor.noIsolation().submit(JarAnalysisWorkAction.class, new Action(this, jarFile, reportFile, reportPrettyFile){
            final /* synthetic */ JarAnalysisTask this$0;
            final /* synthetic */ File $jarFile;
            final /* synthetic */ File $reportFile;
            final /* synthetic */ File $reportPrettyFile;

            public final void execute(@NotNull JarAnalysisParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                $this$submit.getVariantFiles().set((Provider)this.this$0.getVariantFiles());
                $this$submit.setJar(this.$jarFile);
                Set set2 = this.this$0.getLayoutFiles().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"layoutFiles.files");
                $this$submit.setLayouts(set2);
                $this$submit.setTestFiles(this.this$0.getTestFiles());
                $this$submit.setReport(this.$reportFile);
                $this$submit.setReportPretty(this.$reportPrettyFile);
            }
            {
                this.this$0 = jarAnalysisTask;
                this.$jarFile = file;
                this.$reportFile = file2;
                this.$reportPrettyFile = file3;
            }
        });
    }

    @Inject
    public JarAnalysisTask(@NotNull ObjectFactory objects, @NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        super(objects);
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of all classes referenced by a given jar");
    }
}

