/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.AndroidManifestCapability;
import com.autonomousapps.model.intermediates.AndroidManifestDependency;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004J0\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f*\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "manifestArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "getManifestFiles", "Lorg/gradle/api/file/FileCollection;", "setArtifacts", "toComponentMap", "", "Lcom/autonomousapps/model/AndroidManifestCapability$Component;", "", "", "dependency-analysis-gradle-plugin"})
public abstract class ManifestComponentsExtractionTask
extends DefaultTask {
    private ArtifactCollection manifestArtifacts;

    public final void setArtifacts(@NotNull ArtifactCollection manifestArtifacts) {
        Intrinsics.checkNotNullParameter((Object)manifestArtifacts, (String)"manifestArtifacts");
        this.manifestArtifacts = manifestArtifacts;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getManifestFiles() {
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"manifestArtifacts.artifactFiles");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        Set manifests;
        void $this$mapNotNullTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        ManifestParser parser = new ManifestParser();
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AndroidManifestDependency androidManifestDependency;
            AndroidManifestDependency androidManifestDependency2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult manifest = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            try {
                ResolvedArtifactResult resolvedArtifactResult = manifest;
                Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactResult, (String)"manifest");
                File file = resolvedArtifactResult.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"manifest.file");
                ManifestParser.ParseResult parseResult = parser.parse(file, true);
                String string = parseResult.getPackageName();
                Map<AndroidManifestCapability.Component, Set<String>> map = this.toComponentMap(parseResult.getComponents());
                ComponentArtifactIdentifier componentArtifactIdentifier = manifest.getId();
                Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"manifest.id");
                ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"manifest.id.componentIdentifier");
                androidManifestDependency2 = new AndroidManifestDependency(string, map, componentIdentifier);
            }
            catch (GradleException _) {
                androidManifestDependency2 = null;
            }
            if (androidManifestDependency2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AndroidManifestDependency it$iv$iv = androidManifestDependency;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set $this$toJson$iv = manifests = (Set)destination$iv$iv;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Set.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)outputFile, (String)string, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<AndroidManifestCapability.Component, Set<String>> toComponentMap(Map<String, ? extends Set<String>> $this$toComponentMap) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends Set<String>> $this$map$iv = $this$toComponentMap;
        boolean $i$f$map = false;
        Map<String, ? extends Set<String>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            void $dstr$key$values;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_13 = $dstr$key$values;
            boolean bl3 = false;
            String string = (String)var13_13.getKey();
            var13_13 = $dstr$key$values;
            bl3 = false;
            Set values = (Set)var13_13.getValue();
            Pair pair = TuplesKt.to((Object)((Object)AndroidManifestCapability.Component.Companion.of$dependency_analysis_gradle_plugin((String)key)), (Object)values);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public ManifestComponentsExtractionTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of packages, from other components, that are included via Android manifests");
    }
}

