/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.advice.ComprehensiveAdvice;
import com.autonomousapps.advice.Pebble;
import com.autonomousapps.advice.RippleDetector;
import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.internal.advice.RippleWriter;
import com.autonomousapps.internal.graph.LazyDependencyGraph;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001c\u0010\u000b\u001a\u00020\f8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR*\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/autonomousapps/tasks/RipplesTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "buildHealthReport", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildHealthReport", "()Lorg/gradle/api/file/RegularFileProperty;", "graph", "getGraph", "graphs", "Lorg/gradle/api/artifacts/Configuration;", "getGraphs", "()Lorg/gradle/api/artifacts/Configuration;", "setGraphs", "(Lorg/gradle/api/artifacts/Configuration;)V", "output", "getOutput", "<set-?>", "", "query", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "action", "", "validateProjectId", "Action", "Parameters", "dependency-analysis-gradle-plugin"})
public abstract class RipplesTask
extends DefaultTask {
    @Nullable
    private String query;
    public Configuration graphs;
    private final WorkerExecutor workerExecutor;

    @Input
    @Nullable
    public final String getQuery() {
        return this.query;
    }

    @Option(option="id", description="The subproject for which to compute potential ripples")
    public final void setQuery(@Nullable String string) {
        this.query = string;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final Configuration getGraphs() {
        Configuration configuration = this.graphs;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graphs");
        }
        return configuration;
    }

    public final void setGraphs(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<set-?>");
        this.graphs = configuration;
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraph();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildHealthReport();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        String queryProject = this.validateProjectId();
        this.workerExecutor.noIsolation().submit(Action.class, new org.gradle.api.Action(this, queryProject){
            final /* synthetic */ RipplesTask this$0;
            final /* synthetic */ String $queryProject;

            public final void execute(@NotNull Parameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                $this$submit.getSourceProject().set((Object)this.$queryProject);
                $this$submit.getGraphFiles().set(com.autonomousapps.internal.graph.UtilsKt.projectGraphMapFrom(this.this$0.getGraphs()));
                $this$submit.getGraph().set((Provider)this.this$0.getGraph());
                $this$submit.getBuildHealthReport().set((Provider)this.this$0.getBuildHealthReport());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
            {
                this.this$0 = ripplesTask;
                this.$queryProject = string;
            }
        });
    }

    private final String validateProjectId() {
        String string = this.query;
        if (string == null) {
            throw (Throwable)new GradleException("This task must be called with --id set");
        }
        String queryProject = string;
        if (!StringsKt.startsWith$default((String)queryProject, (String)":", (boolean)false, (int)2, null)) {
            throw (Throwable)new GradleException("Can only query a project");
        }
        return queryProject;
    }

    @Inject
    public RipplesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Emits to console all potential 'ripples' relating to dependency advice");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/RipplesTask$Parameters;", "Lorg/gradle/workers/WorkParameters;", "buildHealthReport", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildHealthReport", "()Lorg/gradle/api/file/RegularFileProperty;", "graph", "getGraph", "graphFiles", "Lorg/gradle/api/provider/MapProperty;", "", "Ljava/io/File;", "getGraphFiles", "()Lorg/gradle/api/provider/MapProperty;", "output", "getOutput", "sourceProject", "Lorg/gradle/api/provider/Property;", "getSourceProject", "()Lorg/gradle/api/provider/Property;", "dependency-analysis-gradle-plugin"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public Property<String> getSourceProject();

        @NotNull
        public MapProperty<String, File> getGraphFiles();

        @NotNull
        public RegularFileProperty getGraph();

        @NotNull
        public RegularFileProperty getBuildHealthReport();

        @NotNull
        public RegularFileProperty getOutput();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/tasks/RipplesTask$Action;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/RipplesTask$Parameters;", "()V", "lazyDepGraph", "Lcom/autonomousapps/internal/graph/LazyDependencyGraph;", "logger", "Lorg/gradle/api/logging/Logger;", "execute", "", "getDependencyGraph", "Lcom/autonomousapps/graph/DependencyGraph;", "projectPath", "", "dependency-analysis-gradle-plugin"})
    public static abstract class Action
    implements WorkAction<Parameters> {
        private final Logger logger;
        private final LazyDependencyGraph lazyDepGraph;

        public void execute() {
            Pebble pebble2;
            File outputFile = UtilsKt.getAndDelete(((Parameters)this.getParameters()).getOutput());
            RegularFileProperty $this$fromJson$iv = ((Parameters)this.getParameters()).getGraph();
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            String $this$fromJson$iv$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv$iv, null, (int)1, null);
            boolean $i$f$fromJson4 = false;
            boolean withNulls$iv$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
            JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            Object object2 = jsonAdapter.fromJson($this$fromJson$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object2);
            DependencyGraph graph = (DependencyGraph)object2;
            RegularFileProperty $this$fromJsonSet$iv = ((Parameters)this.getParameters()).getBuildHealthReport();
            boolean $i$f$fromJsonSet = false;
            Object object3 = $this$fromJsonSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get()");
            RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object3;
            boolean $i$f$fromJsonSet2 = false;
            File file2 = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            String $this$fromJsonSet$iv$iv$iv = FilesKt.readText$default((File)file2, null, (int)1, null);
            boolean withNulls$iv$iv$iv = false;
            boolean $i$f$fromJsonSet3 = false;
            boolean $i$f$getJsonSetAdapter = false;
            ParameterizedType type$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)ComprehensiveAdvice.class)});
            JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv$iv);
            JsonAdapter jsonAdapter2 = adapter$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"adapter");
            Object object4 = jsonAdapter2.fromJson($this$fromJsonSet$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object4);
            Set buildHealth = (Set)object4;
            Object object5 = ((Parameters)this.getParameters()).getSourceProject().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.sourceProject.get()");
            String sourceProject = (String)object5;
            Pebble $this$toJson$iv = pebble2 = new RippleDetector(sourceProject, (Function1<? super String, DependencyGraph>)((Function1)new Function1<String, DependencyGraph>(this){

                @NotNull
                public final DependencyGraph invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return Action.access$getDependencyGraph((Action)this.receiver, p1);
                }
            }), graph, buildHealth).getPebble();
            boolean withNulls$iv = false;
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter2 = false;
            JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Pebble.class);
            JsonAdapter jsonAdapter3 = adapter$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter");
            String string = jsonAdapter3.toJson((Object)$this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
            FilesKt.writeText$default((File)outputFile, (String)string, null, (int)2, null);
            String msg = new RippleWriter(pebble2).buildMessage();
            this.logger.quiet(msg);
        }

        private final DependencyGraph getDependencyGraph(String projectPath) {
            return this.lazyDepGraph.getDependencyGraph(projectPath);
        }

        public Action() {
            boolean $i$f$getLogger = false;
            Logger logger = Logging.getLogger(RipplesTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logging.getLogger(T::class.java)");
            this.logger = logger;
            Object object = ((Parameters)this.getParameters()).getGraphFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.graphFiles.get()");
            this.lazyDepGraph = new LazyDependencyGraph((Map)object);
        }

        public static final /* synthetic */ DependencyGraph access$getDependencyGraph(Action $this, String projectPath) {
            return $this.getDependencyGraph(projectPath);
        }
    }
}

