/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.analyzer.JvmSourceSet;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.SourceSetKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.SourceDirectorySet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/internal/analyzer/KotlinSourceSet;", "Lcom/autonomousapps/internal/analyzer/JvmSourceSet;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kind", "Lcom/autonomousapps/model/SourceSetKind;", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;Lcom/autonomousapps/model/SourceSetKind;)V", "compileClasspathConfigurationName", "", "getCompileClasspathConfigurationName", "()Ljava/lang/String;", "jarTaskName", "getJarTaskName", "javaCompileTaskName", "getJavaCompileTaskName", "getKind", "()Lcom/autonomousapps/model/SourceSetKind;", "kotlinCompileTaskName", "getKotlinCompileTaskName", "name", "getName", "sourceCode", "Lorg/gradle/api/file/SourceDirectorySet;", "getSourceCode", "()Lorg/gradle/api/file/SourceDirectorySet;", "dependency-analysis-gradle-plugin"})
public final class KotlinSourceSet
implements JvmSourceSet {
    @NotNull
    private final String name;
    @NotNull
    private final String jarTaskName;
    @NotNull
    private final SourceDirectorySet sourceCode;
    @NotNull
    private final String compileClasspathConfigurationName;
    @NotNull
    private final String javaCompileTaskName;
    @NotNull
    private final String kotlinCompileTaskName;
    @NotNull
    private final SourceSetKind kind;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getJarTaskName() {
        return this.jarTaskName;
    }

    @Override
    @NotNull
    public SourceDirectorySet getSourceCode() {
        return this.sourceCode;
    }

    @Override
    @NotNull
    public String getCompileClasspathConfigurationName() {
        return this.compileClasspathConfigurationName;
    }

    @Override
    @NotNull
    public String getJavaCompileTaskName() {
        return this.javaCompileTaskName;
    }

    @Override
    @NotNull
    public String getKotlinCompileTaskName() {
        return this.kotlinCompileTaskName;
    }

    @Override
    @NotNull
    public SourceSetKind getKind() {
        return this.kind;
    }

    public KotlinSourceSet(@NotNull org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet kotlinSourceSet, @NotNull SourceSetKind kind) {
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.kind = kind;
        String string = kotlinSourceSet.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
        this.name = string;
        this.jarTaskName = "jar";
        this.sourceCode = kotlinSourceSet.getKotlin();
        this.compileClasspathConfigurationName = Intrinsics.areEqual((Object)this.getName(), (Object)"main") ^ true ? this.getName() + "CompileClasspath" : "compileClasspath";
        this.javaCompileTaskName = Intrinsics.areEqual((Object)this.getName(), (Object)"main") ^ true ? "compile" + UtilsKt.capitalizeSafely$default(this.getName(), null, 1, null) + "Java" : "compileJava";
        this.kotlinCompileTaskName = Intrinsics.areEqual((Object)this.getName(), (Object)"main") ^ true ? "compile" + UtilsKt.capitalizeSafely$default(this.getName(), null, 1, null) + "Kotlin" : "compileKotlin";
    }
}

