/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.advice.ProjectHealthConsoleReportBuilder;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "projectAdvice", "getProjectAdvice", "action", "", "ProjectHealthAction", "ProjectHealthParameters", "dependency-analysis-gradle-plugin"})
public abstract class GenerateProjectHealthReportTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(ProjectHealthAction.class, new Action(this){
            final /* synthetic */ GenerateProjectHealthReportTask this$0;

            public final void execute(@NotNull ProjectHealthParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                $this$submit.getAdvice().set((Provider)this.this$0.getProjectAdvice());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
            {
                this.this$0 = generateProjectHealthReportTask;
            }
        });
    }

    @Inject
    public GenerateProjectHealthReportTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Generates console report for project health");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthParameters;", "Lorg/gradle/workers/WorkParameters;", "advice", "Lorg/gradle/api/file/RegularFileProperty;", "getAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "output", "getOutput", "dependency-analysis-gradle-plugin"})
    public static interface ProjectHealthParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getAdvice();

        @NotNull
        public RegularFileProperty getOutput();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthParameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    public static abstract class ProjectHealthAction
    implements WorkAction<ProjectHealthParameters> {
        public void execute() {
            File output = UtilsKt.getAndDelete(((ProjectHealthParameters)this.getParameters()).getOutput());
            RegularFileProperty $this$fromJson$iv = ((ProjectHealthParameters)this.getParameters()).getAdvice();
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            String $this$fromJson$iv$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv$iv, null, (int)1, null);
            boolean $i$f$fromJson4 = false;
            boolean withNulls$iv$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
            JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            Object object2 = jsonAdapter.fromJson($this$fromJson$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object2);
            ProjectAdvice projectAdvice2 = (ProjectAdvice)object2;
            String consoleText = new ProjectHealthConsoleReportBuilder(projectAdvice2).getText();
            FilesKt.writeText$default((File)output, (String)consoleText, null, (int)2, null);
        }
    }
}

