/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.model.AndroidLinterCapability;
import com.autonomousapps.model.AndroidManifestCapability;
import com.autonomousapps.model.AndroidResCapability;
import com.autonomousapps.model.AndroidResSource;
import com.autonomousapps.model.AnnotationProcessorCapability;
import com.autonomousapps.model.Capability;
import com.autonomousapps.model.ClassCapability;
import com.autonomousapps.model.ConstantCapability;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.Dependency;
import com.autonomousapps.model.InferredCapability;
import com.autonomousapps.model.InlineMemberCapability;
import com.autonomousapps.model.KtFile;
import com.autonomousapps.model.NativeLibCapability;
import com.autonomousapps.model.ProjectVariant;
import com.autonomousapps.model.SecurityProviderCapability;
import com.autonomousapps.model.ServiceLoaderCapability;
import com.autonomousapps.model.intermediates.Bucket;
import com.autonomousapps.model.intermediates.DependencyTraceReport;
import com.autonomousapps.model.intermediates.Reason;
import com.autonomousapps.tasks.AnnotationProcessorDetector;
import com.autonomousapps.tasks.GraphVisitor;
import com.autonomousapps.visitor.GraphViewVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/autonomousapps/tasks/GraphVisitor;", "Lcom/autonomousapps/visitor/GraphViewVisitor;", "project", "Lcom/autonomousapps/model/ProjectVariant;", "(Lcom/autonomousapps/model/ProjectVariant;)V", "report", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "getReport", "()Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "reportBuilder", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport$Builder;", "isAbi", "", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "classCapability", "Lcom/autonomousapps/model/ClassCapability;", "context", "Lcom/autonomousapps/visitor/GraphViewVisitor$Context;", "isImplementation", "isImported", "isRuntimeAndroid", "capability", "Lcom/autonomousapps/model/AndroidManifestCapability;", "usesAnnotationProcessor", "Lcom/autonomousapps/model/AnnotationProcessorCapability;", "usesConstant", "Lcom/autonomousapps/model/ConstantCapability;", "usesInlineMember", "Lcom/autonomousapps/model/InlineMemberCapability;", "usesResByRes", "Lcom/autonomousapps/model/AndroidResCapability;", "usesResBySource", "visit", "", "dependency", "Lcom/autonomousapps/model/Dependency;", "dependency-analysis-gradle-plugin"})
final class GraphVisitor
implements GraphViewVisitor {
    private final DependencyTraceReport.Builder reportBuilder;

    @NotNull
    public final DependencyTraceReport getReport() {
        return this.reportBuilder.build();
    }

    @Override
    public void visit(@NotNull Dependency dependency, @NotNull GraphViewVisitor.Context context) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Coordinates coord = dependency.getCoordinates();
        boolean isAnnotationProcessor = false;
        boolean isAnnotationProcessorCandidate = false;
        boolean isApiCandidate = false;
        boolean isImplCandidate = false;
        boolean isImplByImportCandidate = false;
        boolean isUnusedCandidate = false;
        boolean isLintJar = false;
        boolean isCompileOnlyCandidate = false;
        boolean isRuntimeAndroid = false;
        boolean usesResBySource = false;
        boolean usesResByRes = false;
        boolean usesConstant2 = false;
        boolean usesInlineMember2 = false;
        boolean hasServiceLoader = false;
        boolean hasSecurityProvider = false;
        boolean hasNativeLib = false;
        Iterable $this$forEach$iv = dependency.getCapabilities().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Collection collection;
            Set<String> providers;
            Unit unit;
            Capability capability = (Capability)element$iv;
            boolean bl2 = false;
            Capability capability2 = capability;
            if (capability2 instanceof AndroidLinterCapability) {
                isLintJar = ((AndroidLinterCapability)capability).isLintJar();
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, new Reason.LintJar("Is an Android linter"));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidManifestCapability) {
                isRuntimeAndroid = this.isRuntimeAndroid(coord, (AndroidManifestCapability)capability);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidResCapability) {
                usesResBySource = this.usesResBySource(coord, (AndroidResCapability)capability, context);
                usesResByRes = this.usesResByRes(coord, (AndroidResCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AnnotationProcessorCapability) {
                isAnnotationProcessor = true;
                isAnnotationProcessorCandidate = this.usesAnnotationProcessor(coord, (AnnotationProcessorCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ClassCapability) {
                if (this.isAbi(coord, (ClassCapability)capability, context)) {
                    isApiCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImplementation(coord, (ClassCapability)capability, context)) {
                    isImplCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImported(coord, (ClassCapability)capability, context)) {
                    isImplByImportCandidate = true;
                    unit = Unit.INSTANCE;
                } else {
                    isUnusedCandidate = true;
                    unit = Unit.INSTANCE;
                }
            } else if (capability2 instanceof ConstantCapability) {
                usesConstant2 = this.usesConstant(coord, (ConstantCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InferredCapability) {
                if (((InferredCapability)capability).isCompileOnlyAnnotations()) {
                    this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, new Reason.CompileTimeAnnotations("Provides compile-time annotations"));
                }
                isCompileOnlyCandidate = ((InferredCapability)capability).isCompileOnlyAnnotations();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InlineMemberCapability) {
                usesInlineMember2 = this.usesInlineMember(coord, (InlineMemberCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ServiceLoaderCapability) {
                providers = ((ServiceLoaderCapability)capability).getProviderClasses();
                collection = providers;
                bl = false;
                hasServiceLoader = !collection.isEmpty();
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ServiceLoader("Provides service loaders: " + providers));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof NativeLibCapability) {
                Set<String> fileNames = ((NativeLibCapability)capability).getFileNames();
                collection = fileNames;
                bl = false;
                hasNativeLib = !collection.isEmpty();
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, new Reason.NativeLib("Provides native binaries: " + fileNames));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof SecurityProviderCapability) {
                providers = ((SecurityProviderCapability)capability).getSecurityProviders();
                collection = providers;
                bl = false;
                hasSecurityProvider = !collection.isEmpty();
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, new Reason.SecurityProvider("Provides security providers: " + providers));
                unit = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit2 = unit;
        }
        if (isAnnotationProcessorCandidate) {
            this.reportBuilder.set(coord, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.ANNOTATION_PROCESSOR);
        } else if (isAnnotationProcessor) {
            this.reportBuilder.set(coord, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.NONE);
        }
        if (isApiCandidate) {
            this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.API);
        } else if (isCompileOnlyCandidate) {
            isUnusedCandidate = false;
            this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.COMPILE_ONLY);
        } else if (isImplCandidate) {
            this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        } else if (isImplByImportCandidate) {
            this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        }
        if (isUnusedCandidate) {
            if (usesResBySource) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesResByRes) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesConstant2) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesInlineMember2) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (isLintJar) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (isRuntimeAndroid) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasServiceLoader) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasSecurityProvider) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasNativeLib) {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else {
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Bucket.NONE);
                this.reportBuilder.set(coord, DependencyTraceReport.Kind.DEPENDENCY, Reason.Unused.INSTANCE);
            }
        }
    }

    private final boolean isRuntimeAndroid(Coordinates coordinates, AndroidManifestCapability capability) {
        Set<String> set2;
        Set<String> set3;
        boolean bl;
        Map<AndroidManifestCapability.Component, Set<String>> components = capability.getComponentMap();
        Set<String> set4 = components.get((Object)AndroidManifestCapability.Component.SERVICE);
        if (set4 != null) {
            Set<String> set5 = set4;
            boolean bl2 = false;
            bl = false;
            Set<String> it = set5;
            boolean bl3 = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.RuntimeAndroid("Provides Android Services: " + it));
            set3 = set5;
        } else {
            set3 = null;
        }
        Set<String> services = set3;
        Set<String> set6 = components.get((Object)AndroidManifestCapability.Component.PROVIDER);
        if (set6 != null) {
            Set<String> set7 = set6;
            bl = false;
            boolean bl4 = false;
            Set<String> it = set7;
            boolean bl5 = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.RuntimeAndroid("Provides Android Providers: " + it));
            set2 = set7;
        } else {
            set2 = null;
        }
        Set<String> providers = set2;
        return services != null || providers != null;
    }

    private final boolean isAbi(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = context.getProject().getExposedClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String exposedClass = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = classCapability.getClasses().contains(exposedClass);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean it = bl3;
                    boolean bl6 = false;
                    if (it) {
                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Abi("Exposes class " + exposedClass));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isImplementation(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = context.getProject().getImplementationClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String implClass = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = classCapability.getClasses().contains(implClass);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean it = bl3;
                    boolean bl6 = false;
                    if (it) {
                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Impl("Uses class " + implClass));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isImported(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = context.getProject().getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String string = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = classCapability.getClasses().contains(string);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean it = bl3;
                    boolean bl6 = false;
                    if (it) {
                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Imported("Declares import " + string));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesConstant(Coordinates coordinates, ConstantCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block4: {
            usesConstant.1 $fun$optionalStarImport$1 = usesConstant.1.INSTANCE;
            Set<KtFile> ktFiles = capability.getKtFiles();
            Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence(capability.getConstants()), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Set<? extends String>>, List<? extends String>>(ktFiles){
                final /* synthetic */ Set $ktFiles;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke(@NotNull Map.Entry<String, ? extends Set<String>> $dstr$fqcn$names) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    String string;
                    Object object;
                    Object v0;
                    void fqcn;
                    boolean bl;
                    Object object2;
                    Set<String> names;
                    block7: {
                        Intrinsics.checkNotNullParameter($dstr$fqcn$names, (String)"<name for destructuring parameter 0>");
                        Map.Entry<String, ? extends Set<String>> entry = $dstr$fqcn$names;
                        boolean bl2 = false;
                        String string2 = entry.getKey();
                        entry = $dstr$fqcn$names;
                        bl2 = false;
                        names = entry.getValue();
                        object2 = this.$ktFiles;
                        bl = false;
                        Iterable iterable = object2;
                        boolean bl3 = false;
                        for (T t : iterable) {
                            KtFile it = (KtFile)t;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getFqcn(), (Object)fqcn)) continue;
                            v0 = t;
                            break block7;
                        }
                        v0 = null;
                    }
                    if ((object = (KtFile)v0) != null && (object = ((KtFile)object).getName()) != null) {
                        object2 = object;
                        bl = false;
                        boolean bl5 = false;
                        Object name = object2;
                        boolean bl6 = false;
                        string = StringsKt.removeSuffix((String)fqcn, (CharSequence)((CharSequence)name));
                    } else {
                        string = null;
                    }
                    String ktPrefix = string;
                    Iterable $this$mapNotNull$iv = names;
                    boolean $i$f$mapNotNull = false;
                    Iterable name = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object3 = $this$forEach$iv$iv$iv.iterator();
                    while (object3.hasNext()) {
                        String string3;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = object3.next();
                        boolean bl7 = false;
                        String name2 = (String)element$iv$iv;
                        boolean bl8 = false;
                        if (ktPrefix != null) {
                            String string4;
                            boolean bl9 = false;
                            boolean bl10 = false;
                            String it = string4;
                            boolean bl11 = false;
                            string3 = it + name2;
                        } else {
                            string3 = null;
                        }
                        if (string3 == null) continue;
                        String string5 = string3;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        String it$iv$iv = string5;
                        boolean bl14 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List ktImports = (List)destination$iv$iv;
                    $this$mapNotNull$iv = names;
                    Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ktImports, (Iterable)CollectionsKt.listOf((Object)((String)fqcn + ".*"))), (Iterable)usesConstant.1.INSTANCE.invoke((String)fqcn));
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void name3;
                        object3 = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl15 = false;
                        String string6 = (String)fqcn + '.' + (String)name3;
                        collection.add(string6);
                    }
                    collection = (List)destination$iv$iv;
                    return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
                }
                {
                    this.$ktFiles = set2;
                    super(1);
                }
            })));
            Iterable $this$any$iv = context.getProject().getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String string = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = candidateImports2.contains(string);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean it = bl3;
                    boolean bl6 = false;
                    if (it) {
                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Constant("Imports constant " + string));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesResBySource(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block4: {
            Set<String> projectImports = context.getProject().getImports();
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new String[]{capability.getRImport(), StringsKt.removeSuffix((String)capability.getRImport(), (CharSequence)"R") + "*"});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String string = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = projectImports.contains(string);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean it = bl3;
                    boolean bl6 = false;
                    if (it) {
                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ResBySrc("Imports res " + string));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean usesResByRes(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block13: {
            Iterable $this$any$iv = capability.getLines();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block12: {
                        AndroidResCapability.Line $dstr$type$id = (AndroidResCapability.Line)element$iv;
                        boolean bl3 = false;
                        String string = $dstr$type$id.component1();
                        String id = $dstr$type$id.component2();
                        Iterable $this$any$iv2 = context.getProject().getAndroidResSource();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Object v3;
                                block11: {
                                    Object v2;
                                    Object object2;
                                    AndroidResSource candidate;
                                    block10: {
                                        candidate = (AndroidResSource)element$iv2;
                                        boolean bl4 = false;
                                        Iterable iterable = candidate.getStyleParentRefs();
                                        boolean bl5 = false;
                                        Iterable iterable2 = iterable;
                                        boolean bl6 = false;
                                        for (Object object2 : iterable2) {
                                            AndroidResSource.StyleParentRef styleParentRef = (AndroidResSource.StyleParentRef)object2;
                                            boolean bl7 = false;
                                            if (!Intrinsics.areEqual((Object)id, (Object)styleParentRef.getStyleParent())) continue;
                                            v2 = object2;
                                            break block10;
                                        }
                                        v2 = null;
                                    }
                                    AndroidResSource.StyleParentRef styleParentRef = v2;
                                    if (styleParentRef != null) {
                                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ResByRes("Uses res " + styleParentRef));
                                        return true;
                                    }
                                    Iterable iterable = candidate.getAttrRefs();
                                    boolean bl8 = false;
                                    Iterable iterable3 = iterable;
                                    boolean bl9 = false;
                                    object2 = iterable3.iterator();
                                    while (object2.hasNext()) {
                                        void type;
                                        Object e = object2.next();
                                        AndroidResSource.AttrRef attrRef = (AndroidResSource.AttrRef)e;
                                        boolean bl10 = false;
                                        if (!(Intrinsics.areEqual((Object)type, (Object)attrRef.getType()) && Intrinsics.areEqual((Object)id, (Object)attrRef.getId()))) continue;
                                        v3 = e;
                                        break block11;
                                    }
                                    v3 = null;
                                }
                                AndroidResSource.AttrRef attrRef = v3;
                                if (attrRef != null) {
                                    this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ResByRes("Uses res " + attrRef));
                                    return true;
                                }
                                if (!false) continue;
                                bl2 = true;
                                break block12;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesInlineMember(Coordinates coordinates, InlineMemberCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        block4: {
            Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)capability.getInlineMembers()), (Function1)usesInlineMember.candidateImports.1.INSTANCE));
            Iterable $this$any$iv = context.getProject().getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String string = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = candidateImports2.contains(string);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean it = bl3;
                    boolean bl6 = false;
                    if (it) {
                        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Inline("Imports inline member " + string));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean usesAnnotationProcessor(Coordinates coordinates, AnnotationProcessorCapability capability, GraphViewVisitor.Context context) {
        return new AnnotationProcessorDetector(coordinates, capability.getSupportedAnnotationTypes(), this.reportBuilder).usesAnnotationProcessor(context);
    }

    public GraphVisitor(@NotNull ProjectVariant project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.reportBuilder = new DependencyTraceReport.Builder(project.getBuildType(), project.getFlavor(), project.getVariant());
    }
}

