/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.ibm.icu.number;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import shadow.com.ibm.icu.impl.Utility;
import shadow.com.ibm.icu.impl.number.DecimalQuantity;
import shadow.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import shadow.com.ibm.icu.impl.number.MacroProps;
import shadow.com.ibm.icu.impl.number.MicroProps;
import shadow.com.ibm.icu.impl.number.NumberStringBuilder;
import shadow.com.ibm.icu.number.FormattedNumber;
import shadow.com.ibm.icu.number.NumberFormatterImpl;
import shadow.com.ibm.icu.number.NumberFormatterSettings;
import shadow.com.ibm.icu.util.Measure;
import shadow.com.ibm.icu.util.MeasureUnit;

public class LocalizedNumberFormatter
extends NumberFormatterSettings<LocalizedNumberFormatter> {
    static final AtomicLongFieldUpdater<LocalizedNumberFormatter> callCount = AtomicLongFieldUpdater.newUpdater(LocalizedNumberFormatter.class, "callCountInternal");
    volatile long callCountInternal;
    volatile LocalizedNumberFormatter savedWithUnit;
    volatile NumberFormatterImpl compiled;

    LocalizedNumberFormatter(NumberFormatterSettings<?> parent, int key, Object value) {
        super(parent, key, value);
    }

    public FormattedNumber format(long input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(double input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Number input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Measure input) {
        MeasureUnit unit = input.getUnit();
        Number number = input.getNumber();
        if (Utility.equals(this.resolve().unit, unit)) {
            return this.format(number);
        }
        LocalizedNumberFormatter withUnit = this.savedWithUnit;
        if (withUnit == null || !Utility.equals(withUnit.resolve().unit, unit)) {
            this.savedWithUnit = withUnit = new LocalizedNumberFormatter(this, 3, unit);
        }
        return withUnit.format(number);
    }

    @Deprecated
    public FormattedNumber format(DecimalQuantity fq) {
        MicroProps micros;
        MacroProps macros = this.resolve();
        long currentCount = callCount.incrementAndGet(this);
        NumberStringBuilder string = new NumberStringBuilder();
        if (currentCount == macros.threshold) {
            this.compiled = NumberFormatterImpl.fromMacros(macros);
            micros = this.compiled.apply(fq, string);
        } else {
            micros = this.compiled != null ? this.compiled.apply(fq, string) : NumberFormatterImpl.applyStatic(macros, fq, string);
        }
        return new FormattedNumber(string, fq, micros);
    }

    @Override
    LocalizedNumberFormatter create(int key, Object value) {
        return new LocalizedNumberFormatter(this, key, value);
    }
}

