/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.stringtemplate.v4.compiler;

import com.autonomousapps.internal.antlr.runtime.ANTLRStringStream;
import com.autonomousapps.internal.antlr.runtime.CommonTokenStream;
import com.autonomousapps.internal.antlr.runtime.NoViableAltException;
import com.autonomousapps.internal.antlr.runtime.Parser;
import com.autonomousapps.internal.antlr.runtime.RecognitionException;
import com.autonomousapps.internal.antlr.runtime.Token;
import com.autonomousapps.internal.antlr.runtime.TokenStream;
import com.autonomousapps.internal.antlr.runtime.tree.CommonTreeNodeStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import shadow.org.stringtemplate.v4.Interpreter;
import shadow.org.stringtemplate.v4.ST;
import shadow.org.stringtemplate.v4.STGroup;
import shadow.org.stringtemplate.v4.compiler.CodeGenerator;
import shadow.org.stringtemplate.v4.compiler.CompiledST;
import shadow.org.stringtemplate.v4.compiler.FormalArgument;
import shadow.org.stringtemplate.v4.compiler.STException;
import shadow.org.stringtemplate.v4.compiler.STLexer;
import shadow.org.stringtemplate.v4.compiler.STParser;
import shadow.org.stringtemplate.v4.misc.ErrorType;

public class Compiler {
    public static final String SUBTEMPLATE_PREFIX = "_sub";
    public static final int TEMPLATE_INITIAL_CODE_SIZE = 15;
    public static final Map<String, Interpreter.Option> supportedOptions;
    public static final int NUM_OPTIONS;
    public static final Map<String, String> defaultOptionValues;
    public static Map<String, Short> funcs;
    public static AtomicInteger subtemplateCount;
    public STGroup group;

    public Compiler() {
        this(STGroup.defaultGroup);
    }

    public Compiler(STGroup group) {
        this.group = group;
    }

    public CompiledST compile(String template) {
        CompiledST code = this.compile(null, null, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String name, String template) {
        CompiledST code = this.compile(null, name, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String srcName, String name, List<FormalArgument> args, String template, Token templateToken) {
        STParser.templateAndEOF_return r;
        ANTLRStringStream is = new ANTLRStringStream(template);
        is.name = srcName != null ? srcName : name;
        STLexer lexer = templateToken != null && templateToken.getType() == 6 ? new STLexer(this.group.errMgr, is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar){

            @Override
            public Token nextToken() {
                Token t = super.nextToken();
                while (t.getType() == 32 || t.getType() == 31) {
                    t = super.nextToken();
                }
                return t;
            }
        } : new STLexer(this.group.errMgr, is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        STParser p = new STParser(tokens, this.group.errMgr, templateToken);
        try {
            r = p.templateAndEOF();
        }
        catch (RecognitionException re) {
            this.reportMessageAndThrowSTException(tokens, templateToken, p, re);
            return null;
        }
        if (p.getNumberOfSyntaxErrors() > 0 || r.getTree() == null) {
            CompiledST impl = new CompiledST();
            impl.defineFormalArgs(args);
            return impl;
        }
        CommonTreeNodeStream nodes2 = new CommonTreeNodeStream(r.getTree());
        nodes2.setTokenStream(tokens);
        CodeGenerator gen = new CodeGenerator(nodes2, this.group.errMgr, name, template, templateToken);
        CompiledST impl = null;
        try {
            impl = gen.template(name, args);
            impl.nativeGroup = this.group;
            impl.template = template;
            impl.ast = r.getTree();
            impl.ast.setUnknownTokenBoundaries();
            impl.tokens = tokens;
        }
        catch (RecognitionException re) {
            this.group.errMgr.internalError(null, "bad tree structure", re);
        }
        return impl;
    }

    public static CompiledST defineBlankRegion(CompiledST outermostImpl, Token nameToken) {
        String outermostTemplateName = outermostImpl.name;
        String mangled = STGroup.getMangledRegionName(outermostTemplateName, nameToken.getText());
        CompiledST blank = new CompiledST();
        blank.isRegion = true;
        blank.templateDefStartToken = nameToken;
        blank.regionDefType = ST.RegionType.IMPLICIT;
        blank.name = mangled;
        outermostImpl.addImplicitlyDefinedTemplate(blank);
        return blank;
    }

    public static String getNewSubtemplateName() {
        int count = subtemplateCount.incrementAndGet();
        return SUBTEMPLATE_PREFIX + count;
    }

    protected void reportMessageAndThrowSTException(TokenStream tokens, Token templateToken, Parser parser, RecognitionException re) {
        if (re.token.getType() == -1) {
            String msg = "premature EOF";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (re instanceof NoViableAltException) {
            String msg = "'" + re.token.getText() + "' came as a complete surprise to me";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.index() == 0) {
            String msg = "this doesn't look like a template: \"" + tokens + "\"";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.LA(1) == 23) {
            String msg = "doesn't look like an expression";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else {
            String msg = parser.getErrorMessage(re, parser.getTokenNames());
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        }
        throw new STException();
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("anchor", (Object)Interpreter.Option.ANCHOR);
        map.put("format", (Object)Interpreter.Option.FORMAT);
        map.put("null", (Object)Interpreter.Option.NULL);
        map.put("separator", (Object)Interpreter.Option.SEPARATOR);
        map.put("wrap", (Object)Interpreter.Option.WRAP);
        supportedOptions = Collections.unmodifiableMap(map);
        NUM_OPTIONS = supportedOptions.size();
        map = new HashMap();
        map.put("anchor", "true");
        map.put("wrap", "\n");
        defaultOptionValues = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("first", (short)27);
        map.put("last", (short)28);
        map.put("rest", (short)29);
        map.put("trunc", (short)30);
        map.put("strip", (short)31);
        map.put("trim", (short)32);
        map.put("length", (short)33);
        map.put("strlen", (short)34);
        map.put("reverse", (short)35);
        funcs = Collections.unmodifiableMap(map);
        subtemplateCount = new AtomicInteger(0);
    }
}

