/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.intermediates.ExplodingSourceCode;
import com.autonomousapps.tasks.SourceExploder;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/tasks/CodeSourceExploderTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/ProjectLayout;)V", "javaSourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJavaSourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinSourceFiles", "getKotlinSourceFiles", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "CodeSourceExploderParameters", "CodeSourceExploderWorkAction", "dependency-analysis-gradle-plugin"})
public abstract class CodeSourceExploderTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;
    private final ProjectLayout layout;

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getJavaSourceFiles();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getKotlinSourceFiles();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(CodeSourceExploderWorkAction.class, new Action(this){
            final /* synthetic */ CodeSourceExploderTask this$0;

            public final void execute(@NotNull CodeSourceExploderParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                $this$submit.getProjectDir().set((Object)CodeSourceExploderTask.access$getLayout$p(this.this$0).getProjectDirectory());
                $this$submit.getJavaSourceFiles().from(new Object[]{this.this$0.getJavaSourceFiles()});
                $this$submit.getKotlinSourceFiles().from(new Object[]{this.this$0.getKotlinSourceFiles()});
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
            {
                this.this$0 = codeSourceExploderTask;
            }
        });
    }

    @Inject
    public CodeSourceExploderTask(@NotNull WorkerExecutor workerExecutor, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.workerExecutor = workerExecutor;
        this.layout = layout;
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Parses Java and Kotlin source to detect source-only usages");
    }

    public static final /* synthetic */ ProjectLayout access$getLayout$p(CodeSourceExploderTask $this) {
        return $this.layout;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderParameters;", "Lorg/gradle/workers/WorkParameters;", "javaSourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJavaSourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinSourceFiles", "getKotlinSourceFiles", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "projectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDir", "()Lorg/gradle/api/file/DirectoryProperty;", "dependency-analysis-gradle-plugin"})
    public static interface CodeSourceExploderParameters
    extends WorkParameters {
        @NotNull
        public DirectoryProperty getProjectDir();

        @NotNull
        public ConfigurableFileCollection getJavaSourceFiles();

        @NotNull
        public ConfigurableFileCollection getKotlinSourceFiles();

        @NotNull
        public RegularFileProperty getOutput();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderParameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    public static abstract class CodeSourceExploderWorkAction
    implements WorkAction<CodeSourceExploderParameters> {
        public void execute() {
            Set<ExplodingSourceCode> explodedSource;
            File reportFile = UtilsKt.getAndDelete(((CodeSourceExploderParameters)this.getParameters()).getOutput());
            Object object = ((CodeSourceExploderParameters)this.getParameters()).getProjectDir().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectDir.get()");
            File file = ((Directory)object).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.projectDir.get().asFile");
            Set<ExplodingSourceCode> $this$toJson$iv = explodedSource = new SourceExploder(file, ((CodeSourceExploderParameters)this.getParameters()).getJavaSourceFiles(), ((CodeSourceExploderParameters)this.getParameters()).getKotlinSourceFiles()).explode();
            boolean withNulls$iv = false;
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Set.class);
            JsonAdapter jsonAdapter = adapter$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            String string = jsonAdapter.toJson($this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
            FilesKt.writeText$default((File)reportFile, (String)string, null, (int)2, null);
        }
    }
}

