/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.graph.DominanceTree;
import com.autonomousapps.internal.graph.DominanceTreeWriter;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.graph.Graphs;
import com.autonomousapps.internal.utils.FileUtils;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.autonomousapps.model.PhysicalArtifact;
import com.autonomousapps.model.ProjectCoordinates;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graphView", "Lorg/gradle/api/file/RegularFileProperty;", "getGraphView", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "getOutputDot", "outputTxt", "getOutputTxt", "physicalArtifacts", "getPhysicalArtifacts", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "action", "", "BySize", "dependency-analysis-gradle-plugin"})
public abstract class ComputeDominatorTreeTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPhysicalArtifacts();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraphView();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputTxt();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        File outputTxt = UtilsKt.getAndDelete(this.getOutputTxt());
        File outputDot = UtilsKt.getAndDelete(this.getOutputDot());
        Object $this$fromJsonSet$iv = this.getPhysicalArtifacts();
        boolean $i$f$fromJsonSet = false;
        Object object = $this$fromJsonSet$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
        RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object;
        boolean $i$f$fromJsonSet22 = false;
        File file = $this$fromJsonSet$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
        String $this$fromJsonSet$iv$iv$iv = FilesKt.readText$default((File)file, null, (int)1, null);
        boolean withNulls$iv$iv$iv = false;
        boolean $i$f$fromJsonSet3 = false;
        boolean $i$f$getJsonSetAdapter = false;
        Object type$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)PhysicalArtifact.class)});
        JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv$iv);
        JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
        Object object2 = jsonAdapter.fromJson($this$fromJsonSet$iv$iv$iv);
        Intrinsics.checkNotNull((Object)object2);
        $this$fromJsonSet$iv = (Set)object2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void $i$f$fromJsonSet22 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void coord2;
            type$iv$iv$iv$iv = destination$iv$iv;
            PhysicalArtifact $dstr$coord$file = (PhysicalArtifact)element$iv$iv;
            boolean bl = false;
            Coordinates coordinates = $dstr$coord$file.component1();
            File file2 = $dstr$coord$file.component2();
            $dstr$coord$file = TuplesKt.to((Object)coord2, (Object)file2);
            type$iv$iv$iv$iv.put($dstr$coord$file.getFirst(), $dstr$coord$file.getSecond());
        }
        Map artifactMap = destination$iv$iv;
        RegularFileProperty $this$fromJson$iv = this.getGraphView();
        boolean $i$f$fromJson = false;
        Object object3 = $this$fromJson$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get()");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object3;
        boolean $i$f$fromJson2 = false;
        File file3 = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"asFile");
        File $this$fromJson$iv$iv$iv = file3;
        boolean $i$f$fromJson3 = false;
        String $this$fromJson$iv$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv$iv, null, (int)1, null);
        boolean $i$f$fromJson4 = false;
        boolean withNulls$iv$iv$iv$iv$iv = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraphView.class);
        JsonAdapter jsonAdapter2 = adapter$iv$iv$iv$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"adapter");
        Object object4 = jsonAdapter2.fromJson($this$fromJson$iv$iv$iv$iv);
        Intrinsics.checkNotNull((Object)object4);
        DependencyGraphView graphView = (DependencyGraphView)object4;
        Object object5 = this.getProjectPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"projectPath.get()");
        ProjectCoordinates project = new ProjectCoordinates((String)object5);
        DominanceTree<Coordinates> tree = new DominanceTree<Coordinates>(graphView.getGraph$dependency_analysis_gradle_plugin(), project);
        BySize nodeWriter = new BySize(artifactMap, tree, project);
        DominanceTreeWriter<Coordinates> writer = new DominanceTreeWriter<Coordinates>(project, tree, nodeWriter);
        FilesKt.writeText$default((File)outputTxt, (String)writer.getString(), null, (int)2, null);
        FilesKt.writeText$default((File)outputDot, (String)GraphWriter.INSTANCE.toDot(tree.getDominanceGraph()), null, (int)2, null);
    }

    public ComputeDominatorTreeTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Computes a dominator view of the dependency graph");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000bj\b\u0012\u0004\u0012\u00020\u0002`\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize;", "Lcom/autonomousapps/internal/graph/DominanceTreeWriter$NodeWriter;", "Lcom/autonomousapps/model/Coordinates;", "files", "", "Ljava/io/File;", "tree", "Lcom/autonomousapps/internal/graph/DominanceTree;", "root", "(Ljava/util/Map;Lcom/autonomousapps/internal/graph/DominanceTree;Lcom/autonomousapps/model/Coordinates;)V", "comparator", "Ljava/util/Comparator;", "reachableNodes", "", "", "scale", "Lcom/autonomousapps/internal/utils/FileUtils$Scale;", "sizes", "", "Lkotlin/Comparator;", "getSize", "node", "toString", "", "treeSizeOf", "dependency-analysis-gradle-plugin"})
    private static final class BySize
    implements DominanceTreeWriter.NodeWriter<Coordinates> {
        private final Map<Coordinates, Long> sizes;
        private final Map<Coordinates, Set<Coordinates>> reachableNodes;
        private final FileUtils.Scale scale;
        private final Comparator<Coordinates> comparator;
        private final Map<Coordinates, File> files;
        private final DominanceTree<Coordinates> tree;

        private final long getSize(Coordinates node) {
            Long l = this.sizes.computeIfAbsent(node, new Function(this){
                final /* synthetic */ BySize this$0;

                @NotNull
                public final Long apply(@NotNull Coordinates it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BySize.access$treeSizeOf(this.this$0, it);
                }
                {
                    this.this$0 = bySize;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"sizes.computeIfAbsent(node) { treeSizeOf(it) }");
            return ((Number)l).longValue();
        }

        private final Set<Coordinates> reachableNodes(Coordinates node) {
            Set<Coordinates> set2 = this.reachableNodes.computeIfAbsent(node, new Function(this, node){
                final /* synthetic */ BySize this$0;
                final /* synthetic */ Coordinates $node;

                @NotNull
                public final Set<Coordinates> apply(@NotNull Coordinates it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Graphs.INSTANCE.reachableNodes(BySize.access$getTree$p(this.this$0).getDominanceGraph(), this.$node, false);
                }
                {
                    this.this$0 = bySize;
                    this.$node = coordinates;
                }
            });
            Intrinsics.checkNotNullExpressionValue(set2, (String)"reachableNodes.computeIf\u2026xcludeSelf = false)\n    }");
            return set2;
        }

        /*
         * WARNING - void declaration
         */
        private final long treeSizeOf(Coordinates node) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.reachableNodes(node);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File file;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it) == null) continue;
                File it$iv$iv = file;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            long l = 0L;
            for (Object t : iterable2) {
                void it;
                $this$forEach$iv$iv$iv = (File)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.length();
                l = l2 + l3;
            }
            return l;
        }

        @Override
        @NotNull
        public Comparator<Coordinates> comparator() {
            return this.comparator;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String toString(@NotNull Coordinates node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StringBuilder builder = new StringBuilder();
            boolean printedTotalSize = false;
            Set<Coordinates> subs = this.reachableNodes(node);
            Collection collection = SetsKt.minus(subs, (Object)node);
            if (!collection.isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = subs;
                boolean $i$f$mapNotNull22 = false;
                void var10_12 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    File file;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Coordinates it = (Coordinates)element$iv$iv;
                    boolean bl2 = false;
                    if (this.files.get(it) == null) continue;
                    File it$iv$iv = file;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv;
                long $i$f$mapNotNull22 = 0L;
                for (Object t : iterable) {
                    void it;
                    $this$forEach$iv$iv$iv = (File)t;
                    long l = $i$f$mapNotNull22;
                    boolean bl = false;
                    long l2 = it.length();
                    $i$f$mapNotNull22 = l + l2;
                }
                long totalSize = $i$f$mapNotNull22;
                printedTotalSize = true;
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(totalSize, this.scale)).append(' ');
            }
            File file = this.files.get(node);
            if (file != null) {
                long l;
                long it = l = file.length();
                boolean bl = false;
                if (printedTotalSize) {
                    builder.append('(');
                }
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(it, this.scale));
                if (printedTotalSize) {
                    builder.append(')');
                }
                builder.append(' ');
            }
            builder.append(node.gav());
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public BySize(@NotNull Map<Coordinates, ? extends File> files, @NotNull DominanceTree<Coordinates> tree, @NotNull Coordinates root) {
            void it;
            FileUtils.Scale scale;
            long l;
            long l2;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.files = files;
            this.tree = tree;
            this.sizes = new LinkedHashMap();
            this.reachableNodes = new LinkedHashMap();
            Iterable iterable = this.reachableNodes(root);
            BySize bySize = this;
            boolean $i$f$mapNotNull22 = false;
            void var7_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File file;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it2 = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it2) == null) continue;
                File it$iv$iv = file;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            iterable = list;
            long $i$f$mapNotNull22 = 0L;
            for (Object e : iterable) {
                void it3;
                $this$forEach$iv$iv$iv = (File)e;
                long l3 = $i$f$mapNotNull22;
                boolean bl = false;
                long l4 = it3.length();
                $i$f$mapNotNull22 = l3 + l4;
            }
            $i$f$mapNotNull22 = l2 = (l = $i$f$mapNotNull22);
            boolean bl = false;
            bySize.scale = scale = FileUtils.INSTANCE.getScale((long)it);
            this.comparator = new Comparator(this){
                final /* synthetic */ BySize this$0;

                public final int compare(Coordinates left, Coordinates right) {
                    Coordinates coordinates = right;
                    Intrinsics.checkNotNullExpressionValue((Object)coordinates, (String)"right");
                    long l = BySize.access$getSize(this.this$0, coordinates);
                    Coordinates coordinates2 = left;
                    Intrinsics.checkNotNullExpressionValue((Object)coordinates2, (String)"left");
                    long l2 = l - BySize.access$getSize(this.this$0, coordinates2);
                    return l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                }
                {
                    this.this$0 = bySize;
                }
            };
        }

        public static final /* synthetic */ long access$treeSizeOf(BySize $this, Coordinates node) {
            return $this.treeSizeOf(node);
        }

        public static final /* synthetic */ DominanceTree access$getTree$p(BySize $this) {
            return $this.tree;
        }

        public static final /* synthetic */ long access$getSize(BySize $this, Coordinates node) {
            return $this.getSize(node);
        }
    }
}

