/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.exception.BuildScriptParseException;
import com.autonomousapps.internal.advice.AdvicePrinter;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.parse.GradleBuildScriptDependenciesRewriter;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.tasks.RewriteTaskKt;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/RewriteTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildScript", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildScript", "()Lorg/gradle/api/file/RegularFileProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "projectAdvice", "getProjectAdvice", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class RewriteTask
extends DefaultTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildScript();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @TaskAction
    public final void action() {
        Object object = this.getBuildScript().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buildScript.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildScript.get().asFile");
        File buildScript = file;
        DslKind dslKind = DslKind.Companion.from(buildScript);
        RegularFileProperty $this$fromJson$iv = this.getProjectAdvice();
        boolean $i$f$fromJson = false;
        Object object2 = $this$fromJson$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
        boolean $i$f$fromJson2 = false;
        File file2 = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
        File $this$fromJson$iv$iv$iv = file2;
        boolean $i$f$fromJson3 = false;
        String $this$fromJson$iv$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv$iv, null, (int)1, null);
        boolean $i$f$fromJson4 = false;
        boolean withNulls$iv$iv$iv$iv$iv = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
        JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
        Object object3 = jsonAdapter.fromJson($this$fromJson$iv$iv$iv$iv);
        Intrinsics.checkNotNull((Object)object3);
        ProjectAdvice projectAdvice2 = (ProjectAdvice)object3;
        Object object4 = this.getDependencyMap().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"dependencyMap.get()");
        Map map = (Map)object4;
        Map<String, String> reversedMap = CollectionsKt.reversed(map);
        Path path = buildScript.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"buildScript.toPath()");
        GradleBuildScriptDependenciesRewriter rewriter = GradleBuildScriptDependenciesRewriter.Companion.newRewriter(path, projectAdvice2.getDependencyAdvice(), new AdvicePrinter(dslKind, RewriteTaskKt.toLambda(map)), RewriteTaskKt.toLambda(reversedMap));
        try {
            String newText = rewriter.rewritten();
            FilesKt.writeText$default((File)buildScript, (String)newText, null, (int)2, null);
        }
        catch (BuildScriptParseException e) {
            this.getLogger().warn("Can't fix dependencies for '" + projectAdvice2.getProjectPath() + "': " + e.getLocalizedMessage());
        }
    }

    public RewriteTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Rewrite build script for this project to match dependency advice");
    }
}

