/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.kotlin;

import com.autonomousapps.internal.asm.tree.AnnotationNode;
import com.autonomousapps.internal.asm.tree.ClassNode;
import com.autonomousapps.internal.asm.tree.FieldNode;
import com.autonomousapps.internal.asm.tree.InnerClassNode;
import com.autonomousapps.internal.asm.tree.MethodNode;
import com.autonomousapps.internal.kotlin.AsmUtilsKt;
import com.autonomousapps.internal.kotlin.ClassVisibility;
import com.autonomousapps.internal.kotlin.FieldBinarySignature;
import com.autonomousapps.internal.kotlin.KotlinMetadataVisibilitiesKt;
import com.autonomousapps.internal.kotlin.KotlinVisibilitiesKt;
import com.autonomousapps.internal.kotlin.MemberBinarySignature;
import com.autonomousapps.internal.kotlin.MethodBinarySignature;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a:\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0010\u0010%\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0010\u0010&\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0010\u0010'\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u0010\u0010(\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a\u001c\u0010)\u001a\u0004\u0018\u00010**\b\u0012\u0004\u0012\u00020*0\u001f2\u0006\u0010+\u001a\u00020\u0003H\u0002\u001a \u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"H\u0000\u001a \u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020,2\u0006\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"H\u0000\u001a \u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020-2\u0006\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"H\u0000\u001a\u0017\u0010.\u001a\u0004\u0018\u00010**\u00020\u001c2\u0006\u0010+\u001a\u00020\u0003H\u0080\u0002\u001a\u0016\u0010/\u001a\u00020\"*\u00020\u000e2\b\u00100\u001a\u0004\u0018\u000101H\u0000\u001a\u0016\u00102\u001a\u00020\"*\u00020\u000e2\b\u00103\u001a\u0004\u0018\u000104H\u0000\u001a\f\u00105\u001a\u00020\"*\u00020\u000eH\u0000\u001a\f\u00106\u001a\u00020\"*\u00020\u000eH\u0000\u001a\f\u00107\u001a\u00020\"*\u00020\u000eH\u0000\u001a\f\u00107\u001a\u00020\"*\u00020,H\u0000\u001a\f\u00107\u001a\u00020\"*\u00020-H\u0000\u001a\f\u00108\u001a\u00020\"*\u00020\u000eH\u0000\u001a\u0014\u00109\u001a\u00020\"*\u00020\u001c2\u0006\u0010:\u001a\u00020\u0003H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u000e\u0010\f\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\r\u001a\u00020\u0002*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\u0002*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u0003*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006;"}, d2={"ACCESS_NAMES", "", "", "", "getACCESS_NAMES", "()Ljava/util/Map;", "MEMBER_SORT_ORDER", "Ljava/util/Comparator;", "Lcom/autonomousapps/internal/kotlin/MemberBinarySignature;", "Lkotlin/Comparator;", "getMEMBER_SORT_ORDER", "()Ljava/util/Comparator;", "publishedApiAnnotationName", "effectiveAccess", "Lcom/autonomousapps/internal/asm/tree/ClassNode;", "getEffectiveAccess", "(Lcom/autonomousapps/internal/asm/tree/ClassNode;)I", "innerClassNode", "Lcom/autonomousapps/internal/asm/tree/InnerClassNode;", "getInnerClassNode", "(Lcom/autonomousapps/internal/asm/tree/ClassNode;)Lcom/autonomousapps/internal/asm/tree/InnerClassNode;", "kind", "getKind", "(Lcom/autonomousapps/internal/kotlin/MemberBinarySignature;)I", "outerClassName", "getOuterClassName", "(Lcom/autonomousapps/internal/asm/tree/ClassNode;)Ljava/lang/String;", "findAnnotation", "Lcom/autonomousapps/internal/asm/tree/AnnotationNode;", "annotationName", "visibleAnnotations", "", "invisibleAnnotations", "includeInvisible", "", "isFinal", "access", "isProtected", "isPublic", "isStatic", "isSynthetic", "annotationValue", "", "key", "Lcom/autonomousapps/internal/asm/tree/FieldNode;", "Lcom/autonomousapps/internal/asm/tree/MethodNode;", "get", "isDefaultImpls", "metadata", "Lkotlinx/metadata/jvm/KotlinClassMetadata;", "isEffectivelyPublic", "classVisibility", "Lcom/autonomousapps/internal/kotlin/ClassVisibility;", "isInner", "isLocal", "isPublishedApi", "isWhenMappings", "refersToName", "name", "dependency-analysis-gradle-plugin"})
public final class AsmUtilsKt {
    @NotNull
    private static final Map<Integer, String> ACCESS_NAMES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)"public"), TuplesKt.to((Object)4, (Object)"protected"), TuplesKt.to((Object)2, (Object)"private"), TuplesKt.to((Object)8, (Object)"static"), TuplesKt.to((Object)16, (Object)"final"), TuplesKt.to((Object)1024, (Object)"abstract"), TuplesKt.to((Object)4096, (Object)"synthetic"), TuplesKt.to((Object)512, (Object)"interface"), TuplesKt.to((Object)8192, (Object)"annotation")});
    @NotNull
    private static final Comparator<MemberBinarySignature> MEMBER_SORT_ORDER = ComparisonsKt.compareBy((Function1[])new Function1[]{MEMBER_SORT_ORDER.1.INSTANCE, MEMBER_SORT_ORDER.2.INSTANCE, MEMBER_SORT_ORDER.3.INSTANCE});
    @NotNull
    public static final String publishedApiAnnotationName = "kotlin/PublishedApi";

    @NotNull
    public static final Map<Integer, String> getACCESS_NAMES() {
        return ACCESS_NAMES;
    }

    private static final int getKind(MemberBinarySignature $this$kind) {
        int n;
        MemberBinarySignature memberBinarySignature = $this$kind;
        if (memberBinarySignature instanceof FieldBinarySignature) {
            n = 1;
        } else if (memberBinarySignature instanceof MethodBinarySignature) {
            n = 2;
        } else {
            String string = "Unsupported " + $this$kind;
            throw new IllegalStateException(string.toString());
        }
        return n;
    }

    @NotNull
    public static final Comparator<MemberBinarySignature> getMEMBER_SORT_ORDER() {
        return MEMBER_SORT_ORDER;
    }

    public static final boolean isPublic(int access) {
        return (access & 1) != 0 || (access & 4) != 0;
    }

    public static final boolean isProtected(int access) {
        return (access & 4) != 0;
    }

    public static final boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public static final boolean isFinal(int access) {
        return (access & 0x10) != 0;
    }

    public static final boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyPublic(@NotNull ClassNode $this$isEffectivelyPublic, @Nullable ClassVisibility classVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyPublic, (String)"$this$isEffectivelyPublic");
        if (!AsmUtilsKt.isPublic($this$isEffectivelyPublic.access)) return false;
        if (AsmUtilsKt.isLocal($this$isEffectivelyPublic)) return false;
        if (AsmUtilsKt.isWhenMappings($this$isEffectivelyPublic)) return false;
        ClassVisibility classVisibility2 = classVisibility;
        if (classVisibility2 == null) return true;
        boolean bl = KotlinVisibilitiesKt.isPublic(classVisibility2, AsmUtilsKt.isPublishedApi($this$isEffectivelyPublic));
        if (!bl) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final InnerClassNode getInnerClassNode(@NotNull ClassNode $this$innerClassNode) {
        Object object;
        block2: {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)$this$innerClassNode, (String)"$this$innerClassNode");
            List list = $this$innerClassNode.innerClasses;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"innerClasses");
            Iterable $this$singleOrNull$iv = list;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                InnerClassNode it = (InnerClassNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)$this$innerClassNode.name)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (InnerClassNode)object;
    }

    public static final boolean isLocal(@NotNull ClassNode $this$isLocal) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocal, (String)"$this$isLocal");
        InnerClassNode innerClassNode = AsmUtilsKt.getInnerClassNode($this$isLocal);
        if (innerClassNode != null) {
            InnerClassNode innerClassNode2;
            InnerClassNode $this$run = innerClassNode2 = innerClassNode;
            boolean bl2 = false;
            bl = $this$run.innerName == null && $this$run.outerName == null;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isInner(@NotNull ClassNode $this$isInner) {
        Intrinsics.checkNotNullParameter((Object)$this$isInner, (String)"$this$isInner");
        return AsmUtilsKt.getInnerClassNode($this$isInner) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isWhenMappings(@NotNull ClassNode $this$isWhenMappings) {
        Intrinsics.checkNotNullParameter((Object)$this$isWhenMappings, (String)"$this$isWhenMappings");
        if (!AsmUtilsKt.isSynthetic($this$isWhenMappings.access)) return false;
        String string = $this$isWhenMappings.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)"$WhenMappings", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final int getEffectiveAccess(@NotNull ClassNode $this$effectiveAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveAccess, (String)"$this$effectiveAccess");
        InnerClassNode innerClassNode = AsmUtilsKt.getInnerClassNode($this$effectiveAccess);
        return innerClassNode != null ? innerClassNode.access : $this$effectiveAccess.access;
    }

    @Nullable
    public static final String getOuterClassName(@NotNull ClassNode $this$outerClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$outerClassName, (String)"$this$outerClassName");
        InnerClassNode innerClassNode = AsmUtilsKt.getInnerClassNode($this$outerClassName);
        return innerClassNode != null ? innerClassNode.outerName : null;
    }

    public static final boolean isPublishedApi(@NotNull ClassNode $this$isPublishedApi) {
        Intrinsics.checkNotNullParameter((Object)$this$isPublishedApi, (String)"$this$isPublishedApi");
        return AsmUtilsKt.findAnnotation($this$isPublishedApi, publishedApiAnnotationName, true) != null;
    }

    public static final boolean isPublishedApi(@NotNull MethodNode $this$isPublishedApi) {
        Intrinsics.checkNotNullParameter((Object)$this$isPublishedApi, (String)"$this$isPublishedApi");
        return AsmUtilsKt.findAnnotation($this$isPublishedApi, publishedApiAnnotationName, true) != null;
    }

    public static final boolean isPublishedApi(@NotNull FieldNode $this$isPublishedApi) {
        Intrinsics.checkNotNullParameter((Object)$this$isPublishedApi, (String)"$this$isPublishedApi");
        return AsmUtilsKt.findAnnotation($this$isPublishedApi, publishedApiAnnotationName, true) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDefaultImpls(@NotNull ClassNode $this$isDefaultImpls, @Nullable KotlinClassMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefaultImpls, (String)"$this$isDefaultImpls");
        if (!AsmUtilsKt.isInner($this$isDefaultImpls)) return false;
        String string = $this$isDefaultImpls.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)"$DefaultImpls", (boolean)false, (int)2, null)) return false;
        if (!KotlinMetadataVisibilitiesKt.isSyntheticClass(metadata)) return false;
        return true;
    }

    @Nullable
    public static final AnnotationNode findAnnotation(@NotNull ClassNode $this$findAnnotation, @NotNull String annotationName, boolean includeInvisible) {
        Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"$this$findAnnotation");
        Intrinsics.checkNotNullParameter((Object)annotationName, (String)"annotationName");
        return AsmUtilsKt.findAnnotation(annotationName, $this$findAnnotation.visibleAnnotations, $this$findAnnotation.invisibleAnnotations, includeInvisible);
    }

    public static /* synthetic */ AnnotationNode findAnnotation$default(ClassNode classNode, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return AsmUtilsKt.findAnnotation(classNode, string, bl);
    }

    @Nullable
    public static final AnnotationNode findAnnotation(@NotNull MethodNode $this$findAnnotation, @NotNull String annotationName, boolean includeInvisible) {
        Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"$this$findAnnotation");
        Intrinsics.checkNotNullParameter((Object)annotationName, (String)"annotationName");
        return AsmUtilsKt.findAnnotation(annotationName, $this$findAnnotation.visibleAnnotations, $this$findAnnotation.invisibleAnnotations, includeInvisible);
    }

    public static /* synthetic */ AnnotationNode findAnnotation$default(MethodNode methodNode, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return AsmUtilsKt.findAnnotation(methodNode, string, bl);
    }

    @Nullable
    public static final AnnotationNode findAnnotation(@NotNull FieldNode $this$findAnnotation, @NotNull String annotationName, boolean includeInvisible) {
        Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"$this$findAnnotation");
        Intrinsics.checkNotNullParameter((Object)annotationName, (String)"annotationName");
        return AsmUtilsKt.findAnnotation(annotationName, $this$findAnnotation.visibleAnnotations, $this$findAnnotation.invisibleAnnotations, includeInvisible);
    }

    public static /* synthetic */ AnnotationNode findAnnotation$default(FieldNode fieldNode, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return AsmUtilsKt.findAnnotation(fieldNode, string, bl);
    }

    @Nullable
    public static final Object get(@NotNull AnnotationNode $this$get, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List list = $this$get.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
        return AsmUtilsKt.annotationValue(list, key);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object annotationValue(List<? extends Object> $this$annotationValue, String key) {
        int n = 0;
        int n2 = $this$annotationValue.size() / 2;
        while (n < n2) {
            void index;
            if (Intrinsics.areEqual((Object)$this$annotationValue.get((int)(index * 2)), (Object)key)) {
                return $this$annotationValue.get((int)(index * 2 + true));
            }
            ++index;
        }
        return null;
    }

    private static final AnnotationNode findAnnotation(String annotationName, List<? extends AnnotationNode> visibleAnnotations, List<? extends AnnotationNode> invisibleAnnotations, boolean includeInvisible) {
        AnnotationNode annotationNode;
        block11: {
            AnnotationNode it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block10: {
                Object v1;
                block8: {
                    annotationNode = visibleAnnotations;
                    if (annotationNode == null) break block10;
                    $this$firstOrNull$iv = (Iterable)annotationNode;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (AnnotationNode)element$iv;
                        boolean bl = false;
                        if (!AsmUtilsKt.refersToName(it, annotationName)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                if ((annotationNode = (AnnotationNode)v1) != null) break block11;
            }
            if (includeInvisible) {
                List<? extends AnnotationNode> list = invisibleAnnotations;
                if (list != null) {
                    Object v3;
                    block9: {
                        $this$firstOrNull$iv = list;
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (AnnotationNode)element$iv;
                            boolean bl = false;
                            if (!AsmUtilsKt.refersToName(it, annotationName)) continue;
                            v3 = element$iv;
                            break block9;
                        }
                        v3 = null;
                    }
                    annotationNode = v3;
                } else {
                    annotationNode = null;
                }
            } else {
                annotationNode = null;
            }
        }
        return annotationNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean refersToName(@NotNull AnnotationNode $this$refersToName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$refersToName, (String)"$this$refersToName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = $this$refersToName.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc");
        if (!StringsKt.startsWith$default((CharSequence)string, (char)'L', (boolean)false, (int)2, null)) return false;
        String string2 = $this$refersToName.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desc");
        if (!StringsKt.endsWith$default((CharSequence)string2, (char)';', (boolean)false, (int)2, null)) return false;
        String string3 = $this$refersToName.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
        if (!StringsKt.regionMatches$default((String)string3, (int)1, (String)name, (int)0, (int)name.length(), (boolean)false, (int)16, null)) return false;
        return true;
    }

    public static final /* synthetic */ int access$getKind$p(MemberBinarySignature $this$access_u24kind_u24p) {
        return AsmUtilsKt.getKind($this$access_u24kind_u24p);
    }
}

