/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps;

import com.autonomousapps.DependencyAnalysisExtensionKt;
import com.autonomousapps.internal.android.AgpVersion;
import com.autonomousapps.subplugin.ProjectPlugin;
import com.autonomousapps.subplugin.RootPlugin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\t\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/autonomousapps/DependencyAnalysisPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "applyForProject", "applyForRoot", "checkAgpVersion", "checkPluginWasAppliedToRoot", "dependency-analysis-gradle-plugin"})
public final class DependencyAnalysisPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Project project2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$run = project2 = project;
        boolean bl = false;
        this.checkAgpVersion($this$run);
        this.applyForRoot($this$run);
        this.checkPluginWasAppliedToRoot($this$run);
        this.applyForProject($this$run);
    }

    private final void checkAgpVersion(Project $this$checkAgpVersion) {
        AgpVersion agpVersion;
        try {
            agpVersion = AgpVersion.Companion.current();
        }
        catch (Throwable _) {
            $this$checkAgpVersion.getLogger().info("AGP not on classpath; assuming non-Android project");
            return;
        }
        AgpVersion current = agpVersion;
        $this$checkAgpVersion.getLogger().debug("AgpVersion = " + current);
        if (!current.isSupported() && Intrinsics.areEqual((Object)$this$checkAgpVersion, (Object)$this$checkAgpVersion.getRootProject())) {
            $this$checkAgpVersion.getLogger().warn("The Dependency Analysis plugin is only known to work with versions of AGP between " + AgpVersion.Companion.getAGP_MIN().getVersion() + " and " + AgpVersion.Companion.getAGP_MAX().getVersion() + ". You are using " + current.getVersion() + ". Proceed" + " at your own risk.");
        }
    }

    private final void applyForRoot(Project $this$applyForRoot) {
        if (Intrinsics.areEqual((Object)$this$applyForRoot, (Object)$this$applyForRoot.getRootProject())) {
            new RootPlugin($this$applyForRoot).apply();
        }
    }

    private final void checkPluginWasAppliedToRoot(Project $this$checkPluginWasAppliedToRoot) {
        if (DependencyAnalysisExtensionKt.getExtensionOrNull($this$checkPluginWasAppliedToRoot) == null) {
            Project project = $this$checkPluginWasAppliedToRoot.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"rootProject");
            if (Intrinsics.areEqual((Object)project.getName(), (Object)"test") ^ true) {
                throw (Throwable)new GradleException("You must apply the plugin to the root project. Current project is " + $this$checkPluginWasAppliedToRoot.getPath());
            }
        }
    }

    private final void applyForProject(Project $this$applyForProject) {
        new ProjectPlugin($this$applyForProject).apply();
    }
}

