/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.parse.SourceListener;
import com.autonomousapps.model.CodeSource;
import com.autonomousapps.model.intermediates.ExplodingSourceCode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/autonomousapps/tasks/SourceExploder;", "", "projectDir", "Ljava/io/File;", "groovySourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "javaSourceFiles", "kotlinSourceFiles", "scalaSourceFiles", "(Ljava/io/File;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;)V", "canonicalClassName", "", "relativePath", "explode", "", "Lcom/autonomousapps/model/intermediates/ExplodingSourceCode;", "relativize", "file", "dependency-analysis-gradle-plugin"})
final class SourceExploder {
    private final File projectDir;
    private final ConfigurableFileCollection groovySourceFiles;
    private final ConfigurableFileCollection javaSourceFiles;
    private final ConfigurableFileCollection kotlinSourceFiles;
    private final ConfigurableFileCollection scalaSourceFiles;

    @NotNull
    public final Set<ExplodingSourceCode> explode() {
        ExplodingSourceCode explodingSourceCode;
        String rel;
        File it;
        Collection collection;
        TreeSet destination = SetsKt.sortedSetOf((Object[])new ExplodingSourceCode[0]);
        Iterable $this$mapTo$iv = (Iterable)this.javaSourceFiles;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            File file = (File)item$iv;
            collection = destination;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            rel = this.relativize((File)v0);
            explodingSourceCode = new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.JAVA, SourceListener.Companion.parseSourceFileForImports(it));
            collection.add(explodingSourceCode);
        }
        $this$mapTo$iv = (Iterable)this.kotlinSourceFiles;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (File)item$iv;
            collection = destination;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            rel = this.relativize(file);
            explodingSourceCode = new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.KOTLIN, SourceListener.Companion.parseSourceFileForImports(it));
            collection.add(explodingSourceCode);
        }
        $this$mapTo$iv = (Iterable)this.groovySourceFiles;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (File)item$iv;
            collection = destination;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            rel = this.relativize(file);
            explodingSourceCode = new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.GROOVY, SourceListener.Companion.parseSourceFileForImports(it));
            collection.add(explodingSourceCode);
        }
        $this$mapTo$iv = (Iterable)this.scalaSourceFiles;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (File)item$iv;
            collection = destination;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            rel = this.relativize(file);
            explodingSourceCode = new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.SCALA, SourceListener.Companion.parseSourceFileForImports(it));
            collection.add(explodingSourceCode);
        }
        return destination;
    }

    private final String relativize(File file) {
        return FilesKt.toRelativeString((File)file, (File)this.projectDir);
    }

    private final String canonicalClassName(String relativePath) {
        Path path = Paths.get(relativePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(relativePath)");
        return StringsKt.substringBeforeLast$default((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)path, (int)3), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), (char)'.', null, (int)2, null);
    }

    public SourceExploder(@NotNull File projectDir, @NotNull ConfigurableFileCollection groovySourceFiles, @NotNull ConfigurableFileCollection javaSourceFiles, @NotNull ConfigurableFileCollection kotlinSourceFiles, @NotNull ConfigurableFileCollection scalaSourceFiles) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)groovySourceFiles, (String)"groovySourceFiles");
        Intrinsics.checkNotNullParameter((Object)javaSourceFiles, (String)"javaSourceFiles");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceFiles, (String)"kotlinSourceFiles");
        Intrinsics.checkNotNullParameter((Object)scalaSourceFiles, (String)"scalaSourceFiles");
        this.projectDir = projectDir;
        this.groovySourceFiles = groovySourceFiles;
        this.javaSourceFiles = javaSourceFiles;
        this.kotlinSourceFiles = kotlinSourceFiles;
        this.scalaSourceFiles = scalaSourceFiles;
    }
}

