/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.parse.ExplodedManifest;
import com.autonomousapps.model.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140\u00130\u0003H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/parse/AndroidManifestParser;", "", "manifests", "", "Ljava/io/File;", "projectDir", "namespace", "", "(Ljava/lang/Iterable;Ljava/io/File;Ljava/lang/String;)V", "explodedManifests", "", "Lcom/autonomousapps/internal/parse/ExplodedManifest;", "getExplodedManifests", "()Ljava/util/List;", "parser", "Lcom/autonomousapps/internal/ManifestParser;", "compute", "parseManifests", "toExplodedManifest", "Lkotlin/Pair;", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "toExplodedManifests", "dependency-analysis-gradle-plugin"})
public final class AndroidManifestParser {
    private final ManifestParser parser;
    @NotNull
    private final List<ExplodedManifest> explodedManifests;
    private final Iterable<File> manifests;
    private final File projectDir;
    private final String namespace;

    @NotNull
    public final List<ExplodedManifest> getExplodedManifests() {
        return this.explodedManifests;
    }

    private final List<ExplodedManifest> compute() {
        CharSequence charSequence = this.namespace;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            return this.parseManifests();
        }
        List parseResults = new ArrayList();
        List malformedManifests = new ArrayList();
        for (File manifest : this.manifests) {
            Object object;
            if (!manifest.exists()) continue;
            try {
                Collection collection = parseResults;
                object = TuplesKt.to((Object)manifest, (Object)ManifestParser.parse$default(this.parser, manifest, false, 2, null));
                collection.add(object);
            }
            catch (ManifestParser.ManifestParseException _) {
                object = malformedManifests;
                object.add(manifest);
            }
        }
        Object object = (Pair)CollectionsKt.firstOrNull((List)parseResults);
        String string = object != null && (object = (ManifestParser.ParseResult)object.getSecond()) != null ? ((ManifestParser.ParseResult)object).getPackageName() : null;
        Iterator<File> iterator = string;
        if (iterator == null) {
            iterator = "";
        }
        Iterator<File> mainNamespace = iterator;
        ManifestParser malformedParser = new ManifestParser((String)((Object)mainNamespace));
        for (File remainder : malformedManifests) {
            Collection collection = parseResults;
            Pair pair = TuplesKt.to((Object)remainder, (Object)ManifestParser.parse$default(malformedParser, remainder, false, 2, null));
            collection.add(pair);
        }
        return this.toExplodedManifests(parseResults);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExplodedManifest> parseManifests() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable<File> iterable = this.manifests;
        AndroidManifestParser androidManifestParser = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Pair> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)ManifestParser.parse$default(this.parser, it, false, 2, null));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        return androidManifestParser.toExplodedManifests((Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExplodedManifest> toExplodedManifests(Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>> $this$toExplodedManifests) {
        void $this$mapTo$iv$iv;
        Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>> $this$map$iv = $this$toExplodedManifests;
        boolean $i$f$map = false;
        Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ExplodedManifest explodedManifest = this.toExplodedManifest((Pair<? extends File, ManifestParser.ParseResult>)it);
            collection.add(explodedManifest);
        }
        return (List)destination$iv$iv;
    }

    private final ExplodedManifest toExplodedManifest(Pair<? extends File, ManifestParser.ParseResult> $this$toExplodedManifest) {
        File file = (File)$this$toExplodedManifest.getFirst();
        ManifestParser.ParseResult parseResult = (ManifestParser.ParseResult)$this$toExplodedManifest.getSecond();
        String applicationName = parseResult.getApplicationName();
        AndroidResSource.AttrRef theme = AndroidResSource.AttrRef.Companion.style(parseResult.getTheme());
        return new ExplodedManifest(FilesKt.toRelativeString((File)file, (File)this.projectDir), applicationName, theme);
    }

    public AndroidManifestParser(@NotNull Iterable<? extends File> manifests, @NotNull File projectDir, @NotNull String namespace2) {
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        this.manifests = manifests;
        this.projectDir = projectDir;
        this.namespace = namespace2;
        this.parser = new ManifestParser(this.namespace);
        this.explodedManifests = this.compute();
    }
}

