/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.AbiExclusions;
import com.autonomousapps.internal.kotlin.AbiDependenciesKt;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.intermediates.ExplodingAbi;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0014\u0010\u0014\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u0014\u0010\u0018\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/autonomousapps/tasks/AbiAnalysisTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "abiDump", "Lorg/gradle/api/file/RegularFileProperty;", "getAbiDump", "()Lorg/gradle/api/file/RegularFileProperty;", "classes", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "exclusions", "Lorg/gradle/api/provider/Property;", "", "getExclusions", "()Lorg/gradle/api/provider/Property;", "jar", "getJar", "javaClasses", "getJavaClasses", "kotlinClasses", "getKotlinClasses", "output", "getOutput", "action", "", "AbiAnalysisParameters", "AbiAnalysisWorkAction", "dependency-analysis-gradle-plugin"})
public abstract class AbiAnalysisTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;

    @Optional
    @Classpath
    @NotNull
    public abstract RegularFileProperty getJar();

    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @Optional
    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getJavaClasses();

    @Optional
    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getKotlinClasses();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getExclusions();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAbiDump();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(AbiAnalysisWorkAction.class, new Action(this){
            final /* synthetic */ AbiAnalysisTask this$0;

            public final void execute(@NotNull AbiAnalysisParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                $this$submit.getJar().set((Provider)this.this$0.getJar());
                ConfigurableFileCollection configurableFileCollection = $this$submit.getClassFiles();
                FileTree fileTree = this.this$0.getClasses().getAsFileTree().plus(this.this$0.getJavaClasses().getAsFileTree()).plus(this.this$0.getKotlinClasses().getAsFileTree());
                Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"classes.asFileTree\n     \u2026kotlinClasses.asFileTree)");
                configurableFileCollection.setFrom((Iterable)CollectionsKt.filterToClassFiles((FileCollection)fileTree).getFiles());
                $this$submit.getExclusions().set((Provider)this.this$0.getExclusions());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
                $this$submit.getAbiDump().set((Provider)this.this$0.getAbiDump());
            }
            {
                this.this$0 = abiAnalysisTask2;
            }
        });
    }

    @Inject
    public AbiAnalysisTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Produces a report of the ABI of this project");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005R\u0012\u0010\u0011\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisParameters;", "Lorg/gradle/workers/WorkParameters;", "abiDump", "Lorg/gradle/api/file/RegularFileProperty;", "getAbiDump", "()Lorg/gradle/api/file/RegularFileProperty;", "classFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "exclusions", "Lorg/gradle/api/provider/Property;", "", "getExclusions", "()Lorg/gradle/api/provider/Property;", "jar", "getJar", "output", "getOutput", "dependency-analysis-gradle-plugin"})
    public static interface AbiAnalysisParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getJar();

        @NotNull
        public ConfigurableFileCollection getClassFiles();

        @NotNull
        public Property<String> getExclusions();

        @NotNull
        public RegularFileProperty getOutput();

        @NotNull
        public RegularFileProperty getAbiDump();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisParameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    public static abstract class AbiAnalysisWorkAction
    implements WorkAction<AbiAnalysisParameters> {
        public void execute() {
            Set<ExplodingAbi> explodingAbi;
            Object object;
            Set classFiles;
            File jarFile;
            File outputAbiDump;
            File output;
            block3: {
                block2: {
                    output = UtilsKt.getAndDelete(((AbiAnalysisParameters)this.getParameters()).getOutput());
                    outputAbiDump = UtilsKt.getAndDelete(((AbiAnalysisParameters)this.getParameters()).getAbiDump());
                    RegularFile regularFile = (RegularFile)((AbiAnalysisParameters)this.getParameters()).getJar().getOrNull();
                    jarFile = regularFile != null ? regularFile.getAsFile() : null;
                    Set set2 = ((AbiAnalysisParameters)this.getParameters()).getClassFiles().getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"parameters.classFiles.files");
                    classFiles = set2;
                    object = (String)((AbiAnalysisParameters)this.getParameters()).getExclusions().getOrNull();
                    if (object == null) break block2;
                    String $this$fromJson$iv = object;
                    boolean $i$f$fromJson = false;
                    boolean withNulls$iv$iv = false;
                    boolean $i$f$getJsonAdapter = false;
                    JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(AbiExclusions.class);
                    JsonAdapter jsonAdapter = adapter$iv$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
                    Object object2 = jsonAdapter.fromJson($this$fromJson$iv);
                    Intrinsics.checkNotNull((Object)object2);
                    object = (AbiExclusions)object2;
                    if (object != null) break block3;
                }
                object = AbiExclusions.Companion.getNONE();
            }
            Object exclusions = object;
            Set<ExplodingAbi> $this$toJson$iv = explodingAbi = jarFile != null ? AbiDependenciesKt.computeAbi(jarFile, (AbiExclusions)exclusions, outputAbiDump) : AbiDependenciesKt.computeAbi(classFiles, (AbiExclusions)exclusions, outputAbiDump);
            boolean withNulls$iv = false;
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Set.class);
            JsonAdapter jsonAdapter = adapter$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            String string = jsonAdapter.toJson($this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
            FilesKt.writeText$default((File)output, (String)string, null, (int)2, null);
        }
    }
}

