/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.advice.PluginAdvice;
import com.autonomousapps.extension.Behavior;
import com.autonomousapps.extension.Ignore;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/DetectRedundantJvmPluginTask;", "Lorg/gradle/api/DefaultTask;", "()V", "hasJava", "Lorg/gradle/api/provider/Property;", "", "getHasJava", "()Lorg/gradle/api/provider/Property;", "hasKotlin", "getHasKotlin", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "redundantPluginsBehavior", "Lcom/autonomousapps/extension/Behavior;", "getRedundantPluginsBehavior", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class DetectRedundantJvmPluginTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<Boolean> getHasJava();

    @Input
    @NotNull
    public abstract Property<Boolean> getHasKotlin();

    @Input
    @NotNull
    public abstract Property<Behavior> getRedundantPluginsBehavior();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        Object object = this.getRedundantPluginsBehavior().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"redundantPluginsBehavior.get()");
        Behavior behavior2 = (Behavior)object;
        boolean shouldIgnore = behavior2 instanceof Ignore;
        Set pluginAdvices = (Boolean)this.getHasKotlin().get() == false && !shouldIgnore ? SetsKt.mutableSetOf((Object[])new PluginAdvice[]{PluginAdvice.Companion.redundantKotlinJvm()}) : (Set)new LinkedHashSet();
        pluginAdvices.removeIf(new Predicate(behavior2){
            final /* synthetic */ Behavior $behavior;

            public final boolean test(@NotNull PluginAdvice it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$behavior.getFilter().contains(it.getRedundantPlugin());
            }
            {
                this.$behavior = behavior2;
            }
        });
        Set $this$toJson$iv = pluginAdvices;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Set.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)outputFile, (String)string, null, (int)2, null);
    }

    public DetectRedundantJvmPluginTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report about redundant jvm plugins that have been applied");
    }
}

