/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.model.Coordinates;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0007\u001a\u00020\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0007\u001a\u00020\u0005J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/graph/Graphs;", "", "()V", "children", "", "Lcom/autonomousapps/model/Coordinates;", "Lcom/google/common/graph/Graph;", "node", "reachableNodes", "shortestPath", "", "source", "target", "ShortestPath", "Topological", "dependency-analysis-gradle-plugin"})
public final class Graphs {
    @NotNull
    public static final Graphs INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Coordinates> reachableNodes(@NotNull Graph<Coordinates> $this$reachableNodes, @NotNull Coordinates node) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$reachableNodes, (String)"$this$reachableNodes");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Set set2 = com.google.common.graph.Graphs.reachableNodes($this$reachableNodes, (Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"GuavaGraphs.reachableNodes(this, node)");
        Iterable $this$filterNotToSet$iv = set2;
        boolean $i$f$filterNotToSet = false;
        Iterable iterable = $this$filterNotToSet$iv;
        Collection destination$iv$iv = new HashSet();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Coordinates it = (Coordinates)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (Set)destination$iv$iv;
    }

    @NotNull
    public final Set<Coordinates> children(@NotNull Graph<Coordinates> $this$children, @NotNull Coordinates node) {
        Intrinsics.checkNotNullParameter($this$children, (String)"$this$children");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Set set2 = $this$children.successors((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"successors(node)");
        return set2;
    }

    @NotNull
    public final Iterable<Coordinates> shortestPath(@NotNull Graph<Coordinates> $this$shortestPath, @NotNull Coordinates source, @NotNull Coordinates target) {
        Intrinsics.checkNotNullParameter($this$shortestPath, (String)"$this$shortestPath");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ShortestPath<Coordinates> path = new ShortestPath<Coordinates>($this$shortestPath, source);
        return path.pathTo(target);
    }

    private Graphs() {
    }

    static {
        Graphs graphs;
        INSTANCE = graphs = new Graphs();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J!\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\bj\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/graph/Graphs$ShortestPath;", "N", "", "graph", "Lcom/google/common/graph/Graph;", "source", "(Lcom/google/common/graph/Graph;Ljava/lang/Object;)V", "distTo", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "edgeTo", "Lcom/google/common/graph/EndpointPair;", "Ljava/lang/Object;", "edgesTo", "", "other", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "hasPathTo", "", "(Ljava/lang/Object;)Z", "pathTo", "relax", "", "target", "(Ljava/lang/Object;Ljava/lang/Object;)V", "dependency-analysis-gradle-plugin"})
    public static final class ShortestPath<N> {
        private final LinkedHashMap<N, Float> distTo;
        private final LinkedHashMap<N, EndpointPair<N>> edgeTo;
        private final N source;

        public final boolean hasPathTo(@NotNull N other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            Float f = this.distTo.get(other);
            if (f == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"distTo[other] ?: return false");
            float dist = f.floatValue();
            return dist < Float.MAX_VALUE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Iterable<N> pathTo(@NotNull N other) {
            void var3_3;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter(other, (String)"other");
            if (!this.hasPathTo(other)) {
                return CollectionsKt.emptyList();
            }
            Iterable<EndpointPair<N>> iterable = this.edgesTo(other);
            Collection destination$iv = CollectionsKt.mutableListOf((Object[])new Object[]{this.source});
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                EndpointPair endpointPair = (EndpointPair)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Object object = it.target();
                collection.add(object);
            }
            return (Iterable)var3_3;
        }

        private final Iterable<EndpointPair<N>> edgesTo(N other) {
            if (!this.hasPathTo(other)) {
                return CollectionsKt.emptyList();
            }
            ArrayDeque<EndpointPair<N>> path = new ArrayDeque<EndpointPair<N>>();
            EndpointPair<N> e = this.edgeTo.get(other);
            while (e != null) {
                path.push(e);
                e = this.edgeTo.get(e.source());
            }
            return path;
        }

        private final void relax(N source, N target) {
            Float f = this.distTo.get(target);
            Intrinsics.checkNotNull((Object)f);
            float f2 = ((Number)f).floatValue();
            Float f3 = this.distTo.get(source);
            Intrinsics.checkNotNull((Object)f3);
            if (Float.compare(f2, ((Number)f3).floatValue() + 1.0f) > 0) {
                Map map = this.distTo;
                Float f4 = this.distTo.get(source);
                Intrinsics.checkNotNull((Object)f4);
                map.put(target, Float.valueOf(((Number)f4).floatValue() + 1.0f));
                Map map2 = this.edgeTo;
                EndpointPair endpointPair = EndpointPair.ordered(source, target);
                Intrinsics.checkNotNullExpressionValue((Object)endpointPair, (String)"EndpointPair.ordered(source, target)");
                map2.put(target, endpointPair);
            }
        }

        public ShortestPath(@NotNull Graph<N> graph, @NotNull N source) {
            Intrinsics.checkNotNullParameter(graph, (String)"graph");
            Intrinsics.checkNotNullParameter(source, (String)"source");
            this.source = source;
            boolean bl = false;
            this.distTo = new LinkedHashMap();
            bl = false;
            this.edgeTo = new LinkedHashMap();
            for (Object node : graph.nodes()) {
                Map map = this.distTo;
                Object e = node;
                Intrinsics.checkNotNullExpressionValue(e, (String)"node");
                map.put(e, Float.valueOf(Float.POSITIVE_INFINITY));
            }
            ((Map)this.distTo).put(this.source, Float.valueOf(0.0f));
            Topological<N> top = new Topological<N>(graph, this.source);
            for (N from : top.getOrder()) {
                Iterator iterator = graph.successors(from).iterator();
                while (iterator.hasNext()) {
                    Object to;
                    Object e = to = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"to");
                    this.relax(from, e);
                }
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/autonomousapps/graph/Graphs$Topological;", "N", "", "graph", "Lcom/google/common/graph/Graph;", "source", "(Lcom/google/common/graph/Graph;Ljava/lang/Object;)V", "order", "", "getOrder", "()Ljava/lang/Iterable;", "dependency-analysis-gradle-plugin"})
    public static final class Topological<N> {
        @NotNull
        private final Iterable<N> order;

        @NotNull
        public final Iterable<N> getOrder() {
            return this.order;
        }

        public Topological(@NotNull Graph<N> graph, @NotNull N source) {
            Intrinsics.checkNotNullParameter(graph, (String)"graph");
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Iterable iterable = Traverser.forGraph((SuccessorsFunction)((SuccessorsFunction)graph)).depthFirstPostOrder(source);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"Traverser.forGraph(graph\u2026pthFirstPostOrder(source)");
            Iterable postorder = iterable;
            ArrayDeque reverse = new ArrayDeque();
            for (Object node : postorder) {
                reverse.push(node);
            }
            this.order = reverse;
        }
    }
}

