/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.SourceProvider;
import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.AndroidAnalyzer;
import com.autonomousapps.internal.analyzer.AndroidAnalyzer$WhenMappings;
import com.autonomousapps.internal.analyzer.VariantSourceSet;
import com.autonomousapps.internal.android.AndroidGradlePlugin;
import com.autonomousapps.internal.android.AndroidGradlePluginFactory;
import com.autonomousapps.internal.utils.TasksKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.declaration.SourceSetKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.FindAndroidAssetProviders;
import com.autonomousapps.tasks.FindAndroidLinters;
import com.autonomousapps.tasks.FindAndroidResTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import com.autonomousapps.tasks.FindNativeLibsTask;
import com.autonomousapps.tasks.ManifestComponentsExtractionTask;
import com.autonomousapps.tasks.XmlSourceExploderTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010B\u001a\u0004\u0018\u00010CH\u0002J\b\u0010D\u001a\u00020\tH\u0002J\b\u0010E\u001a\u00020 H\u0002J\b\u0010F\u001a\u00020 H\u0002J\b\u0010G\u001a\u00020 H\u0002J\b\u0010H\u001a\u00020 H\u0002J\b\u0010I\u001a\u00020JH\u0002J\b\u0010K\u001a\u00020 H\u0002J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020N0MH\u0004J\b\u0010O\u001a\u00020 H\u0002J\n\u0010P\u001a\u0004\u0018\u00010CH\u0002J\u0010\u0010Q\u001a\n\u0012\u0004\u0012\u00020N\u0018\u00010MH\u0004J\b\u0010R\u001a\u00020 H\u0002J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020T0MH\u0016J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020V0MH\u0016J\u000e\u0010W\u001a\b\u0012\u0004\u0012\u00020X0MH\u0016J\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0MH\u0016J\u001c\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0M2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^H\u0016J\u000e\u0010`\u001a\b\u0012\u0004\u0012\u00020a0MH\u0016J\u000e\u0010b\u001a\b\u0012\u0004\u0012\u00020c0MH\u0016J\b\u0010d\u001a\u00020 H\u0002R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0011R\u0011\u00103\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0011R\u0011\u00105\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0011R\u0011\u00107\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0011R\u0011\u0010=\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/autonomousapps/internal/analyzer/AndroidAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "variantSourceSet", "Lcom/autonomousapps/internal/analyzer/VariantSourceSet;", "agpVersion", "", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/api/BaseVariant;Lcom/autonomousapps/internal/analyzer/VariantSourceSet;Ljava/lang/String;)V", "agp", "Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "getAgp", "()Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "annotationProcessorConfigurationName", "getAnnotationProcessorConfigurationName", "()Ljava/lang/String;", "attributeValueJar", "getAttributeValueJar", "buildType", "getBuildType", "compileConfigurationName", "getCompileConfigurationName", "dataBindingEnabled", "", "flavorName", "getFlavorName", "isDataBindingEnabled", "()Z", "isViewBindingEnabled", "javaAndKotlinSourceFiles", "Lorg/gradle/api/file/FileTree;", "getJavaAndKotlinSourceFiles", "()Lorg/gradle/api/file/FileTree;", "javaSourceFiles", "getJavaSourceFiles", "kaptConfigurationName", "getKaptConfigurationName", "kind", "Lcom/autonomousapps/model/declaration/SourceSetKind;", "getKind", "()Lcom/autonomousapps/model/declaration/SourceSetKind;", "kotlinSourceFiles", "getKotlinSourceFiles", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "runtimeConfigurationName", "getRuntimeConfigurationName", "taskNameSuffix", "getTaskNameSuffix", "testJavaCompileName", "getTestJavaCompileName", "testKotlinCompileName", "getTestKotlinCompileName", "getVariant", "()Lcom/android/build/gradle/api/BaseVariant;", "variantName", "getVariantName", "variantNameCapitalized", "getVariantNameCapitalized", "getVariantSourceSet", "()Lcom/autonomousapps/internal/analyzer/VariantSourceSet;", "viewBindingEnabled", "annotationProcessorConf", "Lorg/gradle/api/artifacts/Configuration;", "computeTaskNameSuffix", "getAndroidRes", "getJavaAndKotlinSources", "getJavaSources", "getKotlinSources", "getSourceDirectories", "Lorg/gradle/api/file/ConfigurableFileCollection;", "javaAndKotlinSource", "javaCompileTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "javaSource", "kaptConf", "kotlinCompileTask", "kotlinSource", "registerExplodeXmlSourceTask", "Lcom/autonomousapps/tasks/XmlSourceExploderTask;", "registerFindAndroidAssetProvidersTask", "Lcom/autonomousapps/tasks/FindAndroidAssetProviders;", "registerFindAndroidLintersTask", "Lcom/autonomousapps/tasks/FindAndroidLinters;", "registerFindAndroidResTask", "Lcom/autonomousapps/tasks/FindAndroidResTask;", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "inMemoryCache", "Lorg/gradle/api/provider/Provider;", "Lcom/autonomousapps/services/InMemoryCache;", "registerFindNativeLibsTask", "Lcom/autonomousapps/tasks/FindNativeLibsTask;", "registerManifestComponentsExtractionTask", "Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "source", "dependency-analysis-gradle-plugin"})
public abstract class AndroidAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final AndroidGradlePlugin agp;
    private final boolean dataBindingEnabled;
    private final boolean viewBindingEnabled;
    @NotNull
    private final String flavorName;
    @NotNull
    private final String variantName;
    @NotNull
    private final String buildType;
    @NotNull
    private final SourceSetKind kind;
    @NotNull
    private final String variantNameCapitalized;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @NotNull
    private final FileTree kotlinSourceFiles;
    @NotNull
    private final FileTree javaSourceFiles;
    @NotNull
    private final FileTree javaAndKotlinSourceFiles;
    @NotNull
    private final String attributeValueJar;
    private final boolean isDataBindingEnabled;
    private final boolean isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;
    @NotNull
    private final String testJavaCompileName;
    @NotNull
    private final String testKotlinCompileName;
    @NotNull
    private final BaseVariant variant;
    @NotNull
    private final VariantSourceSet variantSourceSet;

    @NotNull
    protected final AndroidGradlePlugin getAgp() {
        return this.agp;
    }

    @Override
    @NotNull
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceSetKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public final String getVariantNameCapitalized() {
        return this.variantNameCapitalized;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @NotNull
    public final FileTree getKotlinSourceFiles() {
        return this.kotlinSourceFiles;
    }

    @Override
    @NotNull
    public final FileTree getJavaSourceFiles() {
        return this.javaSourceFiles;
    }

    @Override
    @NotNull
    public final FileTree getJavaAndKotlinSourceFiles() {
        return this.javaAndKotlinSourceFiles;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    public final boolean isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    public final boolean isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    @Override
    @NotNull
    public final OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    @Override
    @NotNull
    public final String getTestJavaCompileName() {
        return this.testJavaCompileName;
    }

    @Override
    @NotNull
    public final String getTestKotlinCompileName() {
        return this.testKotlinCompileName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<ManifestComponentsExtractionTask> registerManifestComponentsExtractionTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "extractPackageNameFromManifest" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<ManifestComponentsExtractionTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;

            public final void invoke(@NotNull ManifestComponentsExtractionTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setArtifacts(ArtifactViewsKt.artifactsFor((Configuration)object, "android-manifest"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getManifestPackagesPath());
            }
            {
                this.this$0 = androidAnalyzer;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ManifestComponentsExtractionTask.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void execute(Object p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<FindAndroidResTask> registerFindAndroidResTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidResImports" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindAndroidResTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;

            public final void invoke(@NotNull FindAndroidResTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setAndroidSymbols(ArtifactViewsKt.artifactsFor((Configuration)object, "android-symbol-with-package-name"));
                Project project2 = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                ConfigurationContainer configurationContainer2 = project2.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer2, (String)"project.configurations");
                Object object2 = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer2), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations[compileConfigurationName]");
                $this$register.setAndroidPublicRes(ArtifactViewsKt.artifactsFor((Configuration)object2, "android-public-res"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidResPath());
            }
            {
                this.this$0 = androidAnalyzer;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidResTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<XmlSourceExploderTask> registerExplodeXmlSourceTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeXmlSource" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<XmlSourceExploderTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull XmlSourceExploderTask $this$register) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                $this$register.getAndroidLocalRes().setFrom((Iterable)AndroidAnalyzer.access$getAndroidRes(this.this$0));
                List list = this.this$0.getVariant().getSourceSets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
                Iterable iterable = list;
                XmlSourceExploderTask xmlSourceExploderTask = $this$register;
                boolean $i$f$flatMap = false;
                void var4_5 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    SourceProvider it = (SourceProvider)element$iv$iv;
                    boolean bl = false;
                    SourceProvider sourceProvider = it;
                    Intrinsics.checkNotNullExpressionValue((Object)sourceProvider, (String)"it");
                    Iterable list$iv$iv = sourceProvider.getResDirectories();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                xmlSourceExploderTask.layouts$dependency_analysis_gradle_plugin(list2);
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidResToResUsagePath());
            }
            {
                this.this$0 = androidAnalyzer;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, XmlSourceExploderTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<FindNativeLibsTask> registerFindNativeLibsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findNativeLibs" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindNativeLibsTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;

            public final void invoke(@NotNull FindNativeLibsTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setAndroidJni(ArtifactViewsKt.artifactsFor((Configuration)object, "android-jni"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getNativeDependenciesPath());
            }
            {
                this.this$0 = androidAnalyzer;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindNativeLibsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<FindAndroidLinters> registerFindAndroidLintersTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidLinters" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindAndroidLinters, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;

            public final void invoke(@NotNull FindAndroidLinters $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setLintJars(ArtifactViewsKt.artifactsFor((Configuration)object, "android-lint"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidLintersPath());
            }
            {
                this.this$0 = androidAnalyzer;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidLinters.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<FindAndroidAssetProviders> registerFindAndroidAssetProvidersTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidAssetProviders" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindAndroidAssetProviders, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;

            public final void invoke(@NotNull FindAndroidAssetProviders $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getRuntimeConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[runtimeConfigurationName]");
                $this$register.setAssets(ArtifactViewsKt.artifactsFor((Configuration)object, "android-assets"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidAssetsPath());
            }
            {
                this.this$0 = androidAnalyzer;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidAssetProviders.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask(@NotNull Provider<InMemoryCache> inMemoryCache2) {
        void name$iv;
        void $this$register$iv;
        Intrinsics.checkNotNullParameter(inMemoryCache2, (String)"inMemoryCache");
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findDeclaredProcs" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindDeclaredProcsTask, Unit>(this, inMemoryCache2){
            final /* synthetic */ AndroidAnalyzer this$0;
            final /* synthetic */ Provider $inMemoryCache;

            public final void invoke(@NotNull FindDeclaredProcsTask $this$register) {
                Configuration it;
                boolean bl;
                boolean bl2;
                Configuration configuration;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                $this$register.getInMemoryCacheProvider().set(this.$inMemoryCache);
                Configuration configuration2 = AndroidAnalyzer.access$kaptConf(this.this$0);
                if (configuration2 != null) {
                    configuration = configuration2;
                    bl2 = false;
                    bl = false;
                    it = configuration;
                    boolean bl3 = false;
                    ResolvableDependencies resolvableDependencies = it.getIncoming();
                    Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"it.incoming");
                    ArtifactCollection artifactCollection = resolvableDependencies.getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"it.incoming.artifacts");
                    $this$register.setKaptArtifacts(artifactCollection);
                }
                Configuration configuration3 = AndroidAnalyzer.access$annotationProcessorConf(this.this$0);
                if (configuration3 != null) {
                    configuration = configuration3;
                    bl2 = false;
                    bl = false;
                    it = configuration;
                    boolean bl4 = false;
                    ResolvableDependencies resolvableDependencies = it.getIncoming();
                    Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"it.incoming");
                    ArtifactCollection artifactCollection = resolvableDependencies.getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"it.incoming.artifacts");
                    $this$register.setAnnotationProcessorArtifacts(artifactCollection);
                }
                $this$register.getOutput().set(this.this$0.getOutputPaths().getDeclaredProcPath());
                $this$register.getOutputPretty().set(this.this$0.getOutputPaths().getDeclaredProcPrettyPath());
            }
            {
                this.this$0 = androidAnalyzer;
                this.$inMemoryCache = provider;
                super(1);
            }
        };
        boolean $i$f$register = false;
        Function1 function1 = configuration$iv;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindDeclaredProcsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    @Nullable
    protected final TaskProvider<Task> kotlinCompileTask() {
        TaskProvider<Task> taskProvider;
        switch (AndroidAnalyzer$WhenMappings.$EnumSwitchMapping$0[this.variantSourceSet.getVariant().getKind().ordinal()]) {
            case 1: {
                TaskContainer taskContainer = this.getProject().getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                taskProvider = TasksKt.namedOrNull(taskContainer, "compile" + this.variantNameCapitalized + "Kotlin");
                break;
            }
            case 2: {
                TaskContainer taskContainer = this.getProject().getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                taskProvider = TasksKt.namedOrNull(taskContainer, "compile" + this.variantNameCapitalized + "UnitTestKotlin");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return taskProvider;
    }

    @NotNull
    protected final TaskProvider<Task> javaCompileTask() {
        TaskProvider taskProvider;
        switch (AndroidAnalyzer$WhenMappings.$EnumSwitchMapping$1[this.variantSourceSet.getVariant().getKind().ordinal()]) {
            case 1: {
                TaskProvider taskProvider2 = this.getProject().getTasks().named("compile" + this.variantNameCapitalized + "JavaWithJavac");
                taskProvider = taskProvider2;
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.named(\"com\u2026pitalized}JavaWithJavac\")");
                break;
            }
            case 2: {
                TaskProvider taskProvider3 = this.getProject().getTasks().named("compile" + this.variantNameCapitalized + "UnitTestJavaWithJavac");
                taskProvider = taskProvider3;
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"project.tasks.named(\"com\u2026d}UnitTestJavaWithJavac\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return taskProvider;
    }

    private final String computeTaskNameSuffix() {
        return this.variantSourceSet.getVariant().getKind() == SourceSetKind.MAIN ? UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null) : UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null) + this.variantSourceSet.getVariant().getKind().getTaskNameSuffix();
    }

    private final Configuration kaptConf() {
        Configuration configuration;
        try {
            ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
            configuration = (Configuration)NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.kaptConfigurationName);
        }
        catch (UnknownDomainObjectException _) {
            configuration = null;
        }
        return configuration;
    }

    private final Configuration annotationProcessorConf() {
        Configuration configuration;
        try {
            ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
            configuration = (Configuration)NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.annotationProcessorConfigurationName);
        }
        catch (UnknownDomainObjectException _) {
            configuration = null;
        }
        return configuration;
    }

    private final FileTree javaSource() {
        FileTree fileTree = this.source().matching((Action)javaSource.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"source().matching {\n    \u2026 exclude(\"**/*.kt\")\n    }");
        return fileTree;
    }

    private final FileTree kotlinSource() {
        FileTree fileTree = this.source().matching((Action)kotlinSource.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"source().matching {\n    \u2026 exclude(\"**/*.java\")\n  }");
        return fileTree;
    }

    private final FileTree javaAndKotlinSource() {
        FileTree fileTree = this.source().matching((Action)javaAndKotlinSource.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"source().matching {\n    \u2026   include(\"**/*.kt\")\n  }");
        return fileTree;
    }

    /*
     * WARNING - void declaration
     */
    private final FileTree source() {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        SourceProvider it;
        Iterable $this$flatMapTo$iv$iv;
        List list = this.variant.getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            SourceProvider sourceProvider = it;
            Intrinsics.checkNotNullExpressionValue((Object)sourceProvider, (String)"it");
            list$iv$iv = sourceProvider.getJavaDirectories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)it);
            collection.add(configurableFileTree);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            FileTree $i$f$mapTo2 = (FileTree)iterator$iv.next();
            FileTree p1 = (FileTree)accumulator$iv;
            boolean bl = false;
            accumulator$iv = p1.plus((FileTree)p2);
        }
        Object t = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue(t, (String)"variant.sourceSets\n    .\u2026  .reduce(FileTree::plus)");
        return (FileTree)t;
    }

    private final FileTree getKotlinSources() {
        FileTree fileTree = this.getSourceDirectories().getAsFileTree().matching((Action)getKotlinSources.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().a\u2026 exclude(\"**/*.java\")\n  }");
        return fileTree;
    }

    private final FileTree getJavaSources() {
        FileTree fileTree = this.getSourceDirectories().getAsFileTree().matching((Action)getJavaSources.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().a\u2026   exclude(\"**/*.kt\")\n  }");
        return fileTree;
    }

    private final FileTree getJavaAndKotlinSources() {
        FileTree fileTree = this.getSourceDirectories().getAsFileTree().matching((Action)getJavaAndKotlinSources.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().a\u2026 include(\"**/*.kt\")\n    }");
        return fileTree;
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigurableFileCollection getSourceDirectories() {
        Object[] objectArray;
        Iterable $this$filterTo$iv$iv;
        Object[] objectArray2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.variantSourceSet.getAndroidSourceSets();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SourceProvider it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getJavaDirectories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List javaDirs = (List)destination$iv$iv;
        Iterable $this$map$iv = javaDirs;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File bl = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            objectArray2 = v0.getPath();
            collection.add(objectArray2);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string = it;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
            objectArray2 = stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)"java")).append("kotlin").toString();
            collection.add(objectArray2);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            objectArray2 = new File(it);
            collection.add(objectArray2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List kotlinDirs = (List)destination$iv$iv2;
        $this$filter$iv = javaDirs;
        int n = 0;
        objectArray2 = objectArray = new Object[1];
        collection = this.getProject();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        objectArray[n] = CollectionsKt.plus((Collection)list, (Iterable)kotlinDirs);
        ConfigurableFileCollection configurableFileCollection = collection.files(objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(javaDirs.f\u2026.exists() } + kotlinDirs)");
        return configurableFileCollection;
    }

    /*
     * WARNING - void declaration
     */
    private final FileTree getAndroidRes() {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        List list = this.variant.getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            SourceProvider sourceProvider = it;
            Intrinsics.checkNotNullExpressionValue((Object)sourceProvider, (String)"it");
            Iterable list$iv$iv = sourceProvider.getResDirectories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!((File)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List resDirs = (List)destination$iv$iv;
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[]{resDirs});
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(resDirs)");
        FileTree fileTree = configurableFileCollection.getAsFileTree().matching((Action)getAndroidRes.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.files(resDirs).a\u2026include(\"**/*.xml\")\n    }");
        return fileTree;
    }

    @NotNull
    protected final BaseVariant getVariant() {
        return this.variant;
    }

    @NotNull
    protected final VariantSourceSet getVariantSourceSet() {
        return this.variantSourceSet;
    }

    public AndroidAnalyzer(@NotNull Project project, @NotNull BaseVariant variant, @NotNull VariantSourceSet variantSourceSet, @NotNull String agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)variantSourceSet, (String)"variantSourceSet");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        super(project);
        this.variant = variant;
        this.variantSourceSet = variantSourceSet;
        this.agp = new AndroidGradlePluginFactory(project, agpVersion).newAdapter();
        this.dataBindingEnabled = this.agp.isDataBindingEnabled();
        this.viewBindingEnabled = this.agp.isViewBindingEnabled();
        String string = this.variant.getFlavorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.flavorName");
        this.flavorName = string;
        String string2 = this.variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
        this.variantName = string2;
        BuildType buildType = this.variant.getBuildType();
        Intrinsics.checkNotNullExpressionValue((Object)buildType, (String)"variant.buildType");
        this.buildType = buildType.getName();
        this.kind = this.variantSourceSet.getVariant().getKind();
        this.variantNameCapitalized = UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null);
        this.taskNameSuffix = this.computeTaskNameSuffix();
        this.compileConfigurationName = this.variantSourceSet.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.variantSourceSet.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = "kapt" + this.variantNameCapitalized;
        this.annotationProcessorConfigurationName = this.variantName + "AnnotationProcessorClasspath";
        this.kotlinSourceFiles = this.getKotlinSources();
        this.javaSourceFiles = this.getJavaSources();
        this.javaAndKotlinSourceFiles = this.getJavaAndKotlinSources();
        this.attributeValueJar = StringsKt.startsWith$default((String)agpVersion, (String)"4.", (boolean)false, (int)2, null) ? "android-classes-jar" : "android-classes";
        this.isDataBindingEnabled = this.dataBindingEnabled;
        this.isViewBindingEnabled = this.viewBindingEnabled;
        this.outputPaths = new OutputPaths(project, this.variantName + this.kind.getTaskNameSuffix());
        this.testJavaCompileName = "compile" + this.variantNameCapitalized + "UnitTestJavaWithJavac";
        this.testKotlinCompileName = "compile" + this.variantNameCapitalized + "UnitTestKotlin";
    }

    public static final /* synthetic */ FileTree access$getAndroidRes(AndroidAnalyzer $this) {
        return $this.getAndroidRes();
    }

    public static final /* synthetic */ Configuration access$kaptConf(AndroidAnalyzer $this) {
        return $this.kaptConf();
    }

    public static final /* synthetic */ Configuration access$annotationProcessorConf(AndroidAnalyzer $this) {
        return $this.annotationProcessorConf();
    }
}

