/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.Dependency;
import com.autonomousapps.model.DependencyGraphView;
import com.autonomousapps.model.ProjectVariant;
import com.autonomousapps.model.declaration.Declaration;
import com.autonomousapps.model.intermediates.DependencyTraceReport;
import com.autonomousapps.tasks.GraphVisitor;
import com.autonomousapps.visitor.GraphViewReader;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/tasks/ComputeUsagesTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "dependencies", "Lorg/gradle/api/file/DirectoryProperty;", "getDependencies", "()Lorg/gradle/api/file/DirectoryProperty;", "graph", "Lorg/gradle/api/file/RegularFileProperty;", "getGraph", "()Lorg/gradle/api/file/RegularFileProperty;", "locations", "getLocations", "output", "getOutput", "syntheticProject", "getSyntheticProject", "action", "", "ComputeUsagesAction", "ComputeUsagesParameters", "dependency-analysis-gradle-plugin"})
public abstract class ComputeUsagesTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraph();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getLocations();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getDependencies();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getSyntheticProject();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(ComputeUsagesAction.class, new Action(this){
            final /* synthetic */ ComputeUsagesTask this$0;

            public final void execute(@NotNull ComputeUsagesParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                $this$submit.getGraph().set((Provider)this.this$0.getGraph());
                $this$submit.getLocations().set((Provider)this.this$0.getLocations());
                $this$submit.getDependencies().set((Provider)this.this$0.getDependencies());
                $this$submit.getSyntheticProject().set((Provider)this.this$0.getSyntheticProject());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
            {
                this.this$0 = computeUsagesTask2;
            }
        });
    }

    @Inject
    public ComputeUsagesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Computes actual dependency usage");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ComputeUsagesTask$ComputeUsagesParameters;", "Lorg/gradle/workers/WorkParameters;", "dependencies", "Lorg/gradle/api/file/DirectoryProperty;", "getDependencies", "()Lorg/gradle/api/file/DirectoryProperty;", "graph", "Lorg/gradle/api/file/RegularFileProperty;", "getGraph", "()Lorg/gradle/api/file/RegularFileProperty;", "locations", "getLocations", "output", "getOutput", "syntheticProject", "getSyntheticProject", "dependency-analysis-gradle-plugin"})
    public static interface ComputeUsagesParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getGraph();

        @NotNull
        public RegularFileProperty getLocations();

        @NotNull
        public DirectoryProperty getDependencies();

        @NotNull
        public RegularFileProperty getSyntheticProject();

        @NotNull
        public RegularFileProperty getOutput();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/tasks/ComputeUsagesTask$ComputeUsagesAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ComputeUsagesTask$ComputeUsagesParameters;", "()V", "declarations", "", "Lcom/autonomousapps/model/declaration/Declaration;", "dependencies", "Lcom/autonomousapps/model/Dependency;", "dependenciesDir", "Lorg/gradle/api/file/Directory;", "graph", "Lcom/autonomousapps/model/DependencyGraphView;", "project", "Lcom/autonomousapps/model/ProjectVariant;", "execute", "", "getDependency", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "dependency-analysis-gradle-plugin"})
    public static abstract class ComputeUsagesAction
    implements WorkAction<ComputeUsagesParameters> {
        private final Directory dependenciesDir;
        private final DependencyGraphView graph;
        private final Set<Declaration> declarations;
        private final ProjectVariant project;
        private final Set<Dependency> dependencies;

        public void execute() {
            DependencyTraceReport report;
            File output = UtilsKt.getAndDelete(((ComputeUsagesParameters)this.getParameters()).getOutput());
            GraphViewReader reader = new GraphViewReader(this.project, this.dependencies, this.graph, this.declarations);
            GraphVisitor visitor = new GraphVisitor(this.project);
            reader.accept(visitor);
            DependencyTraceReport $this$toJson$iv = report = visitor.getReport();
            boolean withNulls$iv = false;
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyTraceReport.class);
            JsonAdapter jsonAdapter = adapter$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            String string = jsonAdapter.toJson((Object)$this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
            FilesKt.writeText$default((File)output, (String)string, null, (int)2, null);
        }

        private final Dependency getDependency(Coordinates coordinates) {
            RegularFile regularFile = this.dependenciesDir.file(coordinates.toFileName());
            Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"dependenciesDir.file(coordinates.toFileName())");
            RegularFile file = regularFile;
            if (!file.getAsFile().exists()) {
                String string = "No file for " + coordinates.gav();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            RegularFile $this$fromJson$iv = file;
            boolean $i$f$fromJson = false;
            File file2 = $this$fromJson$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            File $this$fromJson$iv$iv = file2;
            boolean $i$f$fromJson2 = false;
            String $this$fromJson$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv, null, (int)1, null);
            boolean $i$f$fromJson3 = false;
            boolean withNulls$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(Dependency.class);
            JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            Object object = jsonAdapter.fromJson($this$fromJson$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object);
            return (Dependency)object;
        }

        public ComputeUsagesAction() {
            Object object = ((ComputeUsagesParameters)this.getParameters()).getDependencies().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.dependencies.get()");
            this.dependenciesDir = (Directory)object;
            RegularFileProperty $this$fromJson$iv = ((ComputeUsagesParameters)this.getParameters()).getGraph();
            boolean $i$f$fromJson = false;
            Object object2 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            String $this$fromJson$iv$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv$iv, null, (int)1, null);
            boolean $i$f$fromJson4 = false;
            boolean withNulls$iv$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraphView.class);
            JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter");
            Object object3 = jsonAdapter.fromJson($this$fromJson$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object3);
            this.graph = (DependencyGraphView)object3;
            RegularFileProperty $this$fromJsonSet$iv = ((ComputeUsagesParameters)this.getParameters()).getLocations();
            boolean $i$f$fromJsonSet = false;
            Object object4 = $this$fromJsonSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get()");
            RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJsonSet2 = false;
            File file2 = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            String $this$fromJsonSet$iv$iv$iv = FilesKt.readText$default((File)file2, null, (int)1, null);
            boolean withNulls$iv$iv$iv = false;
            boolean $i$f$fromJsonSet3 = false;
            boolean $i$f$getJsonSetAdapter = false;
            ParameterizedType type$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)Declaration.class)});
            JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv$iv);
            JsonAdapter jsonAdapter2 = adapter$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"adapter");
            Object object5 = jsonAdapter2.fromJson($this$fromJsonSet$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object5);
            this.declarations = (Set)object5;
            $this$fromJson$iv = ((ComputeUsagesParameters)this.getParameters()).getSyntheticProject();
            $i$f$fromJson = false;
            Object object6 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get()");
            $this$fromJson$iv$iv = (RegularFile)object6;
            $i$f$fromJson2 = false;
            File file3 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"asFile");
            $this$fromJson$iv$iv$iv = file3;
            $i$f$fromJson3 = false;
            $this$fromJson$iv$iv$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv$iv$iv, null, (int)1, null);
            $i$f$fromJson4 = false;
            withNulls$iv$iv$iv$iv$iv = false;
            $i$f$getJsonAdapter = false;
            adapter$iv$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(ProjectVariant.class);
            JsonAdapter jsonAdapter3 = adapter$iv$iv$iv$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter");
            Object object7 = jsonAdapter3.fromJson($this$fromJson$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object7);
            this.project = (ProjectVariant)object7;
            this.dependencies = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.project.getClasspath()), (Iterable)this.project.getAnnotationProcessors()), (Function1)((Function1)new Function1<Coordinates, Dependency>(this){

                @NotNull
                public final Dependency invoke(@NotNull Coordinates p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ComputeUsagesAction.access$getDependency((ComputeUsagesAction)this.receiver, p1);
                }
            })));
        }

        public static final /* synthetic */ Dependency access$getDependency(ComputeUsagesAction $this, Coordinates coordinates) {
            return $this.getDependency(coordinates);
        }
    }
}

