/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.antlr.v4.runtime.CharStream;
import com.autonomousapps.internal.antlr.v4.runtime.CharStreams;
import com.autonomousapps.internal.antlr.v4.runtime.CommonTokenStream;
import com.autonomousapps.internal.antlr.v4.runtime.tree.ParseTreeWalker;
import com.autonomousapps.internal.grammar.SimpleLexer;
import com.autonomousapps.internal.grammar.SimpleParser;
import com.autonomousapps.model.CodeSource;
import com.autonomousapps.model.intermediates.ExplodingSourceCode;
import com.autonomousapps.tasks.SourceListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/tasks/SourceExploder;", "", "projectDir", "Ljava/io/File;", "javaSourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinSourceFiles", "(Ljava/io/File;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/ConfigurableFileCollection;)V", "canonicalClassName", "", "relativePath", "explode", "", "Lcom/autonomousapps/model/intermediates/ExplodingSourceCode;", "newSimpleParser", "Lcom/autonomousapps/internal/grammar/SimpleParser;", "file", "parseSourceFileForImports", "relativize", "walkTree", "Lcom/autonomousapps/tasks/SourceListener;", "parser", "dependency-analysis-gradle-plugin"})
final class SourceExploder {
    private final File projectDir;
    private final ConfigurableFileCollection javaSourceFiles;
    private final ConfigurableFileCollection kotlinSourceFiles;

    @NotNull
    public final Set<ExplodingSourceCode> explode() {
        ExplodingSourceCode explodingSourceCode;
        String rel;
        File it;
        Collection collection;
        TreeSet destination = SetsKt.sortedSetOf((Object[])new ExplodingSourceCode[0]);
        Iterable $this$mapTo$iv = (Iterable)this.javaSourceFiles;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            File file = (File)item$iv;
            collection = destination;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            rel = this.relativize((File)v0);
            explodingSourceCode = new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.JAVA, this.parseSourceFileForImports(it));
            collection.add(explodingSourceCode);
        }
        $this$mapTo$iv = (Iterable)this.kotlinSourceFiles;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (File)item$iv;
            collection = destination;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            rel = this.relativize(file);
            explodingSourceCode = new ExplodingSourceCode(rel, this.canonicalClassName(rel), CodeSource.Kind.KOTLIN, this.parseSourceFileForImports(it));
            collection.add(explodingSourceCode);
        }
        return destination;
    }

    private final String relativize(File file) {
        return FilesKt.toRelativeString((File)file, (File)this.projectDir);
    }

    private final String canonicalClassName(String relativePath) {
        Path path = Paths.get(relativePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(relativePath)");
        return StringsKt.substringBeforeLast$default((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)path, (int)3), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), (char)'.', null, (int)2, null);
    }

    private final Set<String> parseSourceFileForImports(File file) {
        SimpleParser parser = this.newSimpleParser(file);
        SourceListener importListener = this.walkTree(parser);
        return importListener.imports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SimpleParser newSimpleParser(File file) {
        CharStream charStream;
        Closeable closeable = new FileInputStream(file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream fis = (FileInputStream)closeable;
            boolean bl3 = false;
            charStream = CharStreams.fromStream(fis);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        CharStream input = charStream;
        SimpleLexer lexer = new SimpleLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        return new SimpleParser(tokens);
    }

    private final SourceListener walkTree(SimpleParser parser) {
        SimpleParser.FileContext tree = parser.file();
        ParseTreeWalker walker = new ParseTreeWalker();
        SourceListener importListener = new SourceListener();
        walker.walk(importListener, tree);
        return importListener;
    }

    public SourceExploder(@NotNull File projectDir, @NotNull ConfigurableFileCollection javaSourceFiles, @NotNull ConfigurableFileCollection kotlinSourceFiles) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)javaSourceFiles, (String)"javaSourceFiles");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceFiles, (String)"kotlinSourceFiles");
        this.projectDir = projectDir;
        this.javaSourceFiles = javaSourceFiles;
        this.kotlinSourceFiles = kotlinSourceFiles;
    }
}

