/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.model.AndroidAssetCapability;
import com.autonomousapps.model.AndroidLinterCapability;
import com.autonomousapps.model.AndroidManifestCapability;
import com.autonomousapps.model.AndroidResCapability;
import com.autonomousapps.model.AndroidResSource;
import com.autonomousapps.model.AnnotationProcessorCapability;
import com.autonomousapps.model.Capability;
import com.autonomousapps.model.ClassCapability;
import com.autonomousapps.model.ConstantCapability;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.Dependency;
import com.autonomousapps.model.InferredCapability;
import com.autonomousapps.model.InlineMemberCapability;
import com.autonomousapps.model.KtFile;
import com.autonomousapps.model.NativeLibCapability;
import com.autonomousapps.model.ProjectVariant;
import com.autonomousapps.model.SecurityProviderCapability;
import com.autonomousapps.model.ServiceLoaderCapability;
import com.autonomousapps.model.declaration.Bucket;
import com.autonomousapps.model.intermediates.DependencyTraceReport;
import com.autonomousapps.model.intermediates.Reason;
import com.autonomousapps.tasks.AnnotationProcessorDetector;
import com.autonomousapps.tasks.GraphVisitor;
import com.autonomousapps.visitor.GraphViewVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/autonomousapps/tasks/GraphVisitor;", "Lcom/autonomousapps/visitor/GraphViewVisitor;", "project", "Lcom/autonomousapps/model/ProjectVariant;", "kapt", "", "(Lcom/autonomousapps/model/ProjectVariant;Z)V", "report", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "getReport", "()Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "reportBuilder", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport$Builder;", "isAbi", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "classCapability", "Lcom/autonomousapps/model/ClassCapability;", "context", "Lcom/autonomousapps/visitor/GraphViewVisitor$Context;", "isImplementation", "isImported", "isRuntimeAndroid", "capability", "Lcom/autonomousapps/model/AndroidManifestCapability;", "usesAnnotationProcessor", "Lcom/autonomousapps/model/AnnotationProcessorCapability;", "usesAssets", "Lcom/autonomousapps/model/AndroidAssetCapability;", "usesConstant", "Lcom/autonomousapps/model/ConstantCapability;", "usesInlineMember", "Lcom/autonomousapps/model/InlineMemberCapability;", "usesResByRes", "Lcom/autonomousapps/model/AndroidResCapability;", "usesResBySource", "visit", "", "dependency", "Lcom/autonomousapps/model/Dependency;", "dependency-analysis-gradle-plugin"})
final class GraphVisitor
implements GraphViewVisitor {
    private final DependencyTraceReport.Builder reportBuilder;
    private final boolean kapt;

    @NotNull
    public final DependencyTraceReport getReport() {
        return this.reportBuilder.build();
    }

    @Override
    public void visit(@NotNull Dependency dependency, @NotNull GraphViewVisitor.Context context) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Coordinates dependencyCoordinates = dependency.getCoordinates();
        boolean isAnnotationProcessor = false;
        boolean isAnnotationProcessorCandidate = false;
        boolean isApiCandidate = false;
        boolean isImplCandidate = false;
        boolean isImplByImportCandidate = false;
        boolean isUnusedCandidate = false;
        boolean isLintJar = false;
        boolean isCompileOnlyCandidate = false;
        boolean isRuntimeAndroid = false;
        boolean usesResBySource2 = false;
        boolean usesResByRes = false;
        boolean usesAssets = false;
        boolean usesConstant2 = false;
        boolean usesInlineMember2 = false;
        boolean hasServiceLoader = false;
        boolean hasSecurityProvider = false;
        boolean hasNativeLib = false;
        Iterable $this$forEach$iv = dependency.getCapabilities().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection collection;
            Set<String> providers;
            Unit unit;
            Capability capability = (Capability)element$iv;
            boolean bl = false;
            Capability capability2 = capability;
            if (capability2 instanceof AndroidLinterCapability) {
                isLintJar = ((AndroidLinterCapability)capability).isLintJar();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.LintJar.Companion.of(((AndroidLinterCapability)capability).getLintRegistry()));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidManifestCapability) {
                isRuntimeAndroid = this.isRuntimeAndroid(dependencyCoordinates, (AndroidManifestCapability)capability);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidAssetCapability) {
                usesAssets = this.usesAssets(dependencyCoordinates, (AndroidAssetCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidResCapability) {
                usesResBySource2 = this.usesResBySource(dependencyCoordinates, (AndroidResCapability)capability, context);
                usesResByRes = this.usesResByRes(dependencyCoordinates, (AndroidResCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AnnotationProcessorCapability) {
                isAnnotationProcessor = true;
                isAnnotationProcessorCandidate = this.usesAnnotationProcessor(dependencyCoordinates, (AnnotationProcessorCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ClassCapability) {
                if (this.isAbi(dependencyCoordinates, (ClassCapability)capability, context)) {
                    isApiCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImplementation(dependencyCoordinates, (ClassCapability)capability, context)) {
                    isImplCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImported(dependencyCoordinates, (ClassCapability)capability, context)) {
                    isImplByImportCandidate = true;
                    unit = Unit.INSTANCE;
                } else {
                    isUnusedCandidate = true;
                    unit = Unit.INSTANCE;
                }
            } else if (capability2 instanceof ConstantCapability) {
                usesConstant2 = this.usesConstant(dependencyCoordinates, (ConstantCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InferredCapability) {
                if (((InferredCapability)capability).isCompileOnlyAnnotations()) {
                    this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.CompileTimeAnnotations());
                }
                isCompileOnlyCandidate = ((InferredCapability)capability).isCompileOnlyAnnotations();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InlineMemberCapability) {
                usesInlineMember2 = this.usesInlineMember(dependencyCoordinates, (InlineMemberCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ServiceLoaderCapability) {
                providers = ((ServiceLoaderCapability)capability).getProviderClasses();
                collection = providers;
                hasServiceLoader = !collection.isEmpty();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ServiceLoader(providers));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof NativeLibCapability) {
                Set<String> fileNames = ((NativeLibCapability)capability).getFileNames();
                collection = fileNames;
                hasNativeLib = !collection.isEmpty();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.NativeLib(fileNames));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof SecurityProviderCapability) {
                providers = ((SecurityProviderCapability)capability).getSecurityProviders();
                collection = providers;
                hasSecurityProvider = !collection.isEmpty();
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.SecurityProvider(providers));
                unit = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit2 = unit;
        }
        if (dependency.getCapabilities().isEmpty()) {
            isUnusedCandidate = true;
        }
        if (isAnnotationProcessorCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.ANNOTATION_PROCESSOR);
        } else if (isAnnotationProcessor) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.NONE);
        }
        if (isApiCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.API);
        } else if (isCompileOnlyCandidate) {
            isUnusedCandidate = false;
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.COMPILE_ONLY);
        } else if (isImplCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        } else if (isImplByImportCandidate) {
            this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        }
        if (isUnusedCandidate) {
            if (usesResBySource2) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesResByRes) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesConstant2) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesInlineMember2) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (isLintJar) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (isRuntimeAndroid) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (usesAssets) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasServiceLoader) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasSecurityProvider) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasNativeLib) {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else {
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Bucket.NONE);
                this.reportBuilder.set(dependencyCoordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.Unused.INSTANCE);
            }
        }
    }

    private final boolean isRuntimeAndroid(Coordinates coordinates, AndroidManifestCapability capability) {
        Set<String> set2;
        Set<String> set3;
        Set<String> set4;
        Set<String> set5;
        Set<String> it;
        Map<AndroidManifestCapability.Component, Set<String>> components = capability.getComponentMap();
        Set<String> set6 = components.get((Object)AndroidManifestCapability.Component.ACTIVITY);
        if (set6 != null) {
            Set<String> set7;
            it = set7 = set6;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.activities(it));
            set5 = set7;
        } else {
            set5 = null;
        }
        Set<String> activities = set5;
        Set<String> set8 = components.get((Object)AndroidManifestCapability.Component.PROVIDER);
        if (set8 != null) {
            Set<String> it2 = it = set8;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.providers(it2));
            set4 = it;
        } else {
            set4 = null;
        }
        Set<String> providers = set4;
        Set<String> set9 = components.get((Object)AndroidManifestCapability.Component.RECEIVER);
        if (set9 != null) {
            Set<String> it2;
            Set<String> it3 = it2 = set9;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.receivers(it3));
            set3 = it2;
        } else {
            set3 = null;
        }
        Set<String> receivers = set3;
        Set<String> set10 = components.get((Object)AndroidManifestCapability.Component.SERVICE);
        if (set10 != null) {
            Set<String> set11;
            Set<String> it4 = set11 = set10;
            boolean bl = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.services(it4));
            set2 = set11;
        } else {
            set2 = null;
        }
        Set<String> services = set2;
        return activities != null || providers != null || receivers != null || services != null;
    }

    private final boolean isAbi(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet exposedClasses2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getExposedClasses()), (Function1)((Function1)new Function1<String, Boolean>(classCapability){
            final /* synthetic */ ClassCapability $classCapability;

            public final boolean invoke(@NotNull String exposedClass) {
                Intrinsics.checkNotNullParameter((Object)exposedClass, (String)"exposedClass");
                return this.$classCapability.getClasses().contains(exposedClass);
            }
            {
                this.$classCapability = classCapability;
                super(1);
            }
        })));
        Collection collection = exposedClasses2;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Abi(exposedClasses2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImplementation(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet implClasses2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImplementationClasses()), (Function1)((Function1)new Function1<String, Boolean>(classCapability){
            final /* synthetic */ ClassCapability $classCapability;

            public final boolean invoke(@NotNull String implClass) {
                Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
                return this.$classCapability.getClasses().contains(implClass);
            }
            {
                this.$classCapability = classCapability;
                super(1);
            }
        })));
        Collection collection = implClasses2;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Impl(implClasses2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImported(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImports()), (Function1)((Function1)new Function1<String, Boolean>(classCapability){
            final /* synthetic */ ClassCapability $classCapability;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$classCapability.getClasses().contains(string);
            }
            {
                this.$classCapability = classCapability;
                super(1);
            }
        })));
        Collection collection = imports2;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Imported(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesConstant(Coordinates coordinates, ConstantCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        usesConstant.1 $fun$optionalStarImport$1 = usesConstant.1.INSTANCE;
        Set<KtFile> ktFiles = capability.getKtFiles();
        Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence(capability.getConstants()), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Set<? extends String>>, List<? extends String>>(ktFiles){
            final /* synthetic */ Set $ktFiles;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<String> invoke(@NotNull Map.Entry<String, ? extends Set<String>> $dstr$fqcn$names) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                String string;
                Object object;
                Object v0;
                void fqcn;
                Object object22;
                Object object3;
                Set<String> names;
                block7: {
                    Intrinsics.checkNotNullParameter($dstr$fqcn$names, (String)"<name for destructuring parameter 0>");
                    Map.Entry<String, ? extends Set<String>> entry = $dstr$fqcn$names;
                    String string2 = entry.getKey();
                    entry = $dstr$fqcn$names;
                    names = entry.getValue();
                    object3 = this.$ktFiles;
                    Iterable iterable = object3;
                    for (Object object22 : iterable) {
                        KtFile it = (KtFile)object22;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getFqcn(), (Object)fqcn)) continue;
                        v0 = object22;
                        break block7;
                    }
                    v0 = null;
                }
                if ((object = (KtFile)v0) != null && (object = ((KtFile)object).getName()) != null) {
                    Object name = object3 = object;
                    boolean bl = false;
                    string = StringsKt.removeSuffix((String)fqcn, (CharSequence)((CharSequence)name));
                } else {
                    string = null;
                }
                String ktPrefix = string;
                Iterable $this$mapNotNull$iv = names;
                boolean $i$f$mapNotNull = false;
                object22 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object4 = $this$forEach$iv$iv$iv.iterator();
                while (object4.hasNext()) {
                    String string3;
                    String string4;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = object4.next();
                    boolean bl = false;
                    String name = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (ktPrefix != null) {
                        String string5;
                        String it = string5;
                        boolean bl3 = false;
                        string4 = it + name;
                    } else {
                        string4 = null;
                    }
                    if (string4 == null) continue;
                    String it$iv$iv = string3 = string4;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List ktImports = (List)destination$iv$iv;
                $this$mapNotNull$iv = names;
                Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ktImports, (Iterable)CollectionsKt.listOf((Object)((String)fqcn + ".*"))), (Iterable)usesConstant.1.INSTANCE.invoke((String)fqcn));
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void name;
                    object4 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string6 = (String)fqcn + '.' + (String)name;
                    collection.add(string6);
                }
                collection = (List)destination$iv$iv;
                return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            }
            {
                this.$ktFiles = set2;
                super(1);
            }
        })), (Function1)usesConstant.candidateImports.2.INSTANCE));
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImports()), (Function1)((Function1)new Function1<String, Boolean>(candidateImports2){
            final /* synthetic */ Set $candidateImports;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$candidateImports.contains(string);
            }
            {
                this.$candidateImports = set2;
                super(1);
            }
        })));
        Collection collection = imports2;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Constant(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean usesAssets(Coordinates coordinates, AndroidAssetCapability capability, GraphViewVisitor.Context context) {
        void $this$andIfTrue$iv;
        Collection collection = capability.getAssets();
        boolean bl = !collection.isEmpty() && context.getProject().getUsedClassesBySrc().contains("android.content.res.AssetManager");
        boolean $i$f$andIfTrue = false;
        if ($this$andIfTrue$iv != false) {
            boolean bl2 = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Asset(capability.getAssets()));
        }
        return (boolean)$this$andIfTrue$iv;
    }

    private final boolean usesResBySource(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set<String> projectImports = context.getProject().getImports();
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])new String[]{capability.getRImport(), StringsKt.removeSuffix((String)capability.getRImport(), (CharSequence)"R") + "*"})), (Function1)((Function1)new Function1<String, Boolean>(projectImports){
            final /* synthetic */ Set $projectImports;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$projectImports.contains(string);
            }
            {
                this.$projectImports = set2;
                super(1);
            }
        })));
        Collection collection = imports2;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ResBySrc(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean usesResByRes(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        Set styleParentRefs = new LinkedHashSet();
        Set attrRefs = new LinkedHashSet();
        for (AndroidResCapability.Line line : capability.getLines()) {
            String string = line.component1();
            String id = line.component2();
            for (AndroidResSource candidate : context.getProject().getAndroidResSource()) {
                Object v2;
                Object it;
                Object object;
                block7: {
                    Object v0;
                    block6: {
                        object = candidate.getStyleParentRefs();
                        Iterable iterable = object;
                        for (Object t : iterable) {
                            AndroidResSource.StyleParentRef styleParentRef = (AndroidResSource.StyleParentRef)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)id, (Object)styleParentRef.getStyleParent())) continue;
                            v0 = t;
                            break block6;
                        }
                        v0 = null;
                    }
                    AndroidResSource.StyleParentRef styleParentRef = v0;
                    if (styleParentRef != null) {
                        it = object = styleParentRef;
                        boolean bl = false;
                        styleParentRefs.add(it);
                    }
                    it = object = (Iterable)candidate.getAttrRefs();
                    Iterator bl = it.iterator();
                    while (bl.hasNext()) {
                        void type;
                        Object t;
                        t = bl.next();
                        AndroidResSource.AttrRef attrRef = (AndroidResSource.AttrRef)t;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)type, (Object)attrRef.getType()) && Intrinsics.areEqual((Object)id, (Object)attrRef.getId()))) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                AndroidResSource.AttrRef attrRef = v2;
                if (attrRef == null) continue;
                it = object = attrRef;
                boolean bl = false;
                attrRefs.add(it);
            }
        }
        Object object = styleParentRefs;
        if (!object.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.ResByRes.Companion.styleParentRefs(styleParentRefs));
            return true;
        }
        boolean bl = false;
        boolean used = bl;
        if (used) return true;
        object = attrRefs;
        if (object.isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.ResByRes.Companion.attrRefs(attrRefs));
        return true;
    }

    private final boolean usesInlineMember(Coordinates coordinates, InlineMemberCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)capability.getInlineMembers()), (Function1)usesInlineMember.candidateImports.1.INSTANCE));
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImports()), (Function1)((Function1)new Function1<String, Boolean>(candidateImports2){
            final /* synthetic */ Set $candidateImports;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$candidateImports.contains(string);
            }
            {
                this.$candidateImports = set2;
                super(1);
            }
        })));
        Collection collection = imports2;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Inline(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesAnnotationProcessor(Coordinates coordinates, AnnotationProcessorCapability capability, GraphViewVisitor.Context context) {
        return new AnnotationProcessorDetector(coordinates, capability.getSupportedAnnotationTypes(), this.kapt, this.reportBuilder).usesAnnotationProcessor(context);
    }

    public GraphVisitor(@NotNull ProjectVariant project, boolean kapt) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.kapt = kapt;
        this.reportBuilder = new DependencyTraceReport.Builder(project.getBuildType(), project.getFlavor(), project.getVariant());
    }
}

