/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.Manifest;
import com.autonomousapps.internal.utils.XmlKt;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0014\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/ManifestParser;", "", "namespace", "", "(Ljava/lang/String;)V", "application", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "packageName", "manifest", "Ljava/io/File;", "parse", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "allComponents", "", "componentNames", "", "component", "Lcom/autonomousapps/internal/Manifest$Component;", "withPackageName", "ManifestParseException", "ParseResult", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nManifestParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestParser.kt\ncom/autonomousapps/internal/ManifestParser\n+ 2 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n*L\n1#1,119:1\n142#2,5:120\n*S KotlinDebug\n*F\n+ 1 ManifestParser.kt\ncom/autonomousapps/internal/ManifestParser\n*L\n98#1:120,5\n*E\n"})
public final class ManifestParser {
    @NotNull
    private final String namespace;

    public ManifestParser(@NotNull String namespace2) {
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        this.namespace = namespace2;
    }

    @NotNull
    public final ParseResult parse(@NotNull File manifest, boolean allComponents) throws ManifestParseException {
        Set<String> set2;
        Set<String> activities;
        Set<String> set3;
        Set<String> providers;
        Set<String> set4;
        Set<String> services;
        Set<String> set5;
        String theme;
        String string;
        Node node;
        NamedNodeMap namedNodeMap;
        String string2;
        String applicationName;
        Element application;
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Document document = XmlKt.buildDocument(manifest);
        String packageName = this.packageName(manifest, document);
        Element element = application = this.application(document);
        String string3 = element != null ? element.getAttribute("android:name") : null;
        if (string3 == null) {
            string3 = applicationName = "";
        }
        if ((string2 = application != null && (namedNodeMap = application.getAttributes()) != null && (node = namedNodeMap.getNamedItem("android:theme")) != null && (string = node.getNodeValue()) != null ? StringsKt.substringAfter$default((String)string, (String)"@style/", null, (int)2, null) : null) == null) {
            string2 = theme = "";
        }
        if ((set5 = application) == null || (set5 = this.componentNames((Element)((Object)set5), Manifest.Component.SERVICE, packageName)) == null) {
            set5 = services = SetsKt.emptySet();
        }
        if ((set4 = application) == null || (set4 = this.componentNames((Element)((Object)set4), Manifest.Component.PROVIDER, packageName)) == null) {
            set4 = providers = SetsKt.emptySet();
        }
        if ((set3 = application) == null || (set3 = this.componentNames((Element)((Object)set3), Manifest.Component.ACTIVITY, packageName)) == null) {
            set3 = activities = SetsKt.emptySet();
        }
        if ((set2 = application) == null || (set2 = this.componentNames((Element)((Object)set2), Manifest.Component.RECEIVER, packageName)) == null) {
            set2 = SetsKt.emptySet();
        }
        Set<String> receivers = set2;
        Map componentsMapping = new LinkedHashMap();
        if (!((Collection)services).isEmpty()) {
            componentsMapping.put(Manifest.Component.SERVICE.getMapKey(), services);
        }
        if (!((Collection)providers).isEmpty()) {
            componentsMapping.put(Manifest.Component.PROVIDER.getMapKey(), providers);
        }
        if (allComponents) {
            if (!((Collection)activities).isEmpty()) {
                componentsMapping.put(Manifest.Component.ACTIVITY.getMapKey(), activities);
            }
            if (!((Collection)receivers).isEmpty()) {
                componentsMapping.put(Manifest.Component.RECEIVER.getMapKey(), receivers);
            }
        }
        return new ParseResult(packageName, applicationName, theme, componentsMapping);
    }

    public static /* synthetic */ ParseResult parse$default(ManifestParser manifestParser, File file, boolean bl, int n, Object object) throws ManifestParseException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return manifestParser.parse(file, bl);
    }

    private final Element application(Document document) {
        Element element;
        NodeList elements = document.getElementsByTagName("application");
        if (elements.getLength() > 0) {
            Node node = elements.item(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element = (Element)node;
        } else {
            element = null;
        }
        return element;
    }

    private final String packageName(File manifest, Document document) {
        CharSequence charSequence;
        CharSequence charSequence2 = this.namespace;
        if (charSequence2.length() == 0) {
            Object $this$packageName_u24lambda_u242_u24lambda_u240;
            boolean bl = false;
            Object object = this;
            try {
                $this$packageName_u24lambda_u242_u24lambda_u240 = object;
                boolean bl2 = false;
                $this$packageName_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)document.getElementsByTagName("manifest").item(0).getAttributes().getNamedItem("package").getNodeValue());
            }
            catch (Throwable bl2) {
                $this$packageName_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$packageName_u24lambda_u242_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable t = throwable;
                boolean bl3 = false;
                throw t instanceof NullPointerException ? (Throwable)new ManifestParseException(manifest.getPath() + " has no 'package' attribute. You should use 'android.namespace' to set the package name and remove the 'package' attribute from the main manifest, since that attribute is set for removal with AGP 8.0.", t) : t;
            }
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runCatching {\n        do\u2026      t\n        }\n      }");
            charSequence = (String)object2;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> componentNames(Element $this$componentNames, Manifest.Component component, String packageName) {
        void $this$mapToSet$iv;
        NodeList nodeList = $this$componentNames.getElementsByTagName(component.getTagName());
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(component.tagName)");
        NodeList nodeList2 = nodeList;
        boolean $i$f$mapToSet = false;
        HashSet<String> destination$iv = new HashSet<String>($this$mapToSet$iv.getLength());
        int n = $this$mapToSet$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            void it;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapToSet$iv.item(i$iv), (String)"item(i)");
            HashSet<String> hashSet = destination$iv;
            boolean bl = false;
            String string = it.getAttributes().getNamedItem(component.getAttrName()).getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.attributes.getNamedIt\u2026onent.attrName).nodeValue");
            hashSet.add(this.withPackageName(string, packageName));
        }
        return destination$iv;
    }

    private final String withPackageName(String $this$withPackageName, String packageName) {
        return StringsKt.startsWith$default((String)$this$withPackageName, (String)".", (boolean)false, (int)2, null) ? packageName + $this$withPackageName : $this$withPackageName;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/internal/ManifestParser$ManifestParseException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "msg", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "dependency-analysis-gradle-plugin"})
    public static final class ManifestParseException
    extends RuntimeException {
        public ManifestParseException(@NotNull String msg2, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(msg2, cause);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "", "packageName", "", "applicationName", "theme", "components", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplicationName", "()Ljava/lang/String;", "getComponents", "()Ljava/util/Map;", "getPackageName", "getTheme", "dependency-analysis-gradle-plugin"})
    public static final class ParseResult {
        @NotNull
        private final String packageName;
        @NotNull
        private final String applicationName;
        @NotNull
        private final String theme;
        @NotNull
        private final Map<String, Set<String>> components;

        public ParseResult(@NotNull String packageName, @NotNull String applicationName, @NotNull String theme, @NotNull Map<String, ? extends Set<String>> components) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter(components, (String)"components");
            this.packageName = packageName;
            this.applicationName = applicationName;
            this.theme = theme;
            this.components = components;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final String getApplicationName() {
            return this.applicationName;
        }

        @NotNull
        public final String getTheme() {
            return this.theme;
        }

        @NotNull
        public final Map<String, Set<String>> getComponents() {
            return this.components;
        }
    }
}

