/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.graph;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/internal/graph/GraphViewBuilder;", "", "conf", "Lorg/gradle/api/artifacts/Configuration;", "(Lorg/gradle/api/artifacts/Configuration;)V", "graph", "Lcom/google/common/graph/Graph;", "Lcom/autonomousapps/model/Coordinates;", "getGraph", "()Lcom/google/common/graph/Graph;", "graphBuilder", "Lcom/google/common/graph/ImmutableGraph$Builder;", "visited", "", "walk", "", "root", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "rootId", "walkFileDeps", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGraphViewBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphViewBuilder.kt\ncom/autonomousapps/internal/graph/GraphViewBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n800#2,11:78\n1611#2:90\n1855#2:91\n1856#2:93\n1612#2:94\n1855#2,2:95\n800#2,11:97\n819#2:108\n847#2,2:109\n819#2:111\n847#2,2:112\n819#2:114\n847#2,2:115\n1855#2,2:117\n118#3:89\n1#4:92\n*S KotlinDebug\n*F\n+ 1 GraphViewBuilder.kt\ncom/autonomousapps/internal/graph/GraphViewBuilder\n*L\n44#1:78,11\n45#1:90\n45#1:91\n45#1:93\n45#1:94\n46#1:95,2\n53#1:97,11\n56#1:108\n56#1:109,2\n58#1:111\n58#1:112,2\n60#1:114\n60#1:115,2\n61#1:117,2\n45#1:89\n45#1:92\n*E\n"})
public final class GraphViewBuilder {
    @NotNull
    private final Graph<Coordinates> graph;
    @NotNull
    private final ImmutableGraph.Builder<Coordinates> graphBuilder;
    @NotNull
    private final Set<Coordinates> visited;

    public GraphViewBuilder(@NotNull Configuration conf2) {
        Intrinsics.checkNotNullParameter((Object)conf2, (String)"conf");
        this.graphBuilder = DependencyGraphView.Companion.newGraphBuilder$dependency_analysis_gradle_plugin();
        this.visited = new LinkedHashSet();
        ResolvedComponentResult resolvedComponentResult = conf2.getIncoming().getResolutionResult().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"conf\n      .incoming\n   \u2026olutionResult\n      .root");
        ResolvedComponentResult root = resolvedComponentResult;
        Coordinates rootId = GradleStringsKt.rootCoordinates(conf2);
        this.walkFileDeps(conf2, rootId);
        this.walk(root, rootId);
        ImmutableGraph immutableGraph = this.graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"graphBuilder.build()");
        this.graph = (Graph)immutableGraph;
    }

    @NotNull
    public final Graph<Coordinates> getGraph() {
        return this.graph;
    }

    /*
     * WARNING - void declaration
     */
    private final void walkFileDeps(Configuration conf2, Coordinates rootId) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        this.graphBuilder.addNode((Object)rootId);
        DependencySet dependencySet = conf2.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"conf.allDependencies");
        Iterable $this$filterIsInstance$iv = (Iterable)dependencySet;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FileCollectionDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNullToSet$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNullToSet = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Coordinates it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FileCollectionDependency it = (FileCollectionDependency)element$iv$iv;
            boolean bl2 = false;
            if (GradleStringsKt.toCoordinates((Dependency)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (Set)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates id = (Coordinates)element$iv;
            boolean bl = false;
            this.graphBuilder.putEdge((Object)rootId, (Object)id);
        }
    }

    private final void walk(ResolvedComponentResult root, Coordinates rootId) {
        ResolvedDependencyResult it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Set set2 = root.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"root.dependencies");
        Iterable $this$filterIsInstance$iv = set2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependencyResult)element$iv$iv;
            boolean bl = false;
            if (it.isConstraint()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependencyResult)element$iv$iv;
            boolean bl = false;
            if (ArtifactViewsKt.isJavaPlatform(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependencyResult)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)GradleStringsKt.toCoordinates(it), (Object)rootId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependencyResult dependencyResult = (ResolvedDependencyResult)element$iv;
            boolean bl = false;
            Coordinates depId = GradleStringsKt.toCoordinates(dependencyResult);
            this.graphBuilder.putEdge((Object)rootId, (Object)depId);
            if (this.visited.contains(depId)) continue;
            this.visited.add(depId);
            ResolvedComponentResult resolvedComponentResult = dependencyResult.getSelected();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"dependencyResult.selected");
            this.walk(resolvedComponentResult, depId);
        }
    }
}

