/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.utils;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0005\u001f !\"#B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nB9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016R\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber;", "", "major", "", "minor", "micro", "qualifier", "", "(IIILjava/lang/String;)V", "patch", "(IIIILjava/lang/String;)V", "scheme", "Lcom/autonomousapps/internal/utils/VersionNumber$AbstractScheme;", "(IIIILjava/lang/String;Lcom/autonomousapps/internal/utils/VersionNumber$AbstractScheme;)V", "baseVersion", "getBaseVersion", "()Lcom/autonomousapps/internal/utils/VersionNumber;", "getMajor", "()I", "getMicro", "getMinor", "getPatch", "getQualifier", "()Ljava/lang/String;", "compareTo", "other", "equals", "", "", "hashCode", "toString", "AbstractScheme", "Companion", "DefaultScheme", "Scheme", "SchemeWithPatchVersion", "dependency-analysis-gradle-plugin"})
public final class VersionNumber
implements Comparable<VersionNumber> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int micro;
    private final int patch;
    @Nullable
    private final String qualifier;
    @NotNull
    private final AbstractScheme scheme;
    @NotNull
    private static final VersionNumber UNKNOWN = Companion.version(0);
    @NotNull
    private static final DefaultScheme DEFAULT_SCHEME = new DefaultScheme();
    @NotNull
    private static final SchemeWithPatchVersion PATCH_SCHEME = new SchemeWithPatchVersion();

    private VersionNumber(int major, int minor, int micro, int patch, String qualifier, AbstractScheme scheme) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.patch = patch;
        this.qualifier = qualifier;
        this.scheme = scheme;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getQualifier() {
        return this.qualifier;
    }

    public VersionNumber(int major, int minor, int micro, @Nullable String qualifier) {
        this(major, minor, micro, 0, qualifier, DEFAULT_SCHEME);
    }

    public VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier) {
        this(major, minor, micro, patch, qualifier, PATCH_SCHEME);
    }

    @NotNull
    public final VersionNumber getBaseVersion() {
        return new VersionNumber(this.major, this.minor, this.micro, this.patch, null, this.scheme);
    }

    @Override
    public int compareTo(@NotNull VersionNumber other) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.minor) {
            return this.micro - other.micro;
        }
        if (this.patch != other.patch) {
            return this.patch - other.patch;
        }
        Comparator comparator2 = ComparisonsKt.nullsLast((Comparator)ComparisonsKt.naturalOrder());
        String string3 = this.qualifier;
        if (string3 != null) {
            String string4 = string3.toLowerCase();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
        } else {
            string2 = null;
        }
        String string5 = other.qualifier;
        if (string5 != null) {
            String string6 = string5.toLowerCase();
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return comparator2.compare(string2, string);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.patch;
        Object[] objectArray = new Object[]{this.qualifier};
        result = 31 * result + Objects.hashCode((Object[])objectArray);
        return result;
    }

    @NotNull
    public String toString() {
        return this.scheme.format(this);
    }

    public /* synthetic */ VersionNumber(int major, int minor, int micro, int patch, String qualifier, AbstractScheme scheme, DefaultConstructorMarker $constructor_marker) {
        this(major, minor, micro, patch, qualifier, scheme);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$AbstractScheme;", "Lcom/autonomousapps/internal/utils/VersionNumber$Scheme;", "depth", "", "(I)V", "getDepth", "()I", "parse", "Lcom/autonomousapps/internal/utils/VersionNumber;", "versionString", "", "Scanner", "dependency-analysis-gradle-plugin"})
    private static abstract class AbstractScheme
    implements Scheme {
        private final int depth;

        protected AbstractScheme(int depth) {
            this.depth = depth;
        }

        public final int getDepth() {
            return this.depth;
        }

        @Override
        @NotNull
        public VersionNumber parse(@Nullable String versionString) {
            if (versionString == null || ((CharSequence)versionString).length() == 0) {
                return Companion.getUNKNOWN();
            }
            Scanner scanner = new Scanner(versionString);
            int major = 0;
            int minor = 0;
            int micro = 0;
            int patch = 0;
            if (!scanner.hasDigit()) {
                return Companion.getUNKNOWN();
            }
            major = scanner.scanDigit();
            char[] cArray = new char[]{'.'};
            if (scanner.isSeparatorAndDigit(cArray)) {
                scanner.skipSeparator();
                minor = scanner.scanDigit();
                cArray = new char[]{'.'};
                if (scanner.isSeparatorAndDigit(cArray)) {
                    scanner.skipSeparator();
                    micro = scanner.scanDigit();
                    if (this.depth > 3 && scanner.isSeparatorAndDigit(cArray = new char[]{'.', '_'})) {
                        scanner.skipSeparator();
                        patch = scanner.scanDigit();
                    }
                }
            }
            if (scanner.isEnd()) {
                return new VersionNumber(major, minor, micro, patch, null, this, null);
            }
            if (scanner.isQualifier()) {
                scanner.skipSeparator();
                return new VersionNumber(major, minor, micro, patch, scanner.remainder(), this, null);
            }
            return Companion.getUNKNOWN();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u00020\u000e2\n\u0010\u0012\u001a\u00020\u0013\"\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\u000e2\n\u0010\u0012\u001a\u00020\u0013\"\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$AbstractScheme$Scanner;", "", "str", "", "(Ljava/lang/String;)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "getStr", "()Ljava/lang/String;", "hasDigit", "", "isEnd", "isQualifier", "isSeparatorAndDigit", "separators", "", "", "oneOf", "remainder", "scanDigit", "skipSeparator", "", "dependency-analysis-gradle-plugin"})
        private static final class Scanner {
            @NotNull
            private final String str;
            private int pos;

            public Scanner(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                this.str = str;
            }

            @NotNull
            public final String getStr() {
                return this.str;
            }

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            public final boolean hasDigit() {
                return this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos));
            }

            public final boolean isSeparatorAndDigit(char ... separators) {
                Intrinsics.checkNotNullParameter((Object)separators, (String)"separators");
                return this.pos < this.str.length() - 1 && this.oneOf(Arrays.copyOf(separators, separators.length)) && Character.isDigit(this.str.charAt(this.pos + 1));
            }

            private final boolean oneOf(char ... separators) {
                char current = this.str.charAt(this.pos);
                for (char separator : separators) {
                    if (current != separator) continue;
                    return true;
                }
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isQualifier() {
                if (this.pos >= this.str.length() - 1) return false;
                char[] cArray = new char[]{'.', '-'};
                if (!this.oneOf(cArray)) return false;
                return true;
            }

            public final int scanDigit() {
                int start = this.pos;
                while (this.hasDigit()) {
                    int n = this.pos;
                    this.pos = n + 1;
                }
                String string = this.str.substring(start, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return Integer.parseInt(string);
            }

            public final boolean isEnd() {
                return this.pos == this.str.length();
            }

            public final void skipSeparator() {
                int n = this.pos;
                this.pos = n + 1;
            }

            @Nullable
            public final String remainder() {
                String string;
                if (this.pos == this.str.length()) {
                    string = null;
                } else {
                    String string2 = this.str.substring(this.pos);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                }
                return string;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$Companion;", "", "()V", "DEFAULT_SCHEME", "Lcom/autonomousapps/internal/utils/VersionNumber$DefaultScheme;", "PATCH_SCHEME", "Lcom/autonomousapps/internal/utils/VersionNumber$SchemeWithPatchVersion;", "UNKNOWN", "Lcom/autonomousapps/internal/utils/VersionNumber;", "getUNKNOWN", "()Lcom/autonomousapps/internal/utils/VersionNumber;", "parse", "versionString", "", "scheme", "Lcom/autonomousapps/internal/utils/VersionNumber$Scheme;", "toLowerCase", "string", "version", "major", "", "minor", "withPatchNumber", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionNumber getUNKNOWN() {
            return UNKNOWN;
        }

        @NotNull
        public final VersionNumber version(int major) {
            return this.version(major, 0);
        }

        @NotNull
        public final VersionNumber version(int major, int minor) {
            return new VersionNumber(major, minor, 0, 0, null, DEFAULT_SCHEME, null);
        }

        @NotNull
        public final VersionNumber parse(@Nullable String versionString) {
            return DEFAULT_SCHEME.parse(versionString);
        }

        private final String toLowerCase(String string) {
            String string2;
            String string3 = string;
            if (string3 != null) {
                String string4 = string3.toLowerCase();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
            } else {
                string2 = null;
            }
            return string2;
        }

        @NotNull
        public final Scheme scheme() {
            return DEFAULT_SCHEME;
        }

        @NotNull
        public final Scheme withPatchNumber() {
            return PATCH_SCHEME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$DefaultScheme;", "Lcom/autonomousapps/internal/utils/VersionNumber$AbstractScheme;", "()V", "format", "", "versionNumber", "Lcom/autonomousapps/internal/utils/VersionNumber;", "Companion", "dependency-analysis-gradle-plugin"})
    private static final class DefaultScheme
    extends AbstractScheme {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String VERSION_TEMPLATE = "%d.%d.%d%s";

        public DefaultScheme() {
            super(3);
        }

        @Override
        @NotNull
        public String format(@NotNull VersionNumber versionNumber) {
            Intrinsics.checkNotNullParameter((Object)versionNumber, (String)"versionNumber");
            String string = VERSION_TEMPLATE;
            Object[] objectArray = new Object[]{versionNumber.getMajor(), versionNumber.getMinor(), versionNumber.getMicro(), versionNumber.getQualifier() == null ? "" : "-" + versionNumber.getQualifier()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$DefaultScheme$Companion;", "", "()V", "VERSION_TEMPLATE", "", "dependency-analysis-gradle-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$Scheme;", "", "format", "", "versionNumber", "Lcom/autonomousapps/internal/utils/VersionNumber;", "parse", "versionString", "dependency-analysis-gradle-plugin"})
    public static interface Scheme {
        @NotNull
        public VersionNumber parse(@Nullable String var1);

        @NotNull
        public String format(@NotNull VersionNumber var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$SchemeWithPatchVersion;", "Lcom/autonomousapps/internal/utils/VersionNumber$AbstractScheme;", "()V", "format", "", "versionNumber", "Lcom/autonomousapps/internal/utils/VersionNumber;", "Companion", "dependency-analysis-gradle-plugin"})
    private static final class SchemeWithPatchVersion
    extends AbstractScheme {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String VERSION_TEMPLATE = "%d.%d.%d.%d%s";

        public SchemeWithPatchVersion() {
            super(4);
        }

        @Override
        @NotNull
        public String format(@NotNull VersionNumber versionNumber) {
            Intrinsics.checkNotNullParameter((Object)versionNumber, (String)"versionNumber");
            String string = VERSION_TEMPLATE;
            Object[] objectArray = new Object[]{versionNumber.getMajor(), versionNumber.getMinor(), versionNumber.getMicro(), versionNumber.getPatch(), versionNumber.getQualifier() == null ? "" : "-" + versionNumber.getQualifier()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/autonomousapps/internal/utils/VersionNumber$SchemeWithPatchVersion$Companion;", "", "()V", "VERSION_TEMPLATE", "", "dependency-analysis-gradle-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

