/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.android;

import com.android.Version;
import com.autonomousapps.internal.utils.VersionNumber;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/internal/android/AgpVersion;", "", "version", "", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "versionNumber", "Lcom/autonomousapps/internal/utils/VersionNumber;", "compareTo", "", "other", "equals", "", "", "hashCode", "isSupported", "toString", "Companion", "dependency-analysis-gradle-plugin"})
public final class AgpVersion
implements Comparable<AgpVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String version;
    @NotNull
    private final VersionNumber versionNumber;
    @NotNull
    private static final AgpVersion AGP_MIN = Companion.version("4.2.2");
    @NotNull
    private static final AgpVersion AGP_MAX = Companion.version("8.1.0");

    private AgpVersion(String version) {
        this.version = version;
        this.versionNumber = VersionNumber.Companion.parse(this.version);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final boolean isSupported() {
        AgpVersion agpVersion = AGP_MIN;
        AgpVersion agpVersion2 = AGP_MAX;
        AgpVersion agpVersion3 = Companion.current();
        return 0 <= agpVersion3.compareTo((Object)agpVersion) ? agpVersion3.compareTo((Object)agpVersion2) <= 0 : false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compareTo(@NotNull AgpVersion other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = this.versionNumber.getQualifier();
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            String string2 = other.versionNumber.getQualifier();
            boolean bl2 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
            if (bl2) {
                n = this.versionNumber.compareTo(other.versionNumber);
                return n;
            }
        }
        n = this.versionNumber.getBaseVersion().compareTo(other.versionNumber.getBaseVersion());
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.autonomousapps.internal.android.AgpVersion");
        AgpVersion cfr_ignored_0 = (AgpVersion)other;
        return Intrinsics.areEqual((Object)this.versionNumber, (Object)((AgpVersion)other).versionNumber);
    }

    public int hashCode() {
        return this.versionNumber.hashCode();
    }

    @NotNull
    public String toString() {
        return "AgpVersion(versionNumber=" + this.versionNumber + ")";
    }

    @NotNull
    public static final AgpVersion getAGP_MIN() {
        return Companion.getAGP_MIN();
    }

    @NotNull
    public static final AgpVersion getAGP_MAX() {
        return Companion.getAGP_MAX();
    }

    @JvmStatic
    @NotNull
    public static final AgpVersion current() {
        return Companion.current();
    }

    @JvmStatic
    @NotNull
    public static final AgpVersion version(@NotNull String version) {
        return Companion.version(version);
    }

    public /* synthetic */ AgpVersion(String version, DefaultConstructorMarker $constructor_marker) {
        this(version);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\fH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/internal/android/AgpVersion$Companion;", "", "()V", "AGP_MAX", "Lcom/autonomousapps/internal/android/AgpVersion;", "getAGP_MAX$annotations", "getAGP_MAX", "()Lcom/autonomousapps/internal/android/AgpVersion;", "AGP_MIN", "getAGP_MIN$annotations", "getAGP_MIN", "agpVersion", "", "current", "version", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgpVersion getAGP_MIN() {
            return AGP_MIN;
        }

        @JvmStatic
        public static /* synthetic */ void getAGP_MIN$annotations() {
        }

        @NotNull
        public final AgpVersion getAGP_MAX() {
            return AGP_MAX;
        }

        @JvmStatic
        public static /* synthetic */ void getAGP_MAX$annotations() {
        }

        @JvmStatic
        @NotNull
        public final AgpVersion current() {
            return new AgpVersion(this.agpVersion(), null);
        }

        @JvmStatic
        @NotNull
        public final AgpVersion version(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new AgpVersion(version, null);
        }

        private final String agpVersion() {
            String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

