/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model;

import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.Coordinates;
import com.squareup.moshi.JsonClass;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0081\b\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\fH\u00d6\u0001J\u0006\u0010\u0016\u001a\u00020\u0011J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/model/PhysicalArtifact;", "", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "file", "Ljava/io/File;", "(Lcom/autonomousapps/model/Coordinates;Ljava/io/File;)V", "getCoordinates", "()Lcom/autonomousapps/model/Coordinates;", "getFile", "()Ljava/io/File;", "compareTo", "", "other", "component1", "component2", "containsClassFiles", "", "copy", "equals", "", "hashCode", "isJar", "toString", "", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nPhysicalArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicalArtifact.kt\ncom/autonomousapps/model/PhysicalArtifact\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,35:1\n1229#2,2:36\n*S KotlinDebug\n*F\n+ 1 PhysicalArtifact.kt\ncom/autonomousapps/model/PhysicalArtifact\n*L\n17#1:36,2\n*E\n"})
public final class PhysicalArtifact
implements Comparable<PhysicalArtifact> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinates coordinates;
    @NotNull
    private final File file;

    public PhysicalArtifact(@NotNull Coordinates coordinates, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.coordinates = coordinates;
        this.file = file;
    }

    @NotNull
    public final Coordinates getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean isJar() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
    }

    public final boolean containsClassFiles() {
        boolean bl;
        block1: {
            Sequence $this$any$iv = (Sequence)FilesKt.walkBottomUp((File)this.file);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File f = (File)element$iv;
                boolean bl2 = false;
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull PhysicalArtifact other) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int it = this.coordinates.compareTo(other.coordinates);
        boolean bl = false;
        return it == 0 ? this.file.compareTo(other.file) : var2_2;
    }

    @NotNull
    public final Coordinates component1() {
        return this.coordinates;
    }

    @NotNull
    public final File component2() {
        return this.file;
    }

    @NotNull
    public final PhysicalArtifact copy(@NotNull Coordinates coordinates, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new PhysicalArtifact(coordinates, file);
    }

    public static /* synthetic */ PhysicalArtifact copy$default(PhysicalArtifact physicalArtifact, Coordinates coordinates, File file, int n, Object object) {
        if ((n & 1) != 0) {
            coordinates = physicalArtifact.coordinates;
        }
        if ((n & 2) != 0) {
            file = physicalArtifact.file;
        }
        return physicalArtifact.copy(coordinates, file);
    }

    @NotNull
    public String toString() {
        return "PhysicalArtifact(coordinates=" + this.coordinates + ", file=" + this.file + ")";
    }

    public int hashCode() {
        int result = this.coordinates.hashCode();
        result = result * 31 + this.file.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysicalArtifact)) {
            return false;
        }
        PhysicalArtifact physicalArtifact = (PhysicalArtifact)other;
        if (!Intrinsics.areEqual((Object)this.coordinates, (Object)physicalArtifact.coordinates)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)physicalArtifact.file);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/autonomousapps/model/PhysicalArtifact$Companion;", "", "()V", "of", "Lcom/autonomousapps/model/PhysicalArtifact;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "file", "Ljava/io/File;", "of$dependency_analysis_gradle_plugin", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PhysicalArtifact of$dependency_analysis_gradle_plugin(@NotNull ResolvedArtifactResult artifact, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new PhysicalArtifact(GradleStringsKt.toCoordinates(artifact), file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

