/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.reason;

import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.utils.Colors;
import com.autonomousapps.internal.utils.TextKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.declaration.SourceSetKind;
import com.autonomousapps.model.declaration.Variant;
import com.autonomousapps.model.intermediates.BundleTrace;
import com.autonomousapps.model.intermediates.Reason;
import com.autonomousapps.model.intermediates.Usage;
import com.autonomousapps.tasks.ReasonTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020!*\u00060\"j\u0002`#2\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020!*\u00060\"j\u0002`#H\u0002J\f\u0010&\u001a\u00020\u000e*\u00020\u0003H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/autonomousapps/internal/reason/DependencyAdviceExplainer;", "Lcom/autonomousapps/tasks/ReasonTask$Explainer;", "project", "Lcom/autonomousapps/model/ProjectCoordinates;", "requestedId", "Lcom/autonomousapps/model/Coordinates;", "target", "usages", "", "Lcom/autonomousapps/model/intermediates/Usage;", "advice", "Lcom/autonomousapps/model/Advice;", "dependencyGraph", "", "", "Lcom/autonomousapps/model/DependencyGraphView;", "bundleTraces", "Lcom/autonomousapps/model/intermediates/BundleTrace;", "wasFiltered", "", "dependencyMap", "Lkotlin/Function1;", "(Lcom/autonomousapps/model/ProjectCoordinates;Lcom/autonomousapps/model/Coordinates;Lcom/autonomousapps/model/Coordinates;Ljava/util/Set;Lcom/autonomousapps/model/Advice;Ljava/util/Map;Ljava/util/Set;ZLkotlin/jvm/functions/Function1;)V", "bundle", "adviceText", "computeReason", "findTrace", "printableIdentifier", "coordinates", "sourceText", "variant", "Lcom/autonomousapps/model/declaration/Variant;", "printGraph", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "graphView", "printUsages", "printableName", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDependencyAdviceExplainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyAdviceExplainer.kt\ncom/autonomousapps/internal/reason/DependencyAdviceExplainer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n215#2,2:185\n1#3:187\n288#4,2:188\n1864#4,3:190\n1855#4:193\n766#4:194\n857#4,2:195\n1747#4,3:197\n1855#4,2:200\n1856#4:202\n*S KotlinDebug\n*F\n+ 1 DependencyAdviceExplainer.kt\ncom/autonomousapps/internal/reason/DependencyAdviceExplainer\n*L\n44#1:185,2\n107#1:188,2\n125#1:190,3\n139#1:193\n150#1:194\n150#1:195,2\n151#1:197,3\n152#1:200,2\n139#1:202\n*E\n"})
public final class DependencyAdviceExplainer
implements ReasonTask.Explainer {
    @NotNull
    private final ProjectCoordinates project;
    @NotNull
    private final Coordinates requestedId;
    @NotNull
    private final Coordinates target;
    @NotNull
    private final Set<Usage> usages;
    @Nullable
    private final Advice advice;
    @NotNull
    private final Map<String, DependencyGraphView> dependencyGraph;
    @NotNull
    private final Set<BundleTrace> bundleTraces;
    private final boolean wasFiltered;
    @Nullable
    private final Function1<String, String> dependencyMap;
    @NotNull
    private final String bundle;

    public DependencyAdviceExplainer(@NotNull ProjectCoordinates project, @NotNull Coordinates requestedId, @NotNull Coordinates target, @NotNull Set<Usage> usages2, @Nullable Advice advice, @NotNull Map<String, DependencyGraphView> dependencyGraph, @NotNull Set<? extends BundleTrace> bundleTraces, boolean wasFiltered, @Nullable Function1<? super String, String> dependencyMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        Intrinsics.checkNotNullParameter(dependencyGraph, (String)"dependencyGraph");
        Intrinsics.checkNotNullParameter(bundleTraces, (String)"bundleTraces");
        this.project = project;
        this.requestedId = requestedId;
        this.target = target;
        this.usages = usages2;
        this.advice = advice;
        this.dependencyGraph = dependencyGraph;
        this.bundleTraces = bundleTraces;
        this.wasFiltered = wasFiltered;
        this.dependencyMap = dependencyMap;
        this.bundle = Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin("bundle", "\u001b[1m");
    }

    public /* synthetic */ DependencyAdviceExplainer(ProjectCoordinates projectCoordinates, Coordinates coordinates, Coordinates coordinates2, Set set2, Advice advice, Map map, Set set3, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            function1 = null;
        }
        this(projectCoordinates, coordinates, coordinates2, set2, advice, map, set3, bl, (Function1<? super String, String>)function1);
    }

    @Override
    @NotNull
    public String computeReason() {
        StringBuilder stringBuilder;
        StringBuilder $this$computeReason_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        TextKt.appendReproducibleNewLine$default($this$computeReason_u24lambda_u241, null, 1, null);
        $this$computeReason_u24lambda_u241.append("\u001b[1m");
        TextKt.appendReproducibleNewLine($this$computeReason_u24lambda_u241, StringsKt.repeat((CharSequence)"-", (int)40));
        $this$computeReason_u24lambda_u241.append("You asked about the dependency '" + this.printableIdentifier(this.requestedId) + "'.");
        TextKt.appendReproducibleNewLine($this$computeReason_u24lambda_u241, "\u001b[0m");
        TextKt.appendReproducibleNewLine($this$computeReason_u24lambda_u241, this.adviceText());
        $this$computeReason_u24lambda_u241.append("\u001b[1m");
        $this$computeReason_u24lambda_u241.append(StringsKt.repeat((CharSequence)"-", (int)40));
        TextKt.appendReproducibleNewLine($this$computeReason_u24lambda_u241, "\u001b[0m");
        Map<String, DependencyGraphView> $this$forEach$iv = this.dependencyGraph;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DependencyGraphView>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DependencyGraphView> element$iv;
            Map.Entry<String, DependencyGraphView> it = element$iv = iterator.next();
            boolean bl2 = false;
            this.printGraph($this$computeReason_u24lambda_u241, it.getValue());
        }
        this.printUsages($this$computeReason_u24lambda_u241);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String adviceText() {
        Object object;
        if (this.advice == null) {
            if (!((Collection)this.bundleTraces).isEmpty()) {
                BundleTrace bundleTrace = this.findTrace();
                if (bundleTrace == null) {
                    throw new IllegalStateException(("There must be a match. Available traces: " + this.bundleTraces).toString());
                }
                BundleTrace trace = bundleTrace;
                if (trace instanceof BundleTrace.DeclaredParent) {
                    object = "There is no advice regarding this dependency. It was removed because it matched a " + this.bundle + " rule for " + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(this.printableIdentifier(((BundleTrace.DeclaredParent)trace).getParent()), "\u001b[1m") + ", which is already declared.";
                    return object;
                } else {
                    if (!(trace instanceof BundleTrace.UsedChild)) throw new IllegalStateException(("Trace was " + trace + ", which makes no sense in this context").toString());
                    object = "There is no advice regarding this dependency. It was removed because it matched a " + this.bundle + " rule for " + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(this.printableIdentifier(((BundleTrace.UsedChild)trace).getChild()), "\u001b[1m") + ", which is declared and used.";
                }
                return object;
            } else {
                if (!this.wasFiltered) return "There is no advice regarding this dependency.";
                String exclude = Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin("exclude", "\u001b[1m");
                object = "There is no advice regarding this dependency. It was removed because it matched an " + exclude + " rule.";
            }
            return object;
        } else if (this.advice.isAdd()) {
            BundleTrace trace = this.findTrace();
            if (trace != null) {
                if (!(trace instanceof BundleTrace.PrimaryMap)) {
                    boolean bl = false;
                    String string = "Expected a " + BundleTrace.PrimaryMap.class.getSimpleName();
                    throw new IllegalStateException(string.toString());
                }
                String string = this.advice.getToConfiguration();
                Intrinsics.checkNotNull((Object)string);
                object = "You have been advised to add this dependency to '" + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(string, "\u001b[32m") + "'. It matched a " + this.bundle + " rule: " + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(this.printableIdentifier(((BundleTrace.PrimaryMap)trace).getPrimary()), "\u001b[1m") + " was substituted for " + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(this.printableIdentifier(((BundleTrace.PrimaryMap)trace).getSubordinate()), "\u001b[1m") + ".";
                return object;
            } else {
                String string = this.advice.getToConfiguration();
                Intrinsics.checkNotNull((Object)string);
                object = "You have been advised to add this dependency to '" + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(string, "\u001b[32m") + "'.";
            }
            return object;
        } else if (this.advice.isRemove() || this.advice.isProcessor()) {
            String string = this.advice.getFromConfiguration();
            Intrinsics.checkNotNull((Object)string);
            object = "You have been advised to remove this dependency from '" + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(string, "\u001b[31m") + "'.";
            return object;
        } else {
            if (!this.advice.isChange() && !this.advice.isRuntimeOnly()) {
                if (!this.advice.isCompileOnly()) throw new IllegalStateException(("Unknown advice type: " + this.advice).toString());
            }
            String string = this.advice.getToConfiguration();
            Intrinsics.checkNotNull((Object)string);
            String string2 = Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(string, "\u001b[32m");
            String string3 = this.advice.getFromConfiguration();
            Intrinsics.checkNotNull((Object)string3);
            object = "You have been advised to change this dependency to '" + string2 + "' from '" + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(string3, "\u001b[33m") + "'.";
        }
        return object;
    }

    private final BundleTrace findTrace() {
        Object v0;
        block1: {
            Iterable iterable = this.bundleTraces;
            for (Object t : iterable) {
                BundleTrace it = (BundleTrace)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTop(), (Object)this.target) || Intrinsics.areEqual((Object)it.getBottom(), (Object)this.target))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final void printGraph(StringBuilder $this$printGraph, DependencyGraphView graphView) {
        Object v1;
        String name;
        block4: {
            name = graphView.getConfigurationName();
            Set set2 = graphView.getGraph$dependency_analysis_gradle_plugin().nodes();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"graphView.graph.nodes()");
            Iterable $this$firstOrNull$iv = set2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Coordinates it = (Coordinates)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifier(), (Object)this.target.getIdentifier())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Coordinates targetInGraph = v1;
        if (targetInGraph == null) {
            TextKt.appendReproducibleNewLine$default($this$printGraph, null, 1, null);
            $this$printGraph.append("\u001b[1m");
            TextKt.appendReproducibleNewLine($this$printGraph, "There is no path from " + this.printableName(this.project) + " to " + this.printableIdentifier(this.target) + " for " + name);
            TextKt.appendReproducibleNewLine($this$printGraph, "\u001b[0m");
            return;
        }
        Iterable nodes2 = Graphs.INSTANCE.shortestPath(graphView.getGraph$dependency_analysis_gradle_plugin(), (Object)this.project, (Object)targetInGraph);
        TextKt.appendReproducibleNewLine$default($this$printGraph, null, 1, null);
        $this$printGraph.append("\u001b[1m");
        $this$printGraph.append("Shortest path from " + this.printableName(this.project) + " to " + this.printableIdentifier(this.target) + " for " + name + ":");
        TextKt.appendReproducibleNewLine($this$printGraph, "\u001b[0m");
        TextKt.appendReproducibleNewLine($this$printGraph, this.project.gav());
        Iterable $this$forEachIndexed$iv = CollectionsKt.drop((Iterable)nodes2, (int)1);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void node;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Coordinates coordinates = (Coordinates)item$iv;
            int i2 = n;
            boolean bl = false;
            $this$printGraph.append(StringsKt.repeat((CharSequence)"      ", (int)i2));
            $this$printGraph.append("\\--- ");
            TextKt.appendReproducibleNewLine($this$printGraph, node.gav());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printUsages(StringBuilder $this$printUsages) {
        if (this.usages.isEmpty()) {
            TextKt.appendReproducibleNewLine$default($this$printUsages, null, 1, null);
            TextKt.appendReproducibleNewLine($this$printUsages, "No compile-time usages detected for this runtime-only dependency.");
            return;
        }
        Iterable $this$forEach$iv = this.usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List reasons;
            Variant variant;
            block11: {
                void $this$filterTo$iv$iv;
                Usage usage = (Usage)element$iv;
                boolean bl2 = false;
                variant = usage.getVariant();
                TextKt.appendReproducibleNewLine$default($this$printUsages, null, 1, null);
                String txt = this.sourceText(variant);
                boolean bl3 = false;
                $this$printUsages.append("\u001b[1m");
                TextKt.appendReproducibleNewLine($this$printUsages, txt);
                $this$printUsages.append(StringsKt.repeat((CharSequence)"-", (int)txt.length()));
                TextKt.appendReproducibleNewLine($this$printUsages, "\u001b[0m");
                Iterable $this$filter$iv = usage.getReasons();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Reason it = (Reason)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!(it instanceof Reason.Unused) && !(it instanceof Reason.Undeclared))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                reasons = (List)destination$iv$iv;
                Iterable $this$any$iv = reasons;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Reason it = (Reason)element$iv2;
                        boolean bl5 = false;
                        if (!(it instanceof Reason.CompileTimeAnnotations)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean isCompileOnly = bl;
            Iterable $this$forEach$iv2 = reasons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                String string;
                Reason reason = (Reason)element$iv3;
                boolean bl6 = false;
                $this$printUsages.append("* ");
                switch (WhenMappings.$EnumSwitchMapping$0[variant.getKind().ordinal()]) {
                    case 1: {
                        string = "";
                        break;
                    }
                    case 2: {
                        string = variant.getVariant();
                        break;
                    }
                    default: {
                        string = "test";
                    }
                }
                String prefix = string;
                TextKt.appendReproducibleNewLine($this$printUsages, reason.reason(prefix, isCompileOnly));
            }
            if (!reasons.isEmpty()) continue;
            TextKt.appendReproducibleNewLine($this$printUsages, "(no usages)");
        }
    }

    private final String printableIdentifier(Coordinates coordinates) {
        Object mapped;
        CharSequence charSequence;
        String gav2 = coordinates.gav();
        Object object = this.dependencyMap;
        if (object == null || (object = (String)object.invoke((Object)gav2)) == null) {
            Function1<String, String> function1 = this.dependencyMap;
            object = function1 != null ? (String)function1.invoke((Object)coordinates.getIdentifier()) : null;
        }
        return !((charSequence = (CharSequence)(mapped = object)) == null || StringsKt.isBlank((CharSequence)charSequence)) ? gav2 + " (" + mapped + ")" : gav2;
    }

    private final String printableName(ProjectCoordinates $this$printableName) {
        String gav2 = $this$printableName.gav();
        return Intrinsics.areEqual((Object)gav2, (Object)":") ? "root project" : gav2;
    }

    private final String sourceText(Variant variant) {
        Object[] objectArray = new String[]{"main", "test"};
        return CollectionsKt.listOf((Object[])objectArray).contains(variant.getVariant()) || variant.getKind() == SourceSetKind.CUSTOM_JVM ? "Source: " + variant.getVariant() : "Source: " + variant.getVariant() + ", " + UtilsKt.lowercase(variant.getKind().name());
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceSetKind.values().length];
            try {
                nArray[SourceSetKind.MAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceSetKind.CUSTOM_JVM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

