/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.graph;

import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u001e\u0010\u0013\u001a\u00020\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/internal/graph/CCGraphViewBuilder;", "", "root", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "fileCoordinates", "", "Lcom/autonomousapps/model/Coordinates;", "(Lorg/gradle/api/artifacts/result/ResolvedComponentResult;Ljava/util/Set;)V", "graph", "Lcom/google/common/graph/Graph;", "getGraph", "()Lcom/google/common/graph/Graph;", "graphBuilder", "Lcom/google/common/graph/ImmutableGraph$Builder;", "visited", "", "walk", "", "rootId", "walkFileDeps", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCCGraphViewBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CCGraphViewBuilder.kt\ncom/autonomousapps/internal/graph/CCGraphViewBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1855#2,2:75\n800#2,11:77\n819#2:88\n847#2,2:89\n819#2:91\n847#2,2:92\n819#2:94\n847#2,2:95\n1855#2,2:97\n*S KotlinDebug\n*F\n+ 1 CCGraphViewBuilder.kt\ncom/autonomousapps/internal/graph/CCGraphViewBuilder\n*L\n43#1:75,2\n50#1:77,11\n53#1:88\n53#1:89,2\n55#1:91\n55#1:92,2\n57#1:94\n57#1:95,2\n58#1:97,2\n*E\n"})
public final class CCGraphViewBuilder {
    @NotNull
    private final Graph<Coordinates> graph;
    @NotNull
    private final ImmutableGraph.Builder<Coordinates> graphBuilder;
    @NotNull
    private final Set<Coordinates> visited;

    public CCGraphViewBuilder(@NotNull ResolvedComponentResult root, @NotNull Set<? extends Coordinates> fileCoordinates) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(fileCoordinates, (String)"fileCoordinates");
        this.graphBuilder = DependencyGraphView.Companion.newGraphBuilder$dependency_analysis_gradle_plugin();
        this.visited = new LinkedHashSet();
        Coordinates rootId = GradleStringsKt.rootCoordinates(root);
        this.walkFileDeps(fileCoordinates, rootId);
        this.walk(root, rootId);
        ImmutableGraph immutableGraph = this.graphBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"graphBuilder.build()");
        this.graph = (Graph)immutableGraph;
    }

    @NotNull
    public final Graph<Coordinates> getGraph() {
        return this.graph;
    }

    private final void walkFileDeps(Set<? extends Coordinates> fileCoordinates, Coordinates rootId) {
        this.graphBuilder.addNode((Object)rootId);
        Iterable $this$forEach$iv = fileCoordinates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Coordinates id = (Coordinates)element$iv;
            boolean bl = false;
            this.graphBuilder.putEdge((Object)rootId, (Object)id);
        }
    }

    private final void walk(ResolvedComponentResult root, Coordinates rootId) {
        ResolvedDependencyResult it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Set set2 = root.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"root.dependencies");
        Iterable $this$filterIsInstance$iv = set2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependencyResult)element$iv$iv;
            boolean bl = false;
            if (it.isConstraint()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependencyResult)element$iv$iv;
            boolean bl = false;
            if (ArtifactViewsKt.isJavaPlatform(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependencyResult)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getSelected(), (Object)root)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependencyResult dependencyResult = (ResolvedDependencyResult)element$iv;
            boolean bl = false;
            Coordinates depId = GradleStringsKt.toCoordinates(dependencyResult);
            this.graphBuilder.putEdge((Object)rootId, (Object)depId);
            if (this.visited.contains(depId)) continue;
            this.visited.add(depId);
            ResolvedComponentResult resolvedComponentResult = dependencyResult.getSelected();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"dependencyResult.selected");
            this.walk(resolvedComponentResult, depId);
        }
    }
}

