/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.advice.ProjectHealthConsoleReportBuilder;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.BuildHealth;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/tasks/GenerateBuildHealthTask;", "Lorg/gradle/api/DefaultTask;", "()V", "consoleOutput", "Lorg/gradle/api/file/RegularFileProperty;", "getConsoleOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dslKind", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "()Lorg/gradle/api/provider/Property;", "output", "getOutput", "outputFail", "getOutputFail", "projectHealthReports", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getProjectHealthReports", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "action", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateBuildHealthTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateBuildHealthTask.kt\ncom/autonomousapps/tasks/GenerateBuildHealthTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1549#2:128\n1620#2,2:129\n1622#2:139\n1045#2:140\n2634#2:141\n1855#2,2:143\n800#2,11:145\n1855#2,2:156\n118#3,2:131\n40#4,2:133\n33#4,4:135\n186#4,3:158\n40#4,2:161\n33#4,4:163\n189#4,2:167\n1#5:142\n*S KotlinDebug\n*F\n+ 1 GenerateBuildHealthTask.kt\ncom/autonomousapps/tasks/GenerateBuildHealthTask\n*L\n66#1:128\n66#1:129,2\n66#1:139\n68#1:140\n69#1:141\n84#1:143,2\n94#1:145,11\n94#1:156,2\n66#1:131,2\n66#1:133,2\n66#1:135,4\n118#1:158,3\n118#1:161,2\n118#1:163,4\n118#1:167,2\n69#1:142\n*E\n"})
public abstract class GenerateBuildHealthTask
extends DefaultTask {
    public GenerateBuildHealthTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Generates json report for build health");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getProjectHealthReports();

    @Input
    @NotNull
    public abstract Property<DslKind> getDslKind();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getConsoleOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFail();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$onEach$iv;
        Iterable $this$sortedBy$iv;
        Object reader$iv2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        File output = UtilsKt.getAndDelete(this.getOutput());
        File consoleOutput = UtilsKt.getAndDelete(this.getConsoleOutput());
        File outputFail = UtilsKt.getAndDelete(this.getOutputFail());
        boolean didWrite = false;
        boolean shouldFail = false;
        int unusedDependencies = 0;
        int undeclaredDependencies = 0;
        int misDeclaredDependencies = 0;
        int compileOnlyDependencies = 0;
        int runtimeOnlyDependencies = 0;
        int processorDependencies = 0;
        BuildHealth.AndroidScoreMetrics.Builder androidMetricsBuilder = new BuildHealth.AndroidScoreMetrics.Builder();
        Set set2 = this.getProjectHealthReports().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"projectHealthReports.files");
        Iterable iterable = set2;
        boolean $i$f$map = false;
        void var16_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            void $this$fromJson$iv = it;
            boolean $i$f$fromJson = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead((File)$this$fromJson$iv);
            Throwable throwable = null;
            try {
                JsonAdapter $this$withNulls$iv$iv$iv;
                reader$iv2 = (BufferedSource)closeable;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(ProjectAdvice.class), (String)"MOSHI.adapter(T::class.java)");
                boolean $i$f$withNulls = false;
                Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv.fromJson((BufferedSource)reader$iv2));
            }
            catch (Throwable reader$iv2) {
                throwable = reader$iv2;
                throw reader$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            collection.add((ProjectAdvice)object);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectAdvice it = (ProjectAdvice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getProjectPath());
                it = (ProjectAdvice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getProjectPath())));
            }
        });
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = $this$mapTo$iv$iv = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            void $this$filterIsInstanceTo$iv$iv;
            ProjectAdvice projectAdvice = (ProjectAdvice)element$iv;
            boolean bl3 = false;
            if (!projectAdvice.isNotEmpty()) continue;
            shouldFail = shouldFail || projectAdvice.getShouldFail();
            Object object = this.getDslKind().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dslKind.get()");
            DslKind dslKind = (DslKind)((Object)object);
            Object object2 = this.getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"dependencyMap.get()");
            String report = new ProjectHealthConsoleReportBuilder(projectAdvice, dslKind, DependenciesHandler.Companion.toLambda((Map)object2)).getText();
            String projectPath = Intrinsics.areEqual((Object)projectAdvice.getProjectPath(), (Object)":") ? "root project" : projectAdvice.getProjectPath();
            FilesKt.appendText$default((File)consoleOutput, (String)("Advice for " + projectPath + "\n" + report + "\n\n"), null, (int)2, null);
            didWrite = true;
            Iterable $this$forEach$iv = projectAdvice.getDependencyAdvice();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Advice it = (Advice)element$iv2;
                boolean bl4 = false;
                if (it.isRemove()) {
                    ++unusedDependencies;
                    continue;
                }
                if (it.isAdd()) {
                    ++undeclaredDependencies;
                    continue;
                }
                if (it.isChange()) {
                    ++misDeclaredDependencies;
                    continue;
                }
                if (it.isCompileOnly()) {
                    ++compileOnlyDependencies;
                    continue;
                }
                if (it.isRuntimeOnly()) {
                    ++runtimeOnlyDependencies;
                    continue;
                }
                if (!it.isProcessor()) continue;
                ++processorDependencies;
            }
            Iterable $this$filterIsInstance$iv = projectAdvice.getModuleAdvice();
            boolean $i$f$filterIsInstance = false;
            reader$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AndroidScore)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                int n;
                AndroidScore it = (AndroidScore)element$iv2;
                boolean bl5 = false;
                if (it.shouldBeJvm()) {
                    n = androidMetricsBuilder.getShouldBeJvmCount();
                    androidMetricsBuilder.setShouldBeJvmCount(n + 1);
                    continue;
                }
                if (!it.couldBeJvm()) continue;
                n = androidMetricsBuilder.getCouldBeJvmCount();
                androidMetricsBuilder.setCouldBeJvmCount(n + 1);
            }
        }
        Set projectAdvice = CollectionsKt.toSortedSet((Iterable)$this$mapTo$iv$iv);
        BuildHealth buildHealth = new BuildHealth(projectAdvice, shouldFail, projectAdvice.size(), unusedDependencies, undeclaredDependencies, misDeclaredDependencies, compileOnlyDependencies, runtimeOnlyDependencies, processorDependencies, androidMetricsBuilder.build());
        File $this$bufferWriteJson_u24default$iv = output;
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        Object object = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl6 = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(BuildHealth.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)buildHealth);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)closeable, object);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        FilesKt.writeText$default((File)outputFail, (String)String.valueOf(shouldFail), null, (int)2, null);
        if (!didWrite) {
            FilesKt.writeText$default((File)consoleOutput, (String)"", null, (int)2, null);
        }
    }
}

