/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.AndroidAssetSource;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/AssetSourceExploderTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/ProjectLayout;)V", "androidLocalAssets", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAndroidLocalAssets", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "Action", "Parameters", "dependency-analysis-gradle-plugin"})
public abstract class AssetSourceExploderTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final ProjectLayout layout;

    @Inject
    public AssetSourceExploderTask(@NotNull WorkerExecutor workerExecutor, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.workerExecutor = workerExecutor;
        this.layout = layout;
        this.setDescription("Produces a report of all assets in this project");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getAndroidLocalAssets();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(Action.class, new org.gradle.api.Action(this){
            final /* synthetic */ AssetSourceExploderTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Parameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                $this$submit.getProjectDir().set((Object)AssetSourceExploderTask.access$getLayout$p(this.this$0).getProjectDirectory());
                $this$submit.getAndroidLocalAssets().setFrom((Iterable)this.this$0.getAndroidLocalAssets());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
        });
    }

    public static final /* synthetic */ ProjectLayout access$getLayout$p(AssetSourceExploderTask $this) {
        return $this.layout;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/AssetSourceExploderTask$Action;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/AssetSourceExploderTask$Parameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nAssetSourceExploderTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetSourceExploderTask.kt\ncom/autonomousapps/tasks/AssetSourceExploderTask$Action\n+ 2 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,63:1\n102#2:64\n1620#3,3:65\n177#4,3:68\n49#4,3:71\n33#4,4:74\n180#4,2:78\n*S KotlinDebug\n*F\n+ 1 AssetSourceExploderTask.kt\ncom/autonomousapps/tasks/AssetSourceExploderTask$Action\n*L\n55#1:64\n55#1:65,3\n59#1:68,3\n59#1:71,3\n59#1:74,4\n59#1:78,2\n*E\n"})
    public static abstract class Action
    implements WorkAction<Parameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            void $this$mapTo$iv$iv;
            File output = UtilsKt.getAndDelete(((Parameters)this.getParameters()).getOutput());
            File file = ((Directory)((Parameters)this.getParameters()).getProjectDir().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.projectDir.get().asFile");
            File projectDir = file;
            Iterable $this$mapToSet$iv = (Iterable)((Parameters)this.getParameters()).getAndroidLocalAssets();
            boolean $i$f$mapToSet = false;
            Iterable iterable = $this$mapToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                File file3 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                collection.add(new AndroidAssetSource(FilesKt.toRelativeString((File)file2, (File)projectDir)));
            }
            Set assets = (Set)destination$iv$iv;
            File $this$bufferWriteJsonSet_u24default$iv = output;
            String indent$iv = "";
            boolean $i$f$bufferWriteJsonSet = false;
            Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable = null;
            try {
                JsonWriter writer$iv = (JsonWriter)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{AndroidAssetSource.class};
                ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)assets);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/AssetSourceExploderTask$Parameters;", "Lorg/gradle/workers/WorkParameters;", "androidLocalAssets", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAndroidLocalAssets", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "projectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDir", "()Lorg/gradle/api/file/DirectoryProperty;", "dependency-analysis-gradle-plugin"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public DirectoryProperty getProjectDir();

        @NotNull
        public ConfigurableFileCollection getAndroidLocalAssets();

        @NotNull
        public RegularFileProperty getOutput();
    }
}

