/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AnalyzedClass;
import com.autonomousapps.internal.ClassNameAndAnnotationsVisitor;
import com.autonomousapps.internal.JarExploder;
import com.autonomousapps.internal.asm.ClassReader;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.KtFile;
import com.autonomousapps.model.PhysicalArtifact;
import com.autonomousapps.model.intermediates.AndroidLinterDependency;
import com.autonomousapps.model.intermediates.ExplodedJar;
import com.autonomousapps.model.intermediates.ExplodingJar;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.ExplodeJarTask;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006*\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/JarExploder;", "", "artifacts", "", "Lcom/autonomousapps/model/PhysicalArtifact;", "androidLinters", "", "Lcom/autonomousapps/model/intermediates/AndroidLinterDependency;", "inMemoryCache", "Lcom/autonomousapps/services/InMemoryCache;", "(Ljava/util/List;Ljava/util/Set;Lcom/autonomousapps/services/InMemoryCache;)V", "logger", "Lorg/gradle/api/logging/Logger;", "explodeJar", "Lcom/autonomousapps/model/intermediates/ExplodingJar;", "artifact", "explodedJars", "Lcom/autonomousapps/model/intermediates/ExplodedJar;", "findAndroidLinter", "", "physicalArtifact", "toExplodedJars", "", "dependency-analysis-gradle-plugin"})
public final class JarExploder {
    private final Logger logger;
    private final List<PhysicalArtifact> artifacts;
    private final Set<AndroidLinterDependency> androidLinters;
    private final InMemoryCache inMemoryCache;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ExplodedJar> explodedJars() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.artifacts;
        JarExploder jarExploder = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PhysicalArtifact it = (PhysicalArtifact)element$iv$iv;
            boolean bl = false;
            String string = it.getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.file.name");
            if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return jarExploder.toExplodedJars(list);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ExplodedJar> toExplodedJars(Iterable<PhysicalArtifact> $this$toExplodedJars) {
        void $this$mapTo$iv$iv;
        Iterable<PhysicalArtifact> $this$mapToOrderedSet$iv = $this$toExplodedJars;
        boolean $i$f$mapToOrderedSet = false;
        Iterable<PhysicalArtifact> iterable = $this$mapToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void artifact;
            PhysicalArtifact physicalArtifact = (PhysicalArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ExplodingJar explodedJar = this.explodeJar((PhysicalArtifact)artifact);
            ExplodedJar explodedJar2 = new ExplodedJar((PhysicalArtifact)artifact, explodedJar);
            collection.add(explodedJar2);
        }
        return (Set)destination$iv$iv;
    }

    private final ExplodingJar explodeJar(PhysicalArtifact artifact) {
        ZipFile zip = new ZipFile(artifact.getFile());
        String string = artifact.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.file.absolutePath");
        ExplodingJar alreadyExplodingJar = this.inMemoryCache.explodedJar$dependency_analysis_gradle_plugin(string);
        if (alreadyExplodingJar != null) {
            return alreadyExplodingJar;
        }
        String string2 = zip.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"zip.name");
        this.inMemoryCache.updateJars$dependency_analysis_gradle_plugin(string2);
        Set ktFiles = kotlin.collections.CollectionsKt.toSet((Iterable)KtFile.Companion.fromZip(zip));
        SortedSet analyzedClasses2 = SequencesKt.toSortedSet((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.map(CollectionsKt.asSequenceOfClassFiles(zip), (Function1)((Function1)new Function1<ZipEntry, ClassNameAndAnnotationsVisitor>(this, zip){
            final /* synthetic */ JarExploder this$0;
            final /* synthetic */ ZipFile $zip;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ClassNameAndAnnotationsVisitor invoke(@NotNull ZipEntry classEntry) {
                ClassReader classReader;
                Intrinsics.checkNotNullParameter((Object)classEntry, (String)"classEntry");
                ClassNameAndAnnotationsVisitor classNameAndAnnotationsVisitor = new ClassNameAndAnnotationsVisitor(JarExploder.access$getLogger$p(this.this$0));
                boolean bl = false;
                boolean bl2 = false;
                ClassNameAndAnnotationsVisitor $this$apply = classNameAndAnnotationsVisitor;
                boolean bl3 = false;
                Closeable closeable = this.$zip.getInputStream(classEntry);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl6 = false;
                    InputStream inputStream = it;
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                    classReader = new ClassReader(ByteStreamsKt.readBytes((InputStream)inputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                ClassReader reader = classReader;
                reader.accept((ClassVisitor)$this$apply, 0);
                return classNameAndAnnotationsVisitor;
            }
            {
                this.this$0 = jarExploder;
                this.$zip = zipFile;
                super(1);
            }
        })), (Function1)explodeJar.analyzedClasses.2.INSTANCE), (Function1)explodeJar.analyzedClasses.3.INSTANCE), (Function1)((Function1)new Function1<AnalyzedClass, Unit>(this){
            final /* synthetic */ JarExploder this$0;

            public final void invoke(@NotNull AnalyzedClass it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JarExploder.access$getInMemoryCache$p(this.this$0).updateClasses$dependency_analysis_gradle_plugin(it.getClassName());
            }
            {
                this.this$0 = jarExploder;
                super(1);
            }
        })));
        ExplodingJar explodingJar = new ExplodingJar(analyzedClasses2, ktFiles, this.findAndroidLinter(artifact));
        boolean bl = false;
        boolean bl2 = false;
        ExplodingJar it = explodingJar;
        boolean bl3 = false;
        String string3 = artifact.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"artifact.file.absolutePath");
        this.inMemoryCache.explodedJars$dependency_analysis_gradle_plugin(string3, it);
        return explodingJar;
    }

    private final String findAndroidLinter(PhysicalArtifact physicalArtifact) {
        Object v0;
        block1: {
            Iterable iterable = this.androidLinters;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                AndroidLinterDependency it = (AndroidLinterDependency)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getCoordinates(), (Object)physicalArtifact.getCoordinates())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        AndroidLinterDependency androidLinterDependency = v0;
        return androidLinterDependency != null ? androidLinterDependency.getLintRegistry() : null;
    }

    public JarExploder(@NotNull List<PhysicalArtifact> artifacts, @NotNull Set<AndroidLinterDependency> androidLinters, @NotNull InMemoryCache inMemoryCache2) {
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter(androidLinters, (String)"androidLinters");
        Intrinsics.checkNotNullParameter((Object)inMemoryCache2, (String)"inMemoryCache");
        this.artifacts = artifacts;
        this.androidLinters = androidLinters;
        this.inMemoryCache = inMemoryCache2;
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(ExplodeJarTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logging.getLogger(T::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ Logger access$getLogger$p(JarExploder $this) {
        return $this.logger;
    }

    public static final /* synthetic */ InMemoryCache access$getInMemoryCache$p(JarExploder $this) {
        return $this.inMemoryCache;
    }
}

