/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.Manifest;
import com.autonomousapps.internal.utils.XmlKt;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0014\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/ManifestParser;", "", "namespace", "", "(Ljava/lang/String;)V", "application", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "packageName", "parse", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "manifest", "Ljava/io/File;", "allComponents", "", "componentNames", "", "component", "Lcom/autonomousapps/internal/Manifest$Component;", "withPackageName", "ParseResult", "dependency-analysis-gradle-plugin"})
public final class ManifestParser {
    private final String namespace;

    @NotNull
    public final ParseResult parse(@NotNull File manifest, boolean allComponents) {
        Set<String> set2;
        Set<String> activities;
        Set<String> set3;
        Set<String> providers;
        Set<String> set4;
        Set<String> services;
        Set<String> set5;
        Object applicationName;
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Document document = XmlKt.buildDocument(manifest);
        String packageName = this.packageName(document);
        Element application = this.application(document);
        Object object = application;
        if (object == null || (object = object.getAttribute("android:name")) == null) {
            object = applicationName = "";
        }
        if ((set5 = application) == null || (set5 = this.componentNames((Element)((Object)set5), Manifest.Component.SERVICE, packageName)) == null) {
            set5 = services = SetsKt.emptySet();
        }
        if ((set4 = application) == null || (set4 = this.componentNames((Element)((Object)set4), Manifest.Component.PROVIDER, packageName)) == null) {
            set4 = providers = SetsKt.emptySet();
        }
        if ((set3 = application) == null || (set3 = this.componentNames((Element)((Object)set3), Manifest.Component.ACTIVITY, packageName)) == null) {
            set3 = activities = SetsKt.emptySet();
        }
        if ((set2 = application) == null || (set2 = this.componentNames((Element)((Object)set2), Manifest.Component.RECEIVER, packageName)) == null) {
            set2 = SetsKt.emptySet();
        }
        Set<String> receivers = set2;
        boolean bl = false;
        Map componentsMapping = new LinkedHashMap();
        Collection collection = services;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            componentsMapping.put(Manifest.Component.SERVICE.getMapKey(), services);
        }
        collection = providers;
        bl2 = false;
        if (!collection.isEmpty()) {
            componentsMapping.put(Manifest.Component.PROVIDER.getMapKey(), providers);
        }
        if (allComponents) {
            collection = activities;
            bl2 = false;
            if (!collection.isEmpty()) {
                componentsMapping.put(Manifest.Component.ACTIVITY.getMapKey(), activities);
            }
            collection = receivers;
            bl2 = false;
            if (!collection.isEmpty()) {
                componentsMapping.put(Manifest.Component.RECEIVER.getMapKey(), receivers);
            }
        }
        return new ParseResult(packageName, (String)applicationName, componentsMapping);
    }

    public static /* synthetic */ ParseResult parse$default(ManifestParser manifestParser, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return manifestParser.parse(file, bl);
    }

    private final Element application(Document document) {
        Element element;
        NodeList elements;
        NodeList nodeList = elements = document.getElementsByTagName("application");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"elements");
        if (nodeList.getLength() > 0) {
            Node node = elements.item(0);
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            element = (Element)node;
        } else {
            element = null;
        }
        return element;
    }

    private final String packageName(Document document) {
        CharSequence charSequence;
        CharSequence charSequence2 = this.namespace;
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            Node node = document.getElementsByTagName("manifest").item(0);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"document.getElementsByTagName(\"manifest\").item(0)");
            Node node2 = node.getAttributes().getNamedItem("package");
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"document.getElementsByTa\u2026 .getNamedItem(\"package\")");
            String string = node2.getNodeValue();
            charSequence = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getElementsByTa\u2026kage\")\n        .nodeValue");
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> componentNames(Element $this$componentNames, Manifest.Component component, String packageName) {
        void $this$mapToSet$iv;
        NodeList nodeList = $this$componentNames.getElementsByTagName(component.getTagName());
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(component.tagName)");
        NodeList nodeList2 = nodeList;
        boolean $i$f$mapToSet = false;
        HashSet<String> destination$iv = new HashSet<String>($this$mapToSet$iv.getLength());
        int n = 0;
        int n2 = $this$mapToSet$iv.getLength();
        while (n < n2) {
            void it;
            void i$iv;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapToSet$iv.item((int)i$iv), (String)"item(i)");
            HashSet<String> hashSet = destination$iv;
            boolean bl = false;
            Node node = it.getAttributes().getNamedItem(component.getAttrName());
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"it.attributes.getNamedItem(component.attrName)");
            String string = node.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.attributes.getNamedIt\u2026onent.attrName).nodeValue");
            String string2 = this.withPackageName(string, packageName);
            hashSet.add(string2);
            ++i$iv;
        }
        return destination$iv;
    }

    private final String withPackageName(String $this$withPackageName, String packageName) {
        return StringsKt.startsWith$default((String)$this$withPackageName, (String)".", (boolean)false, (int)2, null) ? packageName + $this$withPackageName : $this$withPackageName;
    }

    public ManifestParser(@NotNull String namespace2) {
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        this.namespace = namespace2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "", "packageName", "", "applicationName", "components", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplicationName", "()Ljava/lang/String;", "getComponents", "()Ljava/util/Map;", "getPackageName", "dependency-analysis-gradle-plugin"})
    public static final class ParseResult {
        @NotNull
        private final String packageName;
        @NotNull
        private final String applicationName;
        @NotNull
        private final Map<String, Set<String>> components;

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final String getApplicationName() {
            return this.applicationName;
        }

        @NotNull
        public final Map<String, Set<String>> getComponents() {
            return this.components;
        }

        public ParseResult(@NotNull String packageName, @NotNull String applicationName, @NotNull Map<String, ? extends Set<String>> components) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
            Intrinsics.checkNotNullParameter(components, (String)"components");
            this.packageName = packageName;
            this.applicationName = applicationName;
            this.components = components;
        }
    }
}

