/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.model.AndroidAssetCapability;
import com.autonomousapps.model.AndroidLinterCapability;
import com.autonomousapps.model.AndroidManifestCapability;
import com.autonomousapps.model.AndroidResCapability;
import com.autonomousapps.model.AndroidResSource;
import com.autonomousapps.model.AnnotationProcessorCapability;
import com.autonomousapps.model.Capability;
import com.autonomousapps.model.ClassCapability;
import com.autonomousapps.model.ConstantCapability;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.Dependency;
import com.autonomousapps.model.InferredCapability;
import com.autonomousapps.model.InlineMemberCapability;
import com.autonomousapps.model.KtFile;
import com.autonomousapps.model.NativeLibCapability;
import com.autonomousapps.model.ProjectVariant;
import com.autonomousapps.model.SecurityProviderCapability;
import com.autonomousapps.model.ServiceLoaderCapability;
import com.autonomousapps.model.declaration.Bucket;
import com.autonomousapps.model.intermediates.DependencyTraceReport;
import com.autonomousapps.model.intermediates.Reason;
import com.autonomousapps.tasks.AnnotationProcessorDetector;
import com.autonomousapps.tasks.GraphVisitor;
import com.autonomousapps.visitor.GraphViewVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/autonomousapps/tasks/GraphVisitor;", "Lcom/autonomousapps/visitor/GraphViewVisitor;", "project", "Lcom/autonomousapps/model/ProjectVariant;", "kapt", "", "(Lcom/autonomousapps/model/ProjectVariant;Z)V", "report", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "getReport", "()Lcom/autonomousapps/model/intermediates/DependencyTraceReport;", "reportBuilder", "Lcom/autonomousapps/model/intermediates/DependencyTraceReport$Builder;", "isAbi", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "classCapability", "Lcom/autonomousapps/model/ClassCapability;", "context", "Lcom/autonomousapps/visitor/GraphViewVisitor$Context;", "isImplementation", "isImported", "isRuntimeAndroid", "capability", "Lcom/autonomousapps/model/AndroidManifestCapability;", "usesAnnotationProcessor", "Lcom/autonomousapps/model/AnnotationProcessorCapability;", "usesAssets", "Lcom/autonomousapps/model/AndroidAssetCapability;", "usesConstant", "Lcom/autonomousapps/model/ConstantCapability;", "usesInlineMember", "Lcom/autonomousapps/model/InlineMemberCapability;", "usesResByRes", "Lcom/autonomousapps/model/AndroidResCapability;", "usesResBySource", "visit", "", "dependency", "Lcom/autonomousapps/model/Dependency;", "dependency-analysis-gradle-plugin"})
final class GraphVisitor
implements GraphViewVisitor {
    private final DependencyTraceReport.Builder reportBuilder;
    private final boolean kapt;

    @NotNull
    public final DependencyTraceReport getReport() {
        return this.reportBuilder.build();
    }

    @Override
    public void visit(@NotNull Dependency dependency, @NotNull GraphViewVisitor.Context context) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Coordinates coord2 = dependency.getCoordinates();
        boolean isAnnotationProcessor = false;
        boolean isAnnotationProcessorCandidate = false;
        boolean isApiCandidate = false;
        boolean isImplCandidate = false;
        boolean isImplByImportCandidate = false;
        boolean isUnusedCandidate = false;
        boolean isLintJar = false;
        boolean isCompileOnlyCandidate = false;
        boolean isRuntimeAndroid = false;
        boolean usesResBySource2 = false;
        boolean usesResByRes = false;
        boolean usesAssets = false;
        boolean usesConstant2 = false;
        boolean usesInlineMember2 = false;
        boolean hasServiceLoader = false;
        boolean hasSecurityProvider = false;
        boolean hasNativeLib = false;
        Iterable $this$forEach$iv = dependency.getCapabilities().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Collection collection;
            Set<String> providers;
            Unit unit;
            Capability capability = (Capability)element$iv;
            boolean bl2 = false;
            Capability capability2 = capability;
            if (capability2 instanceof AndroidLinterCapability) {
                isLintJar = ((AndroidLinterCapability)capability).isLintJar();
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Reason.LintJar.Companion.of(((AndroidLinterCapability)capability).getLintRegistry()));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidManifestCapability) {
                isRuntimeAndroid = this.isRuntimeAndroid(coord2, (AndroidManifestCapability)capability);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidAssetCapability) {
                usesAssets = this.usesAssets(coord2, (AndroidAssetCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AndroidResCapability) {
                usesResBySource2 = this.usesResBySource(coord2, (AndroidResCapability)capability, context);
                usesResByRes = this.usesResByRes(coord2, (AndroidResCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof AnnotationProcessorCapability) {
                isAnnotationProcessor = true;
                isAnnotationProcessorCandidate = this.usesAnnotationProcessor(coord2, (AnnotationProcessorCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ClassCapability) {
                if (this.isAbi(coord2, (ClassCapability)capability, context)) {
                    isApiCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImplementation(coord2, (ClassCapability)capability, context)) {
                    isImplCandidate = true;
                    unit = Unit.INSTANCE;
                } else if (this.isImported(coord2, (ClassCapability)capability, context)) {
                    isImplByImportCandidate = true;
                    unit = Unit.INSTANCE;
                } else {
                    isUnusedCandidate = true;
                    unit = Unit.INSTANCE;
                }
            } else if (capability2 instanceof ConstantCapability) {
                usesConstant2 = this.usesConstant(coord2, (ConstantCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InferredCapability) {
                if (((InferredCapability)capability).isCompileOnlyAnnotations()) {
                    this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, new Reason.CompileTimeAnnotations());
                }
                isCompileOnlyCandidate = ((InferredCapability)capability).isCompileOnlyAnnotations();
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof InlineMemberCapability) {
                usesInlineMember2 = this.usesInlineMember(coord2, (InlineMemberCapability)capability, context);
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof ServiceLoaderCapability) {
                providers = ((ServiceLoaderCapability)capability).getProviderClasses();
                collection = providers;
                bl = false;
                hasServiceLoader = !collection.isEmpty();
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ServiceLoader(providers));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof NativeLibCapability) {
                Set<String> fileNames = ((NativeLibCapability)capability).getFileNames();
                collection = fileNames;
                bl = false;
                hasNativeLib = !collection.isEmpty();
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, new Reason.NativeLib(fileNames));
                unit = Unit.INSTANCE;
            } else if (capability2 instanceof SecurityProviderCapability) {
                providers = ((SecurityProviderCapability)capability).getSecurityProviders();
                collection = providers;
                bl = false;
                hasSecurityProvider = !collection.isEmpty();
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, new Reason.SecurityProvider(providers));
                unit = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit2 = unit;
        }
        if (dependency.getCapabilities().isEmpty()) {
            isUnusedCandidate = true;
        }
        if (isAnnotationProcessorCandidate) {
            this.reportBuilder.set(coord2, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.ANNOTATION_PROCESSOR);
        } else if (isAnnotationProcessor) {
            this.reportBuilder.set(coord2, DependencyTraceReport.Kind.ANNOTATION_PROCESSOR, Bucket.NONE);
        }
        if (isApiCandidate) {
            this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.API);
        } else if (isCompileOnlyCandidate) {
            isUnusedCandidate = false;
            this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.COMPILE_ONLY);
        } else if (isImplCandidate) {
            this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        } else if (isImplByImportCandidate) {
            this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
        }
        if (isUnusedCandidate) {
            if (usesResBySource2) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesResByRes) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesConstant2) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (usesInlineMember2) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.IMPL);
            } else if (isLintJar) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (isRuntimeAndroid) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (usesAssets) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasServiceLoader) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasSecurityProvider) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else if (hasNativeLib) {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.RUNTIME_ONLY);
            } else {
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Bucket.NONE);
                this.reportBuilder.set(coord2, DependencyTraceReport.Kind.DEPENDENCY, Reason.Unused.INSTANCE);
            }
        }
    }

    private final boolean isRuntimeAndroid(Coordinates coordinates, AndroidManifestCapability capability) {
        Set<String> set2;
        Set<String> set3;
        boolean bl;
        Map<AndroidManifestCapability.Component, Set<String>> components = capability.getComponentMap();
        Set<String> set4 = components.get((Object)AndroidManifestCapability.Component.SERVICE);
        if (set4 != null) {
            Set<String> set5 = set4;
            boolean bl2 = false;
            bl = false;
            Set<String> it = set5;
            boolean bl3 = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.services(it));
            set3 = set5;
        } else {
            set3 = null;
        }
        Set<String> services = set3;
        Set<String> set6 = components.get((Object)AndroidManifestCapability.Component.PROVIDER);
        if (set6 != null) {
            Set<String> set7 = set6;
            bl = false;
            boolean bl4 = false;
            Set<String> it = set7;
            boolean bl5 = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.RuntimeAndroid.Companion.providers(it));
            set2 = set7;
        } else {
            set2 = null;
        }
        Set<String> providers = set2;
        return services != null || providers != null;
    }

    private final boolean isAbi(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet exposedClasses2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getExposedClasses()), (Function1)((Function1)new Function1<String, Boolean>(classCapability){
            final /* synthetic */ ClassCapability $classCapability;

            public final boolean invoke(@NotNull String exposedClass) {
                Intrinsics.checkNotNullParameter((Object)exposedClass, (String)"exposedClass");
                return this.$classCapability.getClasses().contains(exposedClass);
            }
            {
                this.$classCapability = classCapability;
                super(1);
            }
        })));
        Collection collection = exposedClasses2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Abi(exposedClasses2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImplementation(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet implClasses2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImplementationClasses()), (Function1)((Function1)new Function1<String, Boolean>(classCapability){
            final /* synthetic */ ClassCapability $classCapability;

            public final boolean invoke(@NotNull String implClass) {
                Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
                return this.$classCapability.getClasses().contains(implClass);
            }
            {
                this.$classCapability = classCapability;
                super(1);
            }
        })));
        Collection collection = implClasses2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Impl(implClasses2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImported(Coordinates coordinates, ClassCapability classCapability, GraphViewVisitor.Context context) {
        boolean bl;
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImports()), (Function1)((Function1)new Function1<String, Boolean>(classCapability){
            final /* synthetic */ ClassCapability $classCapability;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$classCapability.getClasses().contains(string);
            }
            {
                this.$classCapability = classCapability;
                super(1);
            }
        })));
        Collection collection = imports2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Imported(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesConstant(Coordinates coordinates, ConstantCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        usesConstant.1 $fun$optionalStarImport$1 = usesConstant.1.INSTANCE;
        Set<KtFile> ktFiles = capability.getKtFiles();
        Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence(capability.getConstants()), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Set<? extends String>>, List<? extends String>>(ktFiles){
            final /* synthetic */ Set $ktFiles;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<String> invoke(@NotNull Map.Entry<String, ? extends Set<String>> $dstr$fqcn$names) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                String string;
                Object object;
                Object v0;
                void fqcn;
                boolean bl;
                Object object2;
                Set<String> names;
                block7: {
                    Intrinsics.checkNotNullParameter($dstr$fqcn$names, (String)"<name for destructuring parameter 0>");
                    Map.Entry<String, ? extends Set<String>> entry = $dstr$fqcn$names;
                    boolean bl2 = false;
                    String string2 = entry.getKey();
                    entry = $dstr$fqcn$names;
                    bl2 = false;
                    names = entry.getValue();
                    object2 = this.$ktFiles;
                    bl = false;
                    Iterable iterable = object2;
                    boolean bl3 = false;
                    for (T t : iterable) {
                        KtFile it = (KtFile)t;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqcn(), (Object)fqcn)) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                if ((object = (KtFile)v0) != null && (object = ((KtFile)object).getName()) != null) {
                    object2 = object;
                    bl = false;
                    boolean bl5 = false;
                    Object name = object2;
                    boolean bl6 = false;
                    string = StringsKt.removeSuffix((String)fqcn, (CharSequence)((CharSequence)name));
                } else {
                    string = null;
                }
                String ktPrefix = string;
                Iterable $this$mapNotNull$iv = names;
                boolean $i$f$mapNotNull = false;
                Iterable name = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object3 = $this$forEach$iv$iv$iv.iterator();
                while (object3.hasNext()) {
                    String string3;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = object3.next();
                    boolean bl7 = false;
                    String name2 = (String)element$iv$iv;
                    boolean bl8 = false;
                    if (ktPrefix != null) {
                        String string4;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        String it = string4;
                        boolean bl11 = false;
                        string3 = it + name2;
                    } else {
                        string3 = null;
                    }
                    if (string3 == null) continue;
                    String string5 = string3;
                    boolean bl12 = false;
                    boolean bl13 = false;
                    String it$iv$iv = string5;
                    boolean bl14 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List ktImports = (List)destination$iv$iv;
                $this$mapNotNull$iv = names;
                Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ktImports, (Iterable)CollectionsKt.listOf((Object)((String)fqcn + ".*"))), (Iterable)usesConstant.1.INSTANCE.invoke((String)fqcn));
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void name3;
                    object3 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl15 = false;
                    String string6 = (String)fqcn + '.' + (String)name3;
                    collection.add(string6);
                }
                collection = (List)destination$iv$iv;
                return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            }
            {
                this.$ktFiles = set2;
                super(1);
            }
        })), (Function1)usesConstant.candidateImports.2.INSTANCE));
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImports()), (Function1)((Function1)new Function1<String, Boolean>(candidateImports2){
            final /* synthetic */ Set $candidateImports;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$candidateImports.contains(string);
            }
            {
                this.$candidateImports = set2;
                super(1);
            }
        })));
        Collection collection = imports2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Constant(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean usesAssets(Coordinates coordinates, AndroidAssetCapability capability, GraphViewVisitor.Context context) {
        void $this$andIfTrue$iv;
        Collection collection = capability.getAssets();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty() && context.getProject().getUsedClassesBySrc().contains("android.content.res.AssetManager");
        boolean $i$f$andIfTrue = false;
        if ($this$andIfTrue$iv != false) {
            boolean bl3 = false;
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Asset(capability.getAssets()));
        }
        return (boolean)$this$andIfTrue$iv;
    }

    private final boolean usesResBySource(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set<String> projectImports = context.getProject().getImports();
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])new String[]{capability.getRImport(), StringsKt.removeSuffix((String)capability.getRImport(), (CharSequence)"R") + "*"})), (Function1)((Function1)new Function1<String, Boolean>(projectImports){
            final /* synthetic */ Set $projectImports;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$projectImports.contains(string);
            }
            {
                this.$projectImports = set2;
                super(1);
            }
        })));
        Collection collection = imports2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.ResBySrc(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean usesResByRes(Coordinates coordinates, AndroidResCapability capability, GraphViewVisitor.Context context) {
        boolean bl = false;
        Set styleParentRefs = new LinkedHashSet();
        boolean bl2 = false;
        Set attrRefs = new LinkedHashSet();
        for (AndroidResCapability.Line line : capability.getLines()) {
            String string = line.component1();
            String id = line.component2();
            for (AndroidResSource candidate : context.getProject().getAndroidResSource()) {
                Object v2;
                boolean bl3;
                Object object;
                block7: {
                    Object v0;
                    block6: {
                        object = candidate.getStyleParentRefs();
                        bl3 = false;
                        Iterable iterable = object;
                        boolean bl4 = false;
                        for (Object t : iterable) {
                            AndroidResSource.StyleParentRef styleParentRef = (AndroidResSource.StyleParentRef)t;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)id, (Object)styleParentRef.getStyleParent())) continue;
                            v0 = t;
                            break block6;
                        }
                        v0 = null;
                    }
                    AndroidResSource.StyleParentRef styleParentRef = v0;
                    if (styleParentRef != null) {
                        object = styleParentRef;
                        bl3 = false;
                        boolean bl6 = false;
                        Object it = object;
                        boolean bl7 = false;
                        styleParentRefs.add(it);
                    }
                    object = candidate.getAttrRefs();
                    bl3 = false;
                    Object object2 = object;
                    boolean it = false;
                    Iterator bl7 = object2.iterator();
                    while (bl7.hasNext()) {
                        void type;
                        Object t;
                        t = bl7.next();
                        AndroidResSource.AttrRef attrRef = (AndroidResSource.AttrRef)t;
                        boolean bl8 = false;
                        if (!(Intrinsics.areEqual((Object)type, (Object)attrRef.getType()) && Intrinsics.areEqual((Object)id, (Object)attrRef.getId()))) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                AndroidResSource.AttrRef attrRef = v2;
                if (attrRef == null) continue;
                object = attrRef;
                bl3 = false;
                boolean bl9 = false;
                Object it = object;
                boolean bl10 = false;
                attrRefs.add(it);
            }
        }
        Object object = styleParentRefs;
        boolean bl11 = false;
        if (!object.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.ResByRes.Companion.styleParentRefs(styleParentRefs));
            return true;
        }
        boolean bl12 = false;
        boolean used = bl12;
        if (used) return true;
        object = attrRefs;
        bl11 = false;
        if (object.isEmpty()) return false;
        boolean bl13 = true;
        if (!bl13) return false;
        this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, Reason.ResByRes.Companion.attrRefs(attrRefs));
        return true;
    }

    private final boolean usesInlineMember(Coordinates coordinates, InlineMemberCapability capability, GraphViewVisitor.Context context) {
        boolean bl;
        Set candidateImports2 = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)capability.getInlineMembers()), (Function1)usesInlineMember.candidateImports.1.INSTANCE));
        SortedSet imports2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)context.getProject().getImports()), (Function1)((Function1)new Function1<String, Boolean>(candidateImports2){
            final /* synthetic */ Set $candidateImports;

            public final boolean invoke(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"import");
                return this.$candidateImports.contains(string);
            }
            {
                this.$candidateImports = set2;
                super(1);
            }
        })));
        Collection collection = imports2;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.reportBuilder.set(coordinates, DependencyTraceReport.Kind.DEPENDENCY, new Reason.Inline(imports2));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean usesAnnotationProcessor(Coordinates coordinates, AnnotationProcessorCapability capability, GraphViewVisitor.Context context) {
        return new AnnotationProcessorDetector(coordinates, capability.getSupportedAnnotationTypes(), this.kapt, this.reportBuilder).usesAnnotationProcessor(context);
    }

    public GraphVisitor(@NotNull ProjectVariant project, boolean kapt) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.kapt = kapt;
        this.reportBuilder = new DependencyTraceReport.Builder(project.getBuildType(), project.getFlavor(), project.getVariant());
    }
}

