/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.AnnotationAnalyzer;
import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.ClassRef;
import com.autonomousapps.internal.FieldAnalyzer;
import com.autonomousapps.internal.MethodAnalyzer;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.asm.FieldVisitor;
import com.autonomousapps.internal.asm.MethodVisitor;
import com.autonomousapps.internal.asm.TypePath;
import com.autonomousapps.internal.utils.RegexKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\bH\u0002JK\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010%\u001a\u0004\u0018\u00010\b2\u0010\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010(J\u001a\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u001aH\u0016J8\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\b2\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u00101\u001a\u0004\u0018\u000102H\u0016JE\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010\b2\b\u0010$\u001a\u0004\u0018\u00010\b2\u0010\u00105\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010'H\u0016\u00a2\u0006\u0002\u00106J\u001c\u00107\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u00108\u001a\u0004\u0018\u00010\bH\u0016J,\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020!2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\f\u00a8\u0006="}, d2={"Lcom/autonomousapps/internal/ClassAnalyzer;", "Lcom/autonomousapps/internal/asm/ClassVisitor;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "annotationAnalyzer", "Lcom/autonomousapps/internal/AnnotationAnalyzer;", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "classes", "", "Lcom/autonomousapps/internal/ClassRef;", "getClasses", "()Ljava/util/Set;", "fieldAnalyzer", "Lcom/autonomousapps/internal/FieldAnalyzer;", "methodAnalyzer", "Lcom/autonomousapps/internal/MethodAnalyzer;", "source", "getSource", "setSource", "addClass", "", "kind", "Lcom/autonomousapps/internal/ClassRef$Kind;", "log", "msg", "visit", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitAnnotation", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "descriptor", "visible", "", "visitEnd", "visitField", "Lcom/autonomousapps/internal/asm/FieldVisitor;", "value", "", "visitMethod", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/autonomousapps/internal/asm/MethodVisitor;", "visitSource", "debug", "visitTypeAnnotation", "typeRef", "typePath", "Lcom/autonomousapps/internal/asm/TypePath;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nasm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/ClassAnalyzer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,647:1\n13309#2,2:648\n1855#3,2:650\n1313#4,2:652\n*S KotlinDebug\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/ClassAnalyzer\n*L\n212#1:648,2\n227#1:650,2\n243#1:652,2\n*E\n"})
public final class ClassAnalyzer
extends ClassVisitor {
    @NotNull
    private final Logger logger;
    @Nullable
    private String source;
    public String className;
    @NotNull
    private final Set<ClassRef> classes;
    @NotNull
    private final MethodAnalyzer methodAnalyzer;
    @NotNull
    private final FieldAnalyzer fieldAnalyzer;
    @NotNull
    private final AnnotationAnalyzer annotationAnalyzer;

    public ClassAnalyzer(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(589824);
        this.logger = logger;
        this.classes = new LinkedHashSet();
        this.methodAnalyzer = new MethodAnalyzer(this.logger, this.classes);
        this.fieldAnalyzer = new FieldAnalyzer(this.logger, this.classes);
        this.annotationAnalyzer = new AnnotationAnalyzer(this.logger, this.classes, 0, null, 12, null);
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    public final void setSource(@Nullable String string) {
        this.source = string;
    }

    @NotNull
    public final String getClassName() {
        String string = this.className;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        return null;
    }

    public final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    @NotNull
    public final Set<ClassRef> getClasses() {
        return this.classes;
    }

    private final void addClass(String className, ClassRef.Kind kind) {
        AsmKt.access$addClass(this.classes, className, kind);
    }

    private final void log(String msg2) {
        if (AsmKt.access$getLogDebug$p()) {
            this.logger.debug(msg2);
        } else {
            this.logger.warn(msg2);
        }
    }

    public void visitSource(@Nullable String source, @Nullable String debug) {
        this.log("- visitSource: source=" + source + " debug=" + debug);
        this.source = source;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.log("ClassAnalyzer#visit: " + name + " extends " + superName);
            this.setClassName(name);
            this.addClass("L" + superName + ";", ClassRef.Kind.NOT_ANNOTATION);
            if (interfaces == null) break block1;
            String[] $this$forEach$iv = interfaces;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String i2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                this.addClass("L" + i2 + ";", ClassRef.Kind.NOT_ANNOTATION);
            }
        }
    }

    @NotNull
    public FieldVisitor visitField(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
        block1: {
            this.log("ClassAnalyzer#visitField: " + descriptor + " " + name);
            this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
            Object object = signature;
            if (object == null || (object = RegexKt.genericTypes((String)object)) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.addClass(it, ClassRef.Kind.NOT_ANNOTATION);
            }
        }
        return this.fieldAnalyzer;
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        block1: {
            this.log("ClassAnalyzer#visitMethod: " + name + " " + descriptor);
            String string = descriptor;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)it, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult result = (MatchResult)element$iv;
                boolean bl2 = false;
                this.addClass(result.getValue(), ClassRef.Kind.NOT_ANNOTATION);
            }
        }
        return this.methodAnalyzer;
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@Nullable String descriptor, boolean visible) {
        this.log("ClassAnalyzer#visitAnnotation: descriptor=" + descriptor + " visible=" + visible);
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return this.annotationAnalyzer;
    }

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String descriptor, boolean visible) {
        this.log("ClassAnalyzer#visitTypeAnnotation: typeRef=" + typeRef + " typePath=" + typePath + " descriptor=" + descriptor + " visible=" + visible);
        this.addClass(descriptor, ClassRef.Kind.ANNOTATION);
        return this.annotationAnalyzer;
    }

    public void visitEnd() {
        this.log("\n");
    }
}

