/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model;

import com.autonomousapps.DependencyAnalysisPluginKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.Coordinates;
import com.squareup.moshi.JsonClass;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u0015J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/autonomousapps/model/PhysicalArtifact;", "", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "file", "Ljava/io/File;", "(Lcom/autonomousapps/model/Coordinates;Ljava/io/File;)V", "getCoordinates", "()Lcom/autonomousapps/model/Coordinates;", "getFile", "()Ljava/io/File;", "mode", "Lcom/autonomousapps/model/PhysicalArtifact$Mode;", "getMode", "()Lcom/autonomousapps/model/PhysicalArtifact$Mode;", "compareTo", "", "other", "component1", "component2", "containsClassFiles", "", "copy", "equals", "", "hashCode", "isJar", "toString", "", "Companion", "Mode", "dependency-analysis-gradle-plugin"})
public final class PhysicalArtifact
implements Comparable<PhysicalArtifact> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinates coordinates;
    @NotNull
    private final File file;
    @NotNull
    private final Mode mode;

    public PhysicalArtifact(@NotNull Coordinates coordinates, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.coordinates = coordinates;
        this.file = file;
        if (!(this.isJar() || this.containsClassFiles())) {
            boolean bl = false;
            String string = "'file' must either be a jar or a directory that contains class files. Was '" + this.file + "'";
            throw new IllegalStateException(string.toString());
        }
        this.mode = this.isJar() ? Mode.ZIP : Mode.CLASSES;
    }

    @NotNull
    public final Coordinates getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final boolean isJar() {
        return PhysicalArtifact.Companion.isJar(this.file);
    }

    public final boolean containsClassFiles() {
        return PhysicalArtifact.Companion.containsClassFiles(this.file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull PhysicalArtifact other) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int it = this.coordinates.compareTo(other.coordinates);
        boolean bl = false;
        return it == 0 ? this.file.compareTo(other.file) : var2_2;
    }

    @NotNull
    public final Coordinates component1() {
        return this.coordinates;
    }

    @NotNull
    public final File component2() {
        return this.file;
    }

    @NotNull
    public final PhysicalArtifact copy(@NotNull Coordinates coordinates, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new PhysicalArtifact(coordinates, file);
    }

    public static /* synthetic */ PhysicalArtifact copy$default(PhysicalArtifact physicalArtifact, Coordinates coordinates, File file, int n, Object object) {
        if ((n & 1) != 0) {
            coordinates = physicalArtifact.coordinates;
        }
        if ((n & 2) != 0) {
            file = physicalArtifact.file;
        }
        return physicalArtifact.copy(coordinates, file);
    }

    @NotNull
    public String toString() {
        return "PhysicalArtifact(coordinates=" + this.coordinates + ", file=" + this.file + ")";
    }

    public int hashCode() {
        int result = this.coordinates.hashCode();
        result = result * 31 + this.file.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysicalArtifact)) {
            return false;
        }
        PhysicalArtifact physicalArtifact = (PhysicalArtifact)other;
        if (!Intrinsics.areEqual((Object)this.coordinates, (Object)physicalArtifact.coordinates)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)physicalArtifact.file);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/model/PhysicalArtifact$Companion;", "", "()V", "containsClassFiles", "", "file", "Ljava/io/File;", "isJar", "isValidArtifact", "of", "Lcom/autonomousapps/model/PhysicalArtifact;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "of$dependency_analysis_gradle_plugin", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nPhysicalArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicalArtifact.kt\ncom/autonomousapps/model/PhysicalArtifact$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,69:1\n1247#2,2:70\n*S KotlinDebug\n*F\n+ 1 PhysicalArtifact.kt\ncom/autonomousapps/model/PhysicalArtifact$Companion\n*L\n66#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PhysicalArtifact of$dependency_analysis_gradle_plugin(@NotNull ResolvedArtifactResult artifact, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!this.isValidArtifact(file)) {
                DependencyAnalysisPluginKt.getPROJECT_LOGGER().debug(artifact + " is not valid as a PhysicalArtifact. " + file + " is neither a jar nor a class-files-containing directory");
                return null;
            }
            return new PhysicalArtifact(GradleStringsKt.toCoordinates(artifact), file);
        }

        private final boolean isValidArtifact(File file) {
            return this.isJar(file) || this.containsClassFiles(file);
        }

        private final boolean isJar(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
        }

        private final boolean containsClassFiles(File file) {
            boolean bl;
            block1: {
                Sequence $this$any$iv = (Sequence)FilesKt.walkBottomUp((File)file);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    File f = (File)element$iv;
                    boolean bl2 = false;
                    String string = f.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/autonomousapps/model/PhysicalArtifact$Mode;", "", "(Ljava/lang/String;I)V", "ZIP", "CLASSES", "dependency-analysis-gradle-plugin"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode ZIP = new Mode();
        public static final /* enum */ Mode CLASSES = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.ZIP, Mode.CLASSES};
        }
    }
}

