/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.graph.GraphViewBuilder;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.google.common.graph.Graph;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphTask;", "Lorg/gradle/api/DefaultTask;", "()V", "compileClasspath", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getCompileClasspath", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/DirectoryProperty;", "getOutput", "()Lorg/gradle/api/file/DirectoryProperty;", "runtimeClasspath", "getRuntimeClasspath", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class ProjectGraphTask
extends DefaultTask {
    public ProjectGraphTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Generates a graph view of this project's local dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<ResolvedComponentResult> getCompileClasspath();

    @Input
    @NotNull
    public abstract Property<ResolvedComponentResult> getRuntimeClasspath();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutput();

    @TaskAction
    public final void action() {
        Provider provider = this.getOutput().file("project-compile-classpath.gv");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"output.file(\"project-compile-classpath.gv\")");
        File compileOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider);
        Provider provider2 = this.getOutput().file("project-runtime-classpath.gv");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"output.file(\"project-runtime-classpath.gv\")");
        File runtimeOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider2);
        Object object = this.getCompileClasspath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compileClasspath.get()");
        Graph<Coordinates> compileGraph = new GraphViewBuilder((ResolvedComponentResult)object, SetsKt.emptySet(), true).getGraph();
        Object object2 = this.getRuntimeClasspath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runtimeClasspath.get()");
        Graph<Coordinates> runtimeGraph = new GraphViewBuilder((ResolvedComponentResult)object2, SetsKt.emptySet(), true).getGraph();
        FilesKt.writeText$default((File)compileOutput, (String)GraphWriter.INSTANCE.toDot(compileGraph), null, (int)2, null);
        FilesKt.writeText$default((File)runtimeOutput, (String)GraphWriter.INSTANCE.toDot(runtimeGraph), null, (int)2, null);
    }
}

