/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.MultimapsKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DuplicateClass;
import com.autonomousapps.model.declaration.Variant;
import com.autonomousapps.model.internal.ProjectVariant;
import com.autonomousapps.tasks.DiscoverClasspathDuplicationTask;
import com.google.common.collect.SetMultimap;
import com.squareup.moshi.JsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0004J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/tasks/DiscoverClasspathDuplicationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "classpath", "Lorg/gradle/api/artifacts/ArtifactCollection;", "classpathName", "Lorg/gradle/api/provider/Property;", "", "getClasspathName", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "syntheticProject", "getSyntheticProject", "action", "", "getClasspath", "Lorg/gradle/api/file/FileCollection;", "setClasspath", "artifacts", "withClasspathName", "name", "withClasspathName$dependency_analysis_gradle_plugin", "ClasspathAnalyzer", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDiscoverClasspathDuplicationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscoverClasspathDuplicationTask.kt\ncom/autonomousapps/tasks/DiscoverClasspathDuplicationTask\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,107:1\n117#2,13:108\n41#3,2:121\n34#3,4:123\n70#3,2:127\n42#3:129\n34#3,4:130\n*S KotlinDebug\n*F\n+ 1 DiscoverClasspathDuplicationTask.kt\ncom/autonomousapps/tasks/DiscoverClasspathDuplicationTask\n*L\n53#1:108,13\n53#1:121,2\n53#1:123,4\n56#1:127,2\n56#1:129\n56#1:130,4\n*E\n"})
public abstract class DiscoverClasspathDuplicationTask
extends DefaultTask {
    private ArtifactCollection classpath;

    public DiscoverClasspathDuplicationTask() {
        this.setGroup("dependency-analysis");
    }

    public final void withClasspathName$dependency_analysis_gradle_plugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setDescription("Discovers duplicates on the " + name + " classpath");
        this.getClasspathName().set((Object)name);
    }

    public final void setClasspath(@NotNull ArtifactCollection artifacts) {
        Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
        this.classpath = artifacts;
    }

    @Classpath
    @NotNull
    public final FileCollection getClasspath() {
        ArtifactCollection artifactCollection = this.classpath;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classpath");
            artifactCollection = null;
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"classpath.artifactFiles");
        return fileCollection;
    }

    @Input
    @NotNull
    public abstract Property<String> getClasspathName();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getSyntheticProject();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void action() {
        Set<DuplicateClass> duplicates;
        Object object;
        File output = UtilsKt.getAndDelete(this.getOutput());
        RegularFileProperty $this$fromJson$iv = this.getSyntheticProject();
        boolean $i$f$fromJson = false;
        Object object2 = $this$fromJson$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
        boolean $i$f$fromJson2 = false;
        File file = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
        File $this$fromJson$iv$iv$iv = file;
        boolean $i$f$fromJson3 = false;
        Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
        Throwable throwable = null;
        try {
            BufferedSource reader$iv$iv$iv = (BufferedSource)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectVariant.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            Object object3 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object3);
            object = object3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ProjectVariant project = (ProjectVariant)object;
        Object object4 = this.getClasspathName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"classpathName.get()");
        String string = (String)object4;
        ArtifactCollection artifactCollection = this.classpath;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classpath");
            artifactCollection = null;
        }
        Set<DuplicateClass> $this$toJson_u24default$iv = duplicates = new ClasspathAnalyzer(project, string, artifactCollection).duplicates();
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(Set.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
        JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
        boolean $i$f$withNulls = false;
        String string2 = $this$withNulls$iv$iv$iv.toJson($this$toJson_u24default$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)output, (String)string2, null, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/tasks/DiscoverClasspathDuplicationTask$ClasspathAnalyzer;", "", "project", "Lcom/autonomousapps/model/internal/ProjectVariant;", "classpathName", "", "artifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "(Lcom/autonomousapps/model/internal/ProjectVariant;Ljava/lang/String;Lorg/gradle/api/artifacts/ArtifactCollection;)V", "duplicatesMap", "Lcom/google/common/collect/SetMultimap;", "Lcom/autonomousapps/model/Coordinates;", "duplicates", "", "Lcom/autonomousapps/model/DuplicateClass;", "inspectJar", "", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDiscoverClasspathDuplicationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscoverClasspathDuplicationTask.kt\ncom/autonomousapps/tasks/DiscoverClasspathDuplicationTask$ClasspathAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,107:1\n774#2:108\n865#2,2:109\n1863#2,2:111\n503#3,7:113\n487#3,7:120\n153#4,3:127\n1317#5,2:130\n*S KotlinDebug\n*F\n+ 1 DiscoverClasspathDuplicationTask.kt\ncom/autonomousapps/tasks/DiscoverClasspathDuplicationTask$ClasspathAnalyzer\n*L\n71#1:108\n71#1:109,2\n72#1:111,2\n78#1:113,7\n80#1:120,7\n84#1:127,3\n103#1:130,2\n*E\n"})
    public static final class ClasspathAnalyzer {
        @NotNull
        private final ProjectVariant project;
        @NotNull
        private final String classpathName;
        @NotNull
        private final SetMultimap<String, Coordinates> duplicatesMap;

        /*
         * WARNING - void declaration
         */
        public ClasspathAnalyzer(@NotNull ProjectVariant project, @NotNull String classpathName, @NotNull ArtifactCollection artifacts) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)classpathName, (String)"classpathName");
            Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
            this.project = project;
            this.classpathName = classpathName;
            this.duplicatesMap = MultimapsKt.newSetMultimap();
            Iterable iterable = CollectionsKt.filterNonGradle(artifacts);
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
                boolean bl = false;
                String string = it.getFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.file.name");
                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResolvedArtifactResult p0 = (ResolvedArtifactResult)element$iv;
                boolean $i$f$_init_$stub_for_inlining = false;
                boolean bl = false;
                this.inspectJar(p0);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<DuplicateClass> duplicates() {
            void var2_3;
            void $this$mapTo$iv;
            Object it;
            Map map = this.duplicatesMap.asMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"duplicatesMap.asMap()");
            Map $this$filterValues$iv = map;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                it = (Collection)entry$iv.getValue();
                boolean bl = false;
                if (!(it.size() > 1)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $this$filterKeys$iv = result$iv;
            boolean $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                it = (String)entry$iv.getKey();
                boolean bl = false;
                Set<String> set2 = this.project.getUsedClasses();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!set2.contains(StringsKt.removeSuffix((String)StringsKt.replace$default((String)it, (char)'/', (char)'.', (boolean)false, (int)4, null), (CharSequence)".class"))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv;
                Map.Entry entry = item$iv = iterator.next();
                Collection collection = destination$iv;
                boolean bl = false;
                String classReference = (String)entry.getKey();
                Collection dependency = (Collection)entry.getValue();
                Variant variant = this.project.getVariant();
                Intrinsics.checkNotNullExpressionValue((Object)classReference, (String)"classReference");
                String string = StringsKt.removeSuffix((String)classReference, (CharSequence)".class");
                Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependency");
                collection.add(new DuplicateClass(variant, this.classpathName, string, kotlin.collections.CollectionsKt.toSortedSet((Iterable)dependency)));
            }
            return (Set)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        private final void inspectJar(ResolvedArtifactResult artifact) {
            void $this$forEach$iv;
            ZipFile zip = new ZipFile(artifact.getFile());
            Coordinates coordinates = GradleStringsKt.toCoordinates(artifact);
            Sequence sequence = SequencesKt.map(CollectionsKt.asSequenceOfClassFiles(zip), (Function1)inspectJar.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.duplicatesMap.put((Object)it, (Object)coordinates);
            }
        }
    }
}

