/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.extension.ReportingHandler;
import com.autonomousapps.extension.ReportingHandlerKt;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.advice.ProjectHealthConsoleReportBuilder;
import com.autonomousapps.internal.utils.Colors;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.BuildHealth;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0007J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0018\u001a\u00020\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/autonomousapps/tasks/GenerateBuildHealthTask;", "Lorg/gradle/api/DefaultTask;", "()V", "consoleOutput", "Lorg/gradle/api/file/RegularFileProperty;", "getConsoleOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dslKind", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "()Lorg/gradle/api/provider/Property;", "output", "getOutput", "outputFail", "getOutputFail", "projectCount", "", "getProjectCount", "projectHealthReports", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getProjectHealthReports", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "reportingConfig", "Lcom/autonomousapps/extension/ReportingHandler$Config;", "getReportingConfig", "action", "", "isFunctionallyEmpty", "", "advice", "", "Lcom/autonomousapps/model/ProjectAdvice;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateBuildHealthTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateBuildHealthTask.kt\ncom/autonomousapps/tasks/GenerateBuildHealthTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,175:1\n1557#2:176\n1628#2,2:177\n1630#2:187\n669#2,11:200\n128#3,2:179\n40#4,2:181\n33#4,4:183\n176#4,3:189\n40#4,2:192\n33#4,4:194\n179#4,2:198\n607#5:188\n*S KotlinDebug\n*F\n+ 1 GenerateBuildHealthTask.kt\ncom/autonomousapps/tasks/GenerateBuildHealthTask\n*L\n76#1:176\n76#1:177,2\n76#1:187\n168#1:200,11\n76#1:179,2\n76#1:181,2\n76#1:183,4\n146#1:189,3\n146#1:192,2\n146#1:194,4\n146#1:198,2\n89#1:188\n*E\n"})
public abstract class GenerateBuildHealthTask
extends DefaultTask {
    public GenerateBuildHealthTask() {
        this.setDescription("Generates json report for build health");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getProjectHealthReports();

    @Nested
    @NotNull
    public abstract Property<ReportingHandler.Config> getReportingConfig();

    @Input
    @NotNull
    public abstract Property<Integer> getProjectCount();

    @Input
    @NotNull
    public abstract Property<DslKind> getDslKind();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getConsoleOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFail();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$sortedBy$iv;
        File file;
        void $this$mapTo$iv$iv;
        File output = UtilsKt.getAndDelete(this.getOutput());
        File consoleOutput = UtilsKt.getAndDelete(this.getConsoleOutput());
        File outputFail = UtilsKt.getAndDelete(this.getOutputFail());
        Ref.BooleanRef didWrite = new Ref.BooleanRef();
        Ref.BooleanRef shouldFail = new Ref.BooleanRef();
        Ref.IntRef unusedDependencies = new Ref.IntRef();
        Ref.IntRef undeclaredDependencies = new Ref.IntRef();
        Ref.IntRef misDeclaredDependencies = new Ref.IntRef();
        Ref.IntRef compileOnlyDependencies = new Ref.IntRef();
        Ref.IntRef runtimeOnlyDependencies = new Ref.IntRef();
        Ref.IntRef processorDependencies = new Ref.IntRef();
        BuildHealth.AndroidScoreMetrics.Builder androidMetricsBuilder = new BuildHealth.AndroidScoreMetrics.Builder();
        Set set2 = this.getProjectHealthReports().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"projectHealthReports.files");
        Iterable $this$map$iv = set2;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            void $this$fromJson$iv = it;
            boolean $i$f$fromJson = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead((File)$this$fromJson$iv);
            Throwable throwable = null;
            try {
                JsonAdapter $this$withNulls$iv$iv$iv;
                BufferedSource reader$iv = (BufferedSource)closeable;
                boolean bl2 = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(ProjectAdvice.class), (String)"MOSHI.adapter(T::class.java)");
                boolean $i$f$withNulls = false;
                Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv.fromJson(reader$iv));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            collection.add((ProjectAdvice)object);
        }
        List advice = (List)destination$iv$iv;
        if (this.isFunctionallyEmpty(advice)) {
            this.getLogger().warn("No project health reports found. Is 'com.autonomousapps.dependency-analysis' not applied to any subprojects in this build?\nSee https://github.com/autonomousapps/dependency-analysis-gradle-plugin/wiki/Adding-to-your-project");
        }
        Sequence $i$f$map22 = CollectionsKt.asSequence((Iterable)advice);
        boolean $i$f$sortedBy = false;
        Set projectAdvice2 = SequencesKt.toSortedSet((Sequence)SequencesKt.onEach((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectAdvice it = (ProjectAdvice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getProjectPath());
                it = (ProjectAdvice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getProjectPath())));
            }
        }), (Function1)((Function1)new Function1<ProjectAdvice, Unit>(didWrite, consoleOutput, shouldFail, this, unusedDependencies, undeclaredDependencies, misDeclaredDependencies, compileOnlyDependencies, runtimeOnlyDependencies, processorDependencies, androidMetricsBuilder){
            final /* synthetic */ Ref.BooleanRef $didWrite;
            final /* synthetic */ File $consoleOutput;
            final /* synthetic */ Ref.BooleanRef $shouldFail;
            final /* synthetic */ GenerateBuildHealthTask this$0;
            final /* synthetic */ Ref.IntRef $unusedDependencies;
            final /* synthetic */ Ref.IntRef $undeclaredDependencies;
            final /* synthetic */ Ref.IntRef $misDeclaredDependencies;
            final /* synthetic */ Ref.IntRef $compileOnlyDependencies;
            final /* synthetic */ Ref.IntRef $runtimeOnlyDependencies;
            final /* synthetic */ Ref.IntRef $processorDependencies;
            final /* synthetic */ BuildHealth.AndroidScoreMetrics.Builder $androidMetricsBuilder;
            {
                this.$didWrite = $didWrite;
                this.$consoleOutput = $consoleOutput;
                this.$shouldFail = $shouldFail;
                this.this$0 = $receiver;
                this.$unusedDependencies = $unusedDependencies;
                this.$undeclaredDependencies = $undeclaredDependencies;
                this.$misDeclaredDependencies = $misDeclaredDependencies;
                this.$compileOnlyDependencies = $compileOnlyDependencies;
                this.$runtimeOnlyDependencies = $runtimeOnlyDependencies;
                this.$processorDependencies = $processorDependencies;
                this.$androidMetricsBuilder = $androidMetricsBuilder;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ProjectAdvice projectAdvice2) {
                Intrinsics.checkNotNullParameter((Object)projectAdvice2, (String)"projectAdvice");
                if (projectAdvice2.isNotEmpty()) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$forEach$iv;
                    if (this.$didWrite.element) {
                        FilesKt.appendText$default((File)this.$consoleOutput, (String)"\n\n", null, (int)2, null);
                    }
                    this.$shouldFail.element = this.$shouldFail.element || projectAdvice2.getShouldFail();
                    Object object = this.this$0.getDslKind().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dslKind.get()");
                    DslKind dslKind = (DslKind)((Object)object);
                    Object object2 = this.this$0.getDependencyMap().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"dependencyMap.get()");
                    String report = new ProjectHealthConsoleReportBuilder(projectAdvice2, "", dslKind, DependenciesHandler.Companion.toLambda((Map)object2)).getText();
                    String projectPath = Intrinsics.areEqual((Object)projectAdvice2.getProjectPath(), (Object)":") ? "root project" : projectAdvice2.getProjectPath();
                    FilesKt.appendText$default((File)this.$consoleOutput, (String)("Advice for " + projectPath + "\n" + report), null, (int)2, null);
                    this.$didWrite.element = true;
                    Iterable iterable = projectAdvice2.getDependencyAdvice();
                    Ref.IntRef intRef = this.$unusedDependencies;
                    Object object3 = this.$undeclaredDependencies;
                    Ref.IntRef intRef2 = this.$misDeclaredDependencies;
                    Ref.IntRef intRef3 = this.$compileOnlyDependencies;
                    Ref.IntRef intRef4 = this.$runtimeOnlyDependencies;
                    Ref.IntRef intRef5 = this.$processorDependencies;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        int n;
                        Advice it = (Advice)element$iv;
                        boolean bl = false;
                        if (it.isRemove()) {
                            n = intRef.element;
                            intRef.element = n + 1;
                            continue;
                        }
                        if (it.isAdd()) {
                            n = object3.element;
                            object3.element = n + 1;
                            continue;
                        }
                        if (it.isChange()) {
                            n = intRef2.element;
                            intRef2.element = n + 1;
                            continue;
                        }
                        if (it.isCompileOnly()) {
                            n = intRef3.element;
                            intRef3.element = n + 1;
                            continue;
                        }
                        if (it.isRuntimeOnly()) {
                            n = intRef4.element;
                            intRef4.element = n + 1;
                            continue;
                        }
                        if (!it.isProcessor()) continue;
                        n = intRef5.element;
                        intRef5.element = n + 1;
                    }
                    Iterable $this$filterIsInstance$iv = projectAdvice2.getModuleAdvice();
                    boolean $i$f$filterIsInstance = false;
                    object3 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof AndroidScore)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    BuildHealth.AndroidScoreMetrics.Builder builder = this.$androidMetricsBuilder;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv : $this$forEach$iv) {
                        int n;
                        AndroidScore it = (AndroidScore)element$iv;
                        boolean bl = false;
                        if (it.shouldBeJvm()) {
                            n = builder.getShouldBeJvmCount();
                            builder.setShouldBeJvmCount(n + 1);
                            continue;
                        }
                        if (!it.couldBeJvm()) continue;
                        n = builder.getCouldBeJvmCount();
                        builder.setCouldBeJvmCount(n + 1);
                    }
                }
            }
        })));
        BuildHealth buildHealth = new BuildHealth(projectAdvice2, shouldFail.element, projectAdvice2.size(), unusedDependencies.element, undeclaredDependencies.element, misDeclaredDependencies.element, compileOnlyDependencies.element, runtimeOnlyDependencies.element, processorDependencies.element, androidMetricsBuilder.build());
        File $this$bufferWriteJson_u24default$iv = output;
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(BuildHealth.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)buildHealth);
            file = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FilesKt.writeText$default((File)outputFail, (String)String.valueOf(shouldFail.element), null, (int)2, null);
        if (!didWrite.element) {
            FilesKt.writeText$default((File)consoleOutput, (String)"", null, (int)2, null);
        } else {
            Object object = this.getReportingConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reportingConfig.get()");
            ReportingHandler.Config reportingConfig = (ReportingHandler.Config)object;
            String ps = ReportingHandlerKt.getEffectivePostscript(reportingConfig, shouldFail.element);
            if (((CharSequence)ps).length() > 0) {
                FilesKt.appendText$default((File)consoleOutput, (String)("\n\n" + Colors.INSTANCE.colorize$dependency_analysis_gradle_plugin(ps, "\u001b[1m")), null, (int)2, null);
            }
        }
    }

    private final boolean isFunctionallyEmpty(Collection<ProjectAdvice> advice) {
        if (advice.isEmpty()) {
            return true;
        }
        if (advice.size() == 1) {
            Object v0;
            block5: {
                Iterable $this$singleOrNull$iv = advice;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ProjectAdvice it = (ProjectAdvice)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getProjectPath(), (Object)":")) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if (v0 != null) {
                Integer n = (Integer)this.getProjectCount().get();
                int n2 = 1;
                return n == null || n != n2;
            }
        }
        return false;
    }
}

