/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.consumer.ExplodingSourceCode;
import com.autonomousapps.tasks.SourceExploder;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0007R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/tasks/CodeSourceExploderTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/ProjectLayout;)V", "groovySourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getGroovySourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "javaSourceFiles", "getJavaSourceFiles", "kotlinSourceFiles", "getKotlinSourceFiles", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "scalaSourceFiles", "getScalaSourceFiles", "action", "", "CodeSourceExploderParameters", "CodeSourceExploderWorkAction", "dependency-analysis-gradle-plugin"})
public abstract class CodeSourceExploderTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final ProjectLayout layout;

    @Inject
    public CodeSourceExploderTask(@NotNull WorkerExecutor workerExecutor, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.workerExecutor = workerExecutor;
        this.layout = layout;
        this.setDescription("Parses Java and Kotlin source to detect source-only usages");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getGroovySourceFiles();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getJavaSourceFiles();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getKotlinSourceFiles();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getScalaSourceFiles();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(CodeSourceExploderWorkAction.class, new Action(this){
            final /* synthetic */ CodeSourceExploderTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(CodeSourceExploderParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                $this$submit.getProjectDir().set((Object)CodeSourceExploderTask.access$getLayout$p(this.this$0).getProjectDirectory());
                Object[] objectArray = new Object[]{this.this$0.getGroovySourceFiles()};
                $this$submit.getGroovySourceFiles().from(objectArray);
                objectArray = new Object[]{this.this$0.getJavaSourceFiles()};
                $this$submit.getJavaSourceFiles().from(objectArray);
                objectArray = new Object[]{this.this$0.getKotlinSourceFiles()};
                $this$submit.getKotlinSourceFiles().from(objectArray);
                objectArray = new Object[]{this.this$0.getScalaSourceFiles()};
                $this$submit.getScalaSourceFiles().from(objectArray);
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
        });
    }

    public static final /* synthetic */ ProjectLayout access$getLayout$p(CodeSourceExploderTask $this) {
        return $this.layout;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderParameters;", "Lorg/gradle/workers/WorkParameters;", "groovySourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getGroovySourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "javaSourceFiles", "getJavaSourceFiles", "kotlinSourceFiles", "getKotlinSourceFiles", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "projectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDir", "()Lorg/gradle/api/file/DirectoryProperty;", "scalaSourceFiles", "getScalaSourceFiles", "dependency-analysis-gradle-plugin"})
    public static interface CodeSourceExploderParameters
    extends WorkParameters {
        @NotNull
        public DirectoryProperty getProjectDir();

        @NotNull
        public ConfigurableFileCollection getGroovySourceFiles();

        @NotNull
        public ConfigurableFileCollection getJavaSourceFiles();

        @NotNull
        public ConfigurableFileCollection getKotlinSourceFiles();

        @NotNull
        public ConfigurableFileCollection getScalaSourceFiles();

        @NotNull
        public RegularFileProperty getOutput();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderParameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nCodeSourceExploderTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeSourceExploderTask.kt\ncom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderWorkAction\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,155:1\n149#2,3:156\n49#2,3:159\n33#2,4:162\n152#2,2:166\n*S KotlinDebug\n*F\n+ 1 CodeSourceExploderTask.kt\ncom/autonomousapps/tasks/CodeSourceExploderTask$CodeSourceExploderWorkAction\n*L\n89#1:156,3\n89#1:159,3\n89#1:162,4\n89#1:166,2\n*E\n"})
    public static abstract class CodeSourceExploderWorkAction
    implements WorkAction<CodeSourceExploderParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            File reportFile = UtilsKt.getAndDelete(((CodeSourceExploderParameters)this.getParameters()).getOutput());
            File file = ((Directory)((CodeSourceExploderParameters)this.getParameters()).getProjectDir().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.projectDir.get().asFile");
            Set<ExplodingSourceCode> explodedSource = new SourceExploder(file, ((CodeSourceExploderParameters)this.getParameters()).getGroovySourceFiles(), ((CodeSourceExploderParameters)this.getParameters()).getJavaSourceFiles(), ((CodeSourceExploderParameters)this.getParameters()).getKotlinSourceFiles(), ((CodeSourceExploderParameters)this.getParameters()).getScalaSourceFiles()).explode();
            File $this$bufferWriteJsonSet_u24default$iv = reportFile;
            String indent$iv = "";
            boolean $i$f$bufferWriteJsonSet = false;
            Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable = null;
            try {
                JsonWriter writer$iv = (JsonWriter)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{ExplodingSourceCode.class};
                ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, explodedSource);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

