/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.parse.AndroidManifestParser;
import com.autonomousapps.internal.parse.ExplodedManifest;
import com.autonomousapps.model.internal.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u00130\u0016H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/internal/parse/AndroidManifestParser;", "", "projectDir", "Ljava/io/File;", "manifests", "", "namespace", "", "(Ljava/io/File;Ljava/lang/Iterable;Ljava/lang/String;)V", "explodedManifests", "", "Lcom/autonomousapps/internal/parse/ExplodedManifest;", "getExplodedManifests", "()Ljava/util/Set;", "parser", "Lcom/autonomousapps/internal/ManifestParser;", "compute", "parseManifests", "toExplodedManifest", "Lkotlin/Pair;", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "toExplodedManifests", "Lkotlin/sequences/Sequence;", "dependency-analysis-gradle-plugin"})
public final class AndroidManifestParser {
    @NotNull
    private final File projectDir;
    @NotNull
    private final Iterable<File> manifests;
    @NotNull
    private final String namespace;
    @NotNull
    private final ManifestParser parser;
    @NotNull
    private final Set<ExplodedManifest> explodedManifests;

    public AndroidManifestParser(@NotNull File projectDir, @NotNull Iterable<? extends File> manifests, @NotNull String namespace2) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        this.projectDir = projectDir;
        this.manifests = manifests;
        this.namespace = namespace2;
        this.parser = new ManifestParser(this.namespace);
        this.explodedManifests = this.compute();
    }

    @NotNull
    public final Set<ExplodedManifest> getExplodedManifests() {
        return this.explodedManifests;
    }

    private final Set<ExplodedManifest> compute() {
        String string;
        if (!StringsKt.isBlank((CharSequence)this.namespace)) {
            return this.parseManifests();
        }
        List parseResults = new ArrayList();
        List malformedManifests = new ArrayList();
        for (File manifest : this.manifests) {
            if (!manifest.exists()) continue;
            try {
                ((Collection)parseResults).add(TuplesKt.to((Object)manifest, (Object)ManifestParser.parse$default(this.parser, manifest, false, 2, null)));
            }
            catch (ManifestParser.ManifestParseException manifestParseException) {
                ((Collection)malformedManifests).add(manifest);
            }
        }
        Object object = (Pair)CollectionsKt.firstOrNull((List)parseResults);
        if ((object != null && (object = (ManifestParser.ParseResult)object.getSecond()) != null ? ((ManifestParser.ParseResult)object).getPackageName() : (string = null)) == null) {
            string = "";
        }
        String mainNamespace = string;
        ManifestParser malformedParser = new ManifestParser(mainNamespace);
        for (File remainder : malformedManifests) {
            ((Collection)parseResults).add(TuplesKt.to((Object)remainder, (Object)ManifestParser.parse$default(malformedParser, remainder, false, 2, null)));
        }
        return this.toExplodedManifests((Sequence<? extends Pair<? extends File, ManifestParser.ParseResult>>)CollectionsKt.asSequence((Iterable)parseResults));
    }

    private final Set<ExplodedManifest> parseManifests() {
        return this.toExplodedManifests((Sequence<? extends Pair<? extends File, ManifestParser.ParseResult>>)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(this.manifests), (Function1)parseManifests.1.INSTANCE), (Function1)((Function1)new Function1<File, Pair<? extends File, ? extends ManifestParser.ParseResult>>(this){
            final /* synthetic */ AndroidManifestParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Pair<File, ManifestParser.ParseResult> invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TuplesKt.to((Object)it, (Object)ManifestParser.parse$default(AndroidManifestParser.access$getParser$p(this.this$0), it, false, 2, null));
            }
        })));
    }

    private final Set<ExplodedManifest> toExplodedManifests(Sequence<? extends Pair<? extends File, ManifestParser.ParseResult>> $this$toExplodedManifests) {
        return SequencesKt.toSet((Sequence)SequencesKt.map($this$toExplodedManifests, (Function1)((Function1)new Function1<Pair<? extends File, ? extends ManifestParser.ParseResult>, ExplodedManifest>(this){
            final /* synthetic */ AndroidManifestParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ExplodedManifest invoke(Pair<? extends File, ManifestParser.ParseResult> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return AndroidManifestParser.access$toExplodedManifest(this.this$0, it);
            }
        })));
    }

    private final ExplodedManifest toExplodedManifest(Pair<? extends File, ManifestParser.ParseResult> $this$toExplodedManifest) {
        File file = (File)$this$toExplodedManifest.getFirst();
        ManifestParser.ParseResult parseResult = (ManifestParser.ParseResult)$this$toExplodedManifest.getSecond();
        String applicationName = parseResult.getApplicationName();
        AndroidResSource.AttrRef theme = AndroidResSource.AttrRef.Companion.style(parseResult.getTheme());
        return new ExplodedManifest(FilesKt.toRelativeString((File)file, (File)this.projectDir), applicationName, theme);
    }

    public static final /* synthetic */ ManifestParser access$getParser$p(AndroidManifestParser $this) {
        return $this.parser;
    }

    public static final /* synthetic */ ExplodedManifest access$toExplodedManifest(AndroidManifestParser $this, Pair $receiver) {
        return $this.toExplodedManifest((Pair<? extends File, ManifestParser.ParseResult>)$receiver);
    }
}

