/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.parse.AndroidResParser;
import com.autonomousapps.internal.parse.ExplodedRes;
import com.autonomousapps.internal.utils.document.DocumentKt;
import com.autonomousapps.model.internal.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResParser;", "", "projectDir", "Ljava/io/File;", "resources", "", "(Ljava/io/File;Ljava/lang/Iterable;)V", "androidResSource", "", "Lcom/autonomousapps/internal/parse/ExplodedRes;", "getAndroidResSource", "()Ljava/util/Set;", "container", "Lcom/autonomousapps/internal/parse/AndroidResParser$Container;", "extractAttrsFromResourceXml", "", "doc", "Lorg/w3c/dom/Document;", "extractContentReferencesFromResourceXml", "extractStyleParentsFromResourceXml", "Lcom/autonomousapps/model/internal/AndroidResSource$StyleParentRef;", "Container", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nexplodeAndroidResSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidResParser\n+ 2 document.kt\ncom/autonomousapps/internal/utils/document/DocumentKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n55#2,3:203\n59#2:207\n1#3:206\n108#4:208\n1628#5,3:209\n1863#5,2:212\n1863#5,2:214\n*S KotlinDebug\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidResParser\n*L\n84#1:203,3\n84#1:207\n84#1:206\n87#1:208\n87#1:209,3\n92#1:212,2\n98#1:214,2\n*E\n"})
public final class AndroidResParser {
    @NotNull
    private final Container container;
    @NotNull
    private final Set<ExplodedRes> androidResSource;

    public AndroidResParser(@NotNull File projectDir, @NotNull Iterable<? extends File> resources) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.container = new Container();
        this.androidResSource = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence(resources), (Function1)androidResSource.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Document>, ExplodedRes>(this, projectDir){
            final /* synthetic */ AndroidResParser this$0;
            final /* synthetic */ File $projectDir;
            {
                this.this$0 = $receiver;
                this.$projectDir = $projectDir;
                super(1);
            }

            public final ExplodedRes invoke(Pair<? extends File, ? extends Document> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                File file = (File)pair.component1();
                Document doc = (Document)pair.component2();
                AndroidResParser.access$extractAttrsFromResourceXml(this.this$0, doc);
                AndroidResParser.access$extractContentReferencesFromResourceXml(this.this$0, doc);
                return new ExplodedRes(FilesKt.toRelativeString((File)file, (File)this.$projectDir), AndroidResParser.access$extractStyleParentsFromResourceXml(this.this$0, doc), AndroidResParser.access$getContainer$p(this.this$0).nonLocalAttrRefs());
            }
        })));
    }

    @NotNull
    public final Set<ExplodedRes> getAndroidResSource() {
        return this.androidResSource;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AndroidResSource.StyleParentRef> extractStyleParentsFromResourceXml(Document doc) {
        void $this$mapTo$iv$iv;
        String it$iv;
        NodeList nodeList = doc.getElementsByTagName("style");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"doc.getElementsByTagName(\"style\")");
        NodeList $this$mapNotNull$iv = nodeList;
        boolean $i$f$mapNotNull = false;
        Iterable<String> destination$iv = new ArrayList($this$mapNotNull$iv.getLength());
        int n = $this$mapNotNull$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Node it;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapNotNull$iv.item(i$iv), (String)"item(i)");
            boolean bl = false;
            Node node = it.getAttributes().getNamedItem("parent");
            if ((node != null ? node.getNodeValue() : null) == null) continue;
            it$iv = it$iv;
            boolean bl2 = false;
            ((ArrayList)destination$iv).add(it$iv);
        }
        Iterable $this$mapToSet$iv = (List)destination$iv;
        boolean $i$f$mapToSet = false;
        destination$iv = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(com.autonomousapps.internal.utils.CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            it$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AndroidResSource.StyleParentRef.Companion.of((String)it));
        }
        return (Set)destination$iv$iv;
    }

    private final void extractAttrsFromResourceXml(Document doc) {
        Iterable $this$forEach$iv = DocumentKt.attrs(doc);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            AndroidResSource.AttrRef.Companion.from$dependency_analysis_gradle_plugin((Pair<String, String>)it, this.container);
        }
    }

    private final void extractContentReferencesFromResourceXml(Document doc) {
        Iterable $this$forEach$iv = DocumentKt.contentReferences(doc).entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            AndroidResSource.AttrRef.Companion.from$dependency_analysis_gradle_plugin((Pair<String, String>)TuplesKt.to(it.getKey(), it.getValue()), this.container);
        }
    }

    public static final /* synthetic */ void access$extractAttrsFromResourceXml(AndroidResParser $this, Document doc) {
        $this.extractAttrsFromResourceXml(doc);
    }

    public static final /* synthetic */ void access$extractContentReferencesFromResourceXml(AndroidResParser $this, Document doc) {
        $this.extractContentReferencesFromResourceXml(doc);
    }

    public static final /* synthetic */ Set access$extractStyleParentsFromResourceXml(AndroidResParser $this, Document doc) {
        return $this.extractStyleParentsFromResourceXml(doc);
    }

    public static final /* synthetic */ Container access$getContainer$p(AndroidResParser $this) {
        return $this.container;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResParser$Container;", "", "()V", "attrRefs", "", "Lcom/autonomousapps/model/internal/AndroidResSource$AttrRef;", "getAttrRefs", "()Ljava/util/Set;", "newIds", "getNewIds", "nonLocalAttrRefs", "", "dependency-analysis-gradle-plugin"})
    public static final class Container {
        @NotNull
        private final Set<AndroidResSource.AttrRef> attrRefs = new LinkedHashSet();
        @NotNull
        private final Set<AndroidResSource.AttrRef> newIds = new LinkedHashSet();

        @NotNull
        public final Set<AndroidResSource.AttrRef> getAttrRefs() {
            return this.attrRefs;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> getNewIds() {
            return this.newIds;
        }

        @NotNull
        public final Set<AndroidResSource.AttrRef> nonLocalAttrRefs() {
            return SetsKt.minus(this.attrRefs, (Iterable)this.newIds);
        }
    }
}

